/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.StaticUtils;

public class ExportJob {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.ExportJob";
    private LDIFExportConfig exportConfig;
    private long progressInterval = 10000L;
    private long exportedCount = 0L;
    private long skippedCount = 0L;

    public ExportJob(LDIFExportConfig lDIFExportConfig) {
        this.exportConfig = lDIFExportConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLDIF(RootContainer rootContainer) throws IOException, LDIFException, DatabaseException, JebException {
        List<DN> list = this.exportConfig.getIncludeBranches();
        ArrayList<EntryContainer> arrayList = new ArrayList<EntryContainer>();
        for (EntryContainer entryContainer : rootContainer.getEntryContainers()) {
            DN dN = entryContainer.getBaseDN();
            if (list == null || list.isEmpty()) {
                arrayList.add(entryContainer);
                continue;
            }
            for (DN object2 : list) {
                if (!object2.isDescendantOf(dN) && !object2.isAncestorOf(dN)) continue;
                arrayList.add(entryContainer);
            }
        }
        long l = System.currentTimeMillis();
        Timer timer = new Timer();
        ProgressTask progressTask = new ProgressTask();
        timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
        try {
            for (EntryContainer entryContainer : arrayList) {
                this.exportContainer(entryContainer);
            }
        }
        finally {
            timer.cancel();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        float f = 0.0f;
        if (l3 > 0L) {
            f = 1000.0f * (float)this.exportedCount / (float)l3;
        }
        int n = 8388695;
        String string = MessageHandler.getMessage(n, this.exportedCount, this.skippedCount, l3 / 1000L, Float.valueOf(f));
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportContainer(EntryContainer entryContainer) throws DatabaseException, IOException, LDIFException {
        ID2Entry iD2Entry = entryContainer.getID2Entry();
        Cursor cursor = iD2Entry.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                block13: {
                    EntryID entryID = null;
                    try {
                        entryID = new EntryID(databaseEntry);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "exportContainer", exception));
                        ++this.skippedCount;
                        System.err.printf("Malformed id2entry ID %s.%n", StaticUtils.bytesToHex(databaseEntry.getData()));
                        break block13;
                    }
                    if (entryID.longValue() != 0L) {
                        Entry entry = null;
                        try {
                            entry = JebFormat.entryFromDatabase(databaseEntry2.getData());
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "exportContainer", exception));
                            ++this.skippedCount;
                            System.err.printf("Malformed id2entry record for ID %d:%n%s%n", entryID.longValue(), StaticUtils.bytesToHex(databaseEntry2.getData()));
                            break block13;
                        }
                        if (entry.toLDIF(this.exportConfig)) {
                            ++this.exportedCount;
                        } else {
                            ++this.skippedCount;
                        }
                    }
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
        }
        finally {
            cursor.close();
        }
    }

    class ProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();

        public void run() {
            long l = ExportJob.this.exportedCount;
            long l2 = l - this.previousCount;
            long l3 = System.currentTimeMillis();
            long l4 = l3 - this.previousTime;
            if (l4 == 0L) {
                return;
            }
            float f = 1000.0f * (float)l2 / (float)l4;
            int n = 0x800058;
            String string = MessageHandler.getMessage(n, l, ExportJob.this.skippedCount, Float.valueOf(f));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
            this.previousCount = l;
            this.previousTime = l3;
        }
    }
}

