/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilePermission;
import org.opends.server.types.RDN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.Config";
    public static final String OBJECT_CLASS_CONFIG_ATTR_INDEX = "ds-cfg-je-index";
    public static final String OBJECT_CLASS_CONFIG_DATABASE = "ds-cfg-je-database";
    public static final String ATTR_INDEX_ATTRIBUTE = "ds-cfg-index-attribute";
    public static final String ATTR_INDEX_TYPE = "ds-cfg-index-type";
    public static final String ATTR_INDEX_ENTRY_LIMIT = "ds-cfg-index-entry-limit";
    public static final String ATTR_INDEX_SUBSTRING_LENGTH = "ds-cfg-index-substring-length";
    public static final String ATTR_BACKEND_INDEX_ENTRY_LIMIT = "ds-cfg-backend-index-entry-limit";
    public static final String ATTR_SUBTREE_DELETE_SIZE_LIMIT = "ds-cfg-backend-subtree-delete-size-limit";
    public static final String ATTR_IMPORT_BUFFER_SIZE = "ds-cfg-backend-import-buffer-size";
    public static final String ATTR_IMPORT_TEMP_DIRECTORY = "ds-cfg-backend-import-temp-directory";
    public static final String ATTR_IMPORT_QUEUE_SIZE = "ds-cfg-backend-import-queue-size";
    public static final String ATTR_IMPORT_PASS_SIZE = "ds-cfg-backend-import-pass-size";
    public static final String ATTR_IMPORT_THREAD_COUNT = "ds-cfg-backend-import-thread-count";
    public static final String ATTR_PRELOAD_TIME_LIMIT = "ds-cfg-backend-preload-time-limit";
    public static final String ATTR_ENTRIES_COMPRESSED = "ds-cfg-backend-entries-compressed";
    public static final String ATTR_DEADLOCK_RETRY_LIMIT = "ds-cfg-backend-deadlock-retry-limit";
    private static HashMap<String, Double> memoryUnits = new HashMap();
    private static HashMap<String, Double> timeUnits;
    private DN[] baseDNs = null;
    private File backendDirectory = null;
    private FilePermission backendPermission = new FilePermission(448);
    private int deadlockRetryLimit = 0;
    private int backendIndexEntryLimit = 0;
    private int importPassSize = Integer.MAX_VALUE;
    private int subtreeDeleteSizeLimit = 0;
    private long importBufferSize = 0x6400000L;
    private String importTempDirectory = "importTmp";
    private Map<AttributeType, IndexConfig> indexConfigMap = null;
    private DN envConfigDN = null;
    private EnvironmentConfig envConfig = null;
    private int importQueueSize = 100;
    private int importThreadCount = 8;
    private long preloadTimeLimit = 0L;
    private boolean entriesCompressed = false;

    public void initializeConfig(ConfigEntry configEntry, DN[] dNArray) throws ConfigException {
        RDN rDN;
        block23: {
            BooleanConfigAttribute booleanConfigAttribute;
            BooleanConfigAttribute booleanConfigAttribute2;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute;
            IntegerConfigAttribute integerConfigAttribute;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute2;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute3;
            StringConfigAttribute stringConfigAttribute;
            IntegerConfigAttribute integerConfigAttribute2;
            IntegerConfigAttribute integerConfigAttribute3;
            Object object;
            this.baseDNs = dNArray;
            String string = MessageHandler.getMessage(0x300060);
            StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-backend-directory", string, true, false, true);
            StringConfigAttribute stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (stringConfigAttribute3 == null) {
                int n = 3407969;
                String string2 = MessageHandler.getMessage(n, configEntry.getDN().toString());
                throw new ConfigException(n, string2);
            }
            this.backendDirectory = StaticUtils.getFileForPath(stringConfigAttribute3.activeValue());
            if (!this.backendDirectory.isDirectory()) {
                int n = 8650761;
                String string3 = MessageHandler.getMessage(n, this.backendDirectory.getPath());
                throw new ConfigException(8650761, string3);
            }
            string = MessageHandler.getMessage(3146294);
            stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-backend-mode", string, false, false, true);
            StringConfigAttribute stringConfigAttribute4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (stringConfigAttribute4 != null) {
                try {
                    object = FilePermission.decodeUNIXMode(stringConfigAttribute4.activeValue());
                }
                catch (Exception exception) {
                    int n = 3408439;
                    String string4 = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, string4);
                }
                if (!(((FilePermission)object).isOwnerWritable() && ((FilePermission)object).isOwnerReadable() && ((FilePermission)object).isOwnerExecutable())) {
                    int n = 8520248;
                    String string5 = MessageHandler.getMessage(n);
                    throw new ConfigException(n, string5);
                }
                this.backendPermission = object;
            }
            if ((object = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3 = new IntegerConfigAttribute(ATTR_BACKEND_INDEX_ENTRY_LIMIT, string = MessageHandler.getMessage(0x800018), false, false, true, true, 0L, false, 0L))) != null) {
                this.backendIndexEntryLimit = ((IntegerConfigAttribute)object).activeIntValue();
            }
            if ((integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3 = new IntegerConfigAttribute(ATTR_SUBTREE_DELETE_SIZE_LIMIT, string = MessageHandler.getMessage(8388643), false, false, false, true, 0L, false, 0L))) != null) {
                this.subtreeDeleteSizeLimit = integerConfigAttribute2.activeIntValue();
            }
            if ((stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2 = new StringConfigAttribute(ATTR_IMPORT_TEMP_DIRECTORY, string = MessageHandler.getMessage(8388663), false, false, false))) != null) {
                this.importTempDirectory = stringConfigAttribute.activeValue();
            }
            if ((integerWithUnitConfigAttribute3 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute2 = new IntegerWithUnitConfigAttribute(ATTR_IMPORT_BUFFER_SIZE, string = MessageHandler.getMessage(0x800038), false, memoryUnits, true, 0xA00000L, false, 0L))) != null) {
                this.importBufferSize = integerWithUnitConfigAttribute3.activeCalculatedValue();
            }
            if ((integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3 = new IntegerConfigAttribute(ATTR_IMPORT_QUEUE_SIZE, string = MessageHandler.getMessage(8388665), false, false, false, true, 1L, false, 0L))) != null) {
                this.importQueueSize = integerConfigAttribute.activeIntValue();
            }
            if ((integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3 = new IntegerConfigAttribute(ATTR_IMPORT_THREAD_COUNT, string = MessageHandler.getMessage(8388666), false, false, false, true, 1L, false, 0L))) != null) {
                this.importThreadCount = integerConfigAttribute.activeIntValue();
            }
            if ((integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3 = new IntegerConfigAttribute(ATTR_IMPORT_PASS_SIZE, string = MessageHandler.getMessage(0x800078), true, false, false, true, 0L, true, Integer.MAX_VALUE))) != null) {
                this.importPassSize = integerConfigAttribute.activeIntValue();
            }
            if ((integerWithUnitConfigAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute2 = new IntegerWithUnitConfigAttribute(ATTR_PRELOAD_TIME_LIMIT, string = MessageHandler.getMessage(8388670), false, timeUnits, true, 0L, false, 0L))) != null) {
                this.preloadTimeLimit = integerWithUnitConfigAttribute.activeCalculatedValue();
            }
            if ((booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute = new BooleanConfigAttribute(ATTR_ENTRIES_COMPRESSED, string = MessageHandler.getMessage(0x800050), false))) != null) {
                this.entriesCompressed = booleanConfigAttribute2.activeValue();
            }
            if ((integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3 = new IntegerConfigAttribute(ATTR_DEADLOCK_RETRY_LIMIT, string = MessageHandler.getMessage(8388725), false, false, false, true, 0L, false, 0L))) != null) {
                this.deadlockRetryLimit = integerConfigAttribute.activeIntValue();
            }
            this.indexConfigMap = new HashMap<AttributeType, IndexConfig>();
            rDN = null;
            try {
                rDN = RDN.decode("cn=Index");
            }
            catch (DirectoryException directoryException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfig", directoryException)) break block23;
                throw new AssertionError();
            }
        }
        ConcurrentHashMap<DN, ConfigEntry> concurrentHashMap = configEntry.getChildren();
        for (ConfigEntry configEntry2 : concurrentHashMap.values()) {
            String string;
            int n;
            if (configEntry2.hasObjectClass(OBJECT_CLASS_CONFIG_DATABASE)) {
                if (this.envConfig != null) {
                    n = 8585252;
                    string = MessageHandler.getMessage(n, configEntry2.getDN().toString(), OBJECT_CLASS_CONFIG_DATABASE);
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string, n);
                    continue;
                }
                this.envConfig = ConfigurableEnvironment.parseConfigEntry(configEntry2);
                this.envConfigDN = configEntry2.getDN();
                continue;
            }
            if (configEntry2.getDN().getRDN().equals(rDN)) {
                this.configureIndexEntries(this.indexConfigMap, this.backendIndexEntryLimit, configEntry2.getChildren().values());
                continue;
            }
            n = 8585253;
            string = MessageHandler.getMessage(n, configEntry2.getDN().toString());
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string, n);
        }
        if (this.envConfig == null) {
            this.envConfig = ConfigurableEnvironment.defaultConfig();
        }
    }

    private void configureIndexEntries(Map<AttributeType, IndexConfig> map, int n, Collection<ConfigEntry> collection) throws ConfigException {
        String string = MessageHandler.getMessage(0x800010);
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute(ATTR_INDEX_ATTRIBUTE, string, true, false, true);
        string = MessageHandler.getMessage(0x800011);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("presence");
        hashSet.add("equality");
        hashSet.add("substring");
        hashSet.add("ordering");
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute(ATTR_INDEX_TYPE, string, false, true, true, hashSet);
        int n2 = n;
        string = MessageHandler.getMessage(8388626);
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute(ATTR_INDEX_ENTRY_LIMIT, string, false, false, true, true, 0L, false, 0L);
        int n3 = 6;
        string = MessageHandler.getMessage(8388633);
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute(ATTR_INDEX_SUBSTRING_LENGTH, string, false, false, true, true, 3L, false, 0L);
        for (ConfigEntry configEntry : collection) {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute2;
            IndexConfig indexConfig;
            Object object;
            Object object2;
            if (!configEntry.hasObjectClass(OBJECT_CLASS_CONFIG_ATTR_INDEX)) {
                int n4 = 8585253;
                object2 = MessageHandler.getMessage(n4, configEntry.getDN().toString());
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, (String)object2, n4);
                continue;
            }
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            object2 = DirectoryServer.getAttributeType(stringConfigAttribute2.activeValue().trim().toLowerCase());
            if (object2 == null) {
                int n5 = 8585254;
                object = MessageHandler.getMessage(n5, configEntry.getDN().toString(), stringConfigAttribute2.activeValue());
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, (String)object, n5);
                continue;
            }
            IntegerConfigAttribute integerConfigAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (integerConfigAttribute3 != null) {
                n2 = integerConfigAttribute3.activeIntValue();
            }
            if ((object = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2)) != null) {
                n3 = ((IntegerConfigAttribute)object).activeIntValue();
            }
            if ((indexConfig = map.get(object2)) == null) {
                indexConfig = new IndexConfig((AttributeType)object2);
                indexConfig.setPresenceEntryLimit(n2);
                indexConfig.setEqualityEntryLimit(n2);
                indexConfig.setSubstringEntryLimit(n2);
                indexConfig.setSubstringLength(n3);
                map.put((AttributeType)object2, indexConfig);
            } else {
                int n6 = 8585255;
                String string2 = MessageHandler.getMessage(n6, configEntry.getDN().toString(), ((CommonSchemaElements)object2).getNameOrOID());
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string2, n6);
            }
            if ((multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute)) == null) continue;
            for (String string3 : multiChoiceConfigAttribute2.activeValues()) {
                if (string3.equalsIgnoreCase("presence")) {
                    indexConfig.setPresenceIndex(true);
                    continue;
                }
                if (string3.equalsIgnoreCase("equality")) {
                    indexConfig.setEqualityIndex(true);
                    if (((AttributeType)object2).getEqualityMatchingRule() != null) continue;
                    int n7 = 8650778;
                    String string4 = MessageHandler.getMessage(n7, object2, string3);
                    throw new ConfigException(n7, string4);
                }
                if (string3.equalsIgnoreCase("substring")) {
                    indexConfig.setSubstringIndex(true);
                    if (((AttributeType)object2).getSubstringMatchingRule() != null) continue;
                    int n8 = 8650778;
                    String string5 = MessageHandler.getMessage(n8, object2, string3);
                    throw new ConfigException(n8, string5);
                }
                if (!string3.equalsIgnoreCase("ordering")) continue;
                indexConfig.setOrderingIndex(true);
                if (((AttributeType)object2).getOrderingMatchingRule() != null) continue;
                int n9 = 8650778;
                String string6 = MessageHandler.getMessage(n9, object2, string3);
                throw new ConfigException(n9, string6);
            }
        }
    }

    public File getBackendDirectory() {
        return this.backendDirectory;
    }

    public FilePermission getBackendPermission() {
        return this.backendPermission;
    }

    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    public EnvironmentConfig getEnvironmentConfig() {
        return this.envConfig;
    }

    public int getDeadlockRetryLimit() {
        return this.deadlockRetryLimit;
    }

    public int getBackendIndexEntryLimit() {
        return this.backendIndexEntryLimit;
    }

    public int getSubtreeDeleteSizeLimit() {
        return this.subtreeDeleteSizeLimit;
    }

    public Map<AttributeType, IndexConfig> getIndexConfigMap() {
        return this.indexConfigMap;
    }

    public String getImportTempDirectory() {
        return this.importTempDirectory;
    }

    public long getImportBufferSize() {
        return this.importBufferSize;
    }

    public int getImportQueueSize() {
        return this.importQueueSize;
    }

    public int getImportThreadCount() {
        return this.importThreadCount;
    }

    public int getImportPassSize() {
        return this.importPassSize;
    }

    public boolean isEntriesCompressed() {
        return this.entriesCompressed;
    }

    public long getPreloadTimeLimit() {
        return this.preloadTimeLimit;
    }

    public DN getEnvConfigDN() {
        return this.envConfigDN;
    }

    static {
        memoryUnits.put("b", 1.0);
        memoryUnits.put("bytes", 1.0);
        memoryUnits.put("kb", 1000.0);
        memoryUnits.put("kilobytes", 1000.0);
        memoryUnits.put("mb", 1000000.0);
        memoryUnits.put("megabytes", 1000000.0);
        memoryUnits.put("gb", 1.0E9);
        memoryUnits.put("gigabytes", 1.0E9);
        memoryUnits.put("kib", 1024.0);
        memoryUnits.put("kibibytes", 1024.0);
        memoryUnits.put("mib", 1048576.0);
        memoryUnits.put("mebibytes", 1048576.0);
        memoryUnits.put("gib", 1.073741824E9);
        memoryUnits.put("gibibytes", 1.073741824E9);
        timeUnits = new HashMap();
        timeUnits.put("ms", 1.0);
        timeUnits.put("milliseconds", 1.0);
        timeUnits.put("s", 1000.0);
        timeUnits.put("seconds", 1000.0);
        timeUnits.put("m", 60000.0);
        timeUnits.put("minutes", 60000.0);
    }
}

