/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.BackupManager;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ExportJob;
import org.opends.server.backends.jeb.ImportJob;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.backends.jeb.VerifyJob;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.monitors.DatabaseEnvironmentMonitor;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendImpl
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.BackendImpl";
    private DN configDN;
    private Config config;
    private RootContainer rootContainer;
    private ConfigurableEnvironment configurableEnv = null;
    private AtomicInteger threadTotalCount = new AtomicInteger(0);
    private AtomicInteger threadWriteCount = new AtomicInteger(0);
    private ArrayList<MonitorProvider> monitorProviders = new ArrayList();
    private static HashSet<String> supportedControls = new HashSet();
    private static ArrayList<ConfigAttribute> configAttrs;
    private static DNConfigAttribute baseDNStub;

    private void readerBegin() {
        assert (Debug.debugEnter(CLASS_NAME, "readerBegin", new String[0]));
        this.threadTotalCount.getAndIncrement();
    }

    private void readerEnd() {
        assert (Debug.debugEnter(CLASS_NAME, "readerEnd", new String[0]));
        this.threadTotalCount.getAndDecrement();
    }

    private void writerBegin() {
        assert (Debug.debugEnter(CLASS_NAME, "writerBegin", new String[0]));
        this.threadTotalCount.getAndIncrement();
        this.threadWriteCount.getAndIncrement();
    }

    private void writerEnd() {
        assert (Debug.debugEnter(CLASS_NAME, "writerEnd", new String[0]));
        this.threadWriteCount.getAndDecrement();
        this.threadTotalCount.getAndDecrement();
    }

    private void waitUntilQuiescent() {
        assert (Debug.debugEnter(CLASS_NAME, "waitUntilQuiescent", new String[0]));
        while (this.threadTotalCount.get() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                assert (Debug.debugException(CLASS_NAME, "waitUntilQuiescent", interruptedException));
            }
        }
    }

    public static String getContainerName(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getContainerName", new String[0]));
        String string = dN.toNormalizedString();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", new String[0]));
        this.configDN = configEntry.getDN();
        this.config = new Config();
        this.config.initializeConfig(configEntry, dNArray);
        for (DN dN : dNArray) {
            DirectoryServer.registerSuffix(dN, this);
        }
        try {
            this.rootContainer = new RootContainer(this.config, this);
            this.rootContainer.open();
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", databaseException));
            String databaseException2 = MessageHandler.getMessage(8650755, databaseException.getMessage());
            throw new InitializationException(8650755, databaseException2, databaseException);
        }
        DatabaseEnvironmentMonitor databaseEnvironmentMonitor = this.rootContainer.getMonitorProvider();
        this.monitorProviders.add(databaseEnvironmentMonitor);
        DirectoryServer.registerMonitorProvider(databaseEnvironmentMonitor);
        try {
            this.rootContainer.openEntryContainers(dNArray);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", databaseException));
            String string = MessageHandler.getMessage(8650754, databaseException.getMessage());
            throw new InitializationException(8650754, string, databaseException);
        }
        this.rootContainer.preload();
        try {
            int string = 8847402;
            String string2 = MessageHandler.getMessage(string, this.rootContainer.getEntryCount());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string2, string);
        }
        catch (DatabaseException configurableEnvironment) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", configurableEnvironment));
            String string = MessageHandler.getMessage(8519809, configurableEnvironment.getMessage());
            throw new InitializationException(8519809, string, configurableEnvironment);
        }
        DirectoryServer.registerConfigurableComponent(this);
        ConfigurableEnvironment configurableEnvironment = this.rootContainer.getConfigurableEnvironment();
        if (configurableEnvironment != null) {
            DirectoryServer.registerConfigurableComponent(configurableEnvironment);
        }
    }

    @Override
    public void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        if (this.configurableEnv != null) {
            DirectoryServer.deregisterConfigurableComponent(this.configurableEnv);
            this.configurableEnv = null;
        }
        DirectoryServer.deregisterConfigurableComponent(this);
        for (DN object : this.rootContainer.getBaseDNs()) {
            try {
                DirectoryServer.deregisterSuffix(object);
            }
            catch (ConfigException configException) {
                assert (Debug.debugException(CLASS_NAME, "finalizeBackend", configException));
            }
        }
        for (MonitorProvider monitorProvider : this.monitorProviders) {
            DirectoryServer.deregisterMonitorProvider(monitorProvider.getMonitorInstanceName().toLowerCase());
        }
        this.monitorProviders = new ArrayList();
        this.waitUntilQuiescent();
        try {
            this.rootContainer.close();
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "finalizeBackend", databaseException));
            int n = 8650766;
            String string = MessageHandler.getMessage(n, databaseException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        this.threadTotalCount.set(0);
        this.threadWriteCount.set(0);
        this.config = null;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return true;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return null;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", new String[0]));
        return false;
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", new String[0]));
        return supportedControls.contains(string);
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.config.getBaseDNs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", new String[0]));
        this.readerBegin();
        try {
            Entry entry;
            EntryContainer entryContainer = this.rootContainer.getEntryContainer(dN);
            try {
                entry = entryContainer.getEntry(dN);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "getEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "getEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
            Entry entry2 = entry;
            return entry2;
        }
        finally {
            this.readerEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", new String[0]));
        this.writerBegin();
        try {
            DN dN = entry.getDN();
            EntryContainer entryContainer = this.rootContainer.getEntryContainer(dN);
            try {
                entryContainer.addEntry(entry, addOperation);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "addEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "addEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
        }
        finally {
            this.writerEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", new String[0]));
        this.writerBegin();
        try {
            EntryContainer entryContainer = this.rootContainer.getEntryContainer(dN);
            try {
                entryContainer.deleteEntry(dN, deleteOperation);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "deleteEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "deleteEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
        }
        finally {
            this.writerEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", new String[0]));
        this.writerBegin();
        try {
            DN dN = entry.getDN();
            EntryContainer entryContainer = this.rootContainer.getEntryContainer(dN);
            try {
                entryContainer.replaceEntry(entry, modifyOperation);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "replaceEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "replaceEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
        }
        finally {
            this.writerEnd();
        }
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException, CancelledOperationException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", new String[0]));
        this.writerBegin();
        try {
            EntryContainer entryContainer = this.rootContainer.getEntryContainer(dN);
            EntryContainer entryContainer2 = this.rootContainer.getEntryContainer(entry.getDN());
            if (entryContainer != entryContainer2) {
                int n = 8519686;
                String string = MessageHandler.getMessage(8519686);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
            entryContainer.renameEntry(dN, entry, modifyDNOperation);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "renameEntry", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "renameEntry", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        finally {
            this.writerEnd();
        }
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "search", new String[0]));
        this.readerBegin();
        try {
            EntryContainer entryContainer = this.rootContainer.getEntryContainer(searchOperation.getBaseDN());
            entryContainer.search(searchOperation);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "search", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        finally {
            this.readerEnd();
        }
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", new String[0]));
        this.config = new Config();
        try {
            this.config.initializeConfig(configEntry, dNArray);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        boolean bl = this.rootContainer == null;
        try {
            if (bl) {
                this.rootContainer = new RootContainer(this.config, this);
                this.rootContainer.open(this.config.getBackendDirectory(), this.config.getBackendPermission(), true, false, false, false, true, true);
                this.rootContainer.openEntryContainers(dNArray);
            }
            ExportJob exportJob = new ExportJob(lDIFExportConfig);
            exportJob.exportLDIF(this.rootContainer);
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", iOException));
            int n = 8650792;
            String string = MessageHandler.getMessage(n, iOException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        catch (LDIFException lDIFException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", lDIFException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), lDIFException.getMessage(), lDIFException.getMessageID());
        }
        finally {
            block23: {
                if (bl && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException databaseException) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", databaseException)) break block23;
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", new String[0]));
        this.config = new Config();
        try {
            this.config.initializeConfig(configEntry, dNArray);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        try {
            ImportJob importJob = new ImportJob(this, this.config, lDIFImportConfig);
            importJob.importLDIF();
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", iOException));
            int n = 8650792;
            String string = MessageHandler.getMessage(n, iOException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
    }

    public void verifyBackend(VerifyConfig verifyConfig, ConfigEntry configEntry, DN[] dNArray, Entry entry) throws InitializationException, ConfigException, DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "verifyBackend", new String[0]));
        this.config = new Config();
        this.config.initializeConfig(configEntry, dNArray);
        boolean bl = this.rootContainer == null;
        try {
            if (bl) {
                this.rootContainer = new RootContainer(this.config, this);
                this.rootContainer.open(this.config.getBackendDirectory(), this.config.getBackendPermission(), true, false, false, false, true, true);
                this.rootContainer.openEntryContainers(dNArray);
            }
            VerifyJob verifyJob = new VerifyJob(this.config, verifyConfig);
            verifyJob.verifyBackend(this.rootContainer, entry);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "verifyBackend", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "verifyBackend", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        finally {
            block16: {
                if (bl && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException databaseException) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "verifyBackend", databaseException)) break block16;
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", new String[0]));
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.createBackup(configEntry, backupConfig);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", new String[0]));
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.removeBackup(backupDirectory, string);
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", new String[0]));
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.restoreBackup(configEntry, restoreConfig);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        return configAttrs;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", new String[0]));
        DN[] dNArray = null;
        boolean bl = true;
        try {
            object = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
            if (object == null) {
                int n = 3408178;
                String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
                list.add(string);
            } else {
                dNArray = ((DNConfigAttribute)object).activeValues().toArray(new DN[0]);
            }
        }
        catch (ConfigException configException) {
            list.add(configException.getMessage());
            bl = false;
        }
        object = new Config();
        try {
            ((Config)object).initializeConfig(configEntry, dNArray);
        }
        catch (ConfigException configException) {
            list.add(configException.getMessage());
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", new String[0]));
        try {
            DN[] dNArray = null;
            DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
            dNArray = dNConfigAttribute.activeValues().toArray(new DN[0]);
            Config config = new Config();
            config.initializeConfig(configEntry, dNArray);
            for (DN dN : this.config.getBaseDNs()) {
                boolean bl2 = false;
                for (DN dN2 : config.getBaseDNs()) {
                    if (!dN2.equals(dN)) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                DirectoryServer.deregisterSuffix(dN);
                this.rootContainer.removeEntryContainer(dN);
            }
            for (DN dN : config.getBaseDNs()) {
                if (this.rootContainer.getBaseDNs().contains(dN)) continue;
                this.rootContainer.openEntryContainer(dN);
                DirectoryServer.registerSuffix(dN, this);
            }
            this.rootContainer.applyNewConfig(this.config);
            this.config = config;
        }
        catch (Exception exception) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(exception.getMessage());
            ConfigChangeResult configChangeResult = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, arrayList);
            return configChangeResult;
        }
        ConfigChangeResult configChangeResult = new ConfigChangeResult(ResultCode.SUCCESS, false);
        return configChangeResult;
    }

    public RootContainer getRootContainer() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootContainer", new String[0]));
        return this.rootContainer;
    }

    public void clearBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, JebException {
        Config config = new Config();
        config.initializeConfig(configEntry, dNArray);
        EnvManager.removeFiles(config.getBackendDirectory().getPath());
    }

    static {
        supportedControls.add("1.2.840.113556.1.4.805");
        supportedControls.add("1.2.840.113556.1.4.319");
        supportedControls.add("2.16.840.1.113730.3.4.2");
        configAttrs = new ArrayList();
        int n = 0x300131;
        baseDNStub = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
        configAttrs.add(baseDNStub);
    }
}

