/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorBackend
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.MonitorBackend";
    private ArrayList<Attribute> userDefinedAttributes;
    private HashMap<ObjectClass, String> monitorObjectClasses;
    private DN configEntryDN;
    private DN baseMonitorDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;

    public MonitorBackend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        void var4_13;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry)));
        if (configEntry == null) {
            int n = 9699349;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.configEntryDN = configEntry.getDN();
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> object22 : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute attribute : object22) {
                if (this.isMonitorConfigAttribute(attribute)) continue;
                this.userDefinedAttributes.add(attribute);
            }
        }
        for (List<Attribute> list : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute attribute : list) {
                if (this.isMonitorConfigAttribute(attribute)) continue;
                this.userDefinedAttributes.add(attribute);
            }
        }
        try {
            this.baseMonitorDN = DN.decode("cn=monitor");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            int n = 9699350;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.baseDNs = new DN[]{this.baseMonitorDN};
        this.monitorObjectClasses = new HashMap(2);
        Object object3 = DirectoryServer.getObjectClass("top");
        if (object3 == null) {
            object3 = DirectoryServer.getDefaultObjectClass("top");
        }
        this.monitorObjectClasses.put((ObjectClass)object3, "top");
        ObjectClass objectClass = DirectoryServer.getObjectClass("extensibleObject");
        if (objectClass == null) {
            ObjectClass objectClass2 = DirectoryServer.getDefaultObjectClass("extensibleObject");
        }
        this.monitorObjectClasses.put((ObjectClass)var4_13, "extensibleObject");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        DirectoryServer.registerConfigurableComponent(this);
        DirectoryServer.registerPrivateSuffix(this.baseMonitorDN, this);
    }

    @Override
    public void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    private boolean isMonitorConfigAttribute(Attribute attribute) {
        assert (Debug.debugEnter(CLASS_NAME, "isMonitorConfigAttribute", String.valueOf(attribute)));
        AttributeType attributeType = attribute.getAttributeType();
        return attributeType.hasName("cn") || attributeType.hasName("ds-cfg-backend-enabled".toLowerCase()) || attributeType.hasName("ds-cfg-backend-class".toLowerCase());
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        if (dN == null) {
            int n = 9633824;
            String string = MessageHandler.getMessage(n);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        if (dN.equals(this.baseMonitorDN)) {
            return this.getBaseMonitorEntry();
        }
        DN dN2 = dN.getParentDNInSuffix();
        if (dN2 == null || !dN2.equals(this.baseMonitorDN)) {
            if (this.baseMonitorDN.isAncestorOf(dN)) {
                int n = 9633825;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.baseMonitorDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, this.baseMonitorDN, null);
            }
            int n = 9633826;
            String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.baseMonitorDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        RDN rDN = dN.getRDN();
        if (rDN.isMultiValued()) {
            int n = 9633827;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, this.baseMonitorDN, null);
        }
        String string = rDN.getAttributeValue(0).getStringValue();
        MonitorProvider monitorProvider = DirectoryServer.getMonitorProvider(string.toLowerCase());
        if (monitorProvider == null) {
            int n = 9633828;
            String string2 = MessageHandler.getMessage(n, String.valueOf(string));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string2, n, this.baseMonitorDN, null);
        }
        return this.getMonitorEntry(dN, monitorProvider);
    }

    @Override
    public boolean entryExists(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        if (dN.equals(this.baseMonitorDN)) {
            return true;
        }
        DN dN2 = dN.getParentDNInSuffix();
        if (dN2 == null || !dN2.equals(this.baseMonitorDN)) {
            return false;
        }
        RDN rDN = dN.getRDN();
        if (rDN.isMultiValued()) {
            return false;
        }
        String string = rDN.getAttributeValue(0).getStringValue();
        MonitorProvider monitorProvider = DirectoryServer.getMonitorProvider(StaticUtils.toLowerCase(string));
        return monitorProvider != null;
    }

    public Entry getBaseMonitorEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseMonitorEntry", new String[0]));
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap2 = new LinkedHashMap<AttributeType, List<Attribute>>();
        Attribute attribute = this.createAttribute("cn", "cn", "monitor");
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        linkedHashMap.put(attribute.getAttributeType(), arrayList);
        Attribute attribute2 = this.createAttribute("productName", "productname", "OpenDS Directory Server");
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
        arrayList2.add(attribute2);
        linkedHashMap.put(attribute2.getAttributeType(), arrayList2);
        Attribute attribute3 = this.createAttribute("vendorName", "vendorname", "Sun Microsystems, Inc.");
        ArrayList<Attribute> arrayList3 = new ArrayList<Attribute>(1);
        arrayList3.add(attribute3);
        linkedHashMap.put(attribute3.getAttributeType(), arrayList3);
        Attribute attribute4 = this.createAttribute("vendorVersion", "vendorversion", DirectoryServer.getVersionString());
        ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>(1);
        arrayList4.add(attribute4);
        linkedHashMap.put(attribute4.getAttributeType(), arrayList4);
        Attribute attribute5 = this.createAttribute("startTime", "starttime", DirectoryServer.getStartTimeUTC());
        ArrayList<Attribute> arrayList5 = new ArrayList<Attribute>(1);
        arrayList5.add(attribute5);
        linkedHashMap.put(attribute5.getAttributeType(), arrayList5);
        Attribute attribute6 = this.createAttribute("currentTime", "currenttime", TimeThread.getUTCTime());
        ArrayList<Attribute> arrayList6 = new ArrayList<Attribute>(1);
        arrayList6.add(attribute6);
        linkedHashMap.put(attribute6.getAttributeType(), arrayList6);
        long l = (System.currentTimeMillis() - DirectoryServer.getStartTime()) / 1000L;
        long l2 = l / 86400L;
        long l3 = (l %= 86400L) / 3600L;
        long l4 = (l %= 3600L) / 60L;
        String string = MessageHandler.getMessage(9437221, l2, l3, l4, l %= 60L);
        Attribute attribute7 = this.createAttribute("upTime", "uptime", string);
        ArrayList<Attribute> arrayList7 = new ArrayList<Attribute>(1);
        arrayList7.add(attribute7);
        linkedHashMap.put(attribute7.getAttributeType(), arrayList7);
        long l5 = DirectoryServer.getCurrentConnections();
        Attribute attribute8 = this.createAttribute("currentConnections", "currentconnections", String.valueOf(l5));
        ArrayList<Attribute> arrayList8 = new ArrayList<Attribute>(1);
        arrayList8.add(attribute8);
        linkedHashMap.put(attribute8.getAttributeType(), arrayList8);
        long l6 = DirectoryServer.getMaxConnections();
        Attribute attribute9 = this.createAttribute("maxConnections", "maxconnections", String.valueOf(l6));
        ArrayList<Attribute> arrayList9 = new ArrayList<Attribute>(1);
        arrayList9.add(attribute9);
        linkedHashMap.put(attribute9.getAttributeType(), arrayList9);
        long l7 = DirectoryServer.getTotalConnections();
        Attribute attribute10 = this.createAttribute("totalConnections", "totalconnections", String.valueOf(l7));
        ArrayList<Attribute> arrayList10 = new ArrayList<Attribute>(1);
        arrayList10.add(attribute10);
        linkedHashMap.put(attribute10.getAttributeType(), arrayList10);
        for (Attribute attribute11 : this.userDefinedAttributes) {
            List<Attribute> list;
            AttributeType attributeType = attribute11.getAttributeType();
            if (attributeType.isOperational()) {
                list = (ArrayList<Attribute>)((HashMap)linkedHashMap2).get(attributeType);
                if (list == null) {
                    list = new ArrayList<Attribute>();
                    list.add(attribute11);
                    linkedHashMap2.put(attributeType, list);
                    continue;
                }
                list.add(attribute11);
                continue;
            }
            list = (List)((HashMap)linkedHashMap).get(attributeType);
            if (list == null) {
                list = new ArrayList();
                list.add(attribute11);
                linkedHashMap.put(attributeType, list);
                continue;
            }
            list.add(attribute11);
        }
        return new Entry(this.baseMonitorDN, this.monitorObjectClasses, linkedHashMap, linkedHashMap2);
    }

    private Entry getMonitorEntry(DN dN, MonitorProvider monitorProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorEntry", String.valueOf(monitorProvider)));
        List<Attribute> list = monitorProvider.getMonitorData();
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap = new LinkedHashMap<AttributeType, List<Attribute>>(list.size() + 1);
        RDN rDN = dN.getRDN();
        AttributeType attributeType = rDN.getAttributeType(0);
        AttributeValue attributeValue = rDN.getAttributeValue(0);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(attributeValue);
        Attribute attribute = new Attribute(attributeType, rDN.getAttributeName(0), linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        linkedHashMap.put(attributeType, arrayList);
        for (Attribute attribute2 : list) {
            AttributeType attributeType2 = attribute2.getAttributeType();
            ArrayList<Attribute> arrayList2 = (ArrayList<Attribute>)((HashMap)linkedHashMap).get(attributeType2);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Attribute>();
                arrayList2.add(attribute2);
                linkedHashMap.put(attributeType2, arrayList2);
                continue;
            }
            arrayList2.add(attribute2);
        }
        return new Entry(dN, this.monitorObjectClasses, linkedHashMap, new HashMap<AttributeType, List<Attribute>>(0));
    }

    private Attribute createAttribute(String string, String string2, String string3) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2), String.valueOf(string3)));
        AttributeType attributeType = DirectoryServer.getAttributeType(string2);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string3)));
        return new Attribute(attributeType, string, linkedHashSet);
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        int n = 9633815;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        int n = 9633816;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        int n = 9633817;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(this.configEntryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        int n = 9633818;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        DN dN = searchOperation.getBaseDN();
        Entry entry = this.getEntry(dN);
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (this.baseMonitorDN.equals(dN)) {
            if (searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) {
                if (searchFilter.matchesEntry(entry)) {
                    searchOperation.returnEntry(entry, null);
                }
                if (searchScope == SearchScope.BASE_OBJECT) {
                    return;
                }
            }
            for (MonitorProvider monitorProvider : DirectoryServer.getMonitorProviders().values()) {
                DN dN2 = DirectoryServer.getMonitorProviderDN(monitorProvider);
                Entry entry2 = this.getMonitorEntry(dN2, monitorProvider);
                if (!searchFilter.matchesEntry(entry2)) continue;
                searchOperation.returnEntry(entry2, null);
            }
        } else if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(entry)) {
            searchOperation.returnEntry(entry, null);
        }
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return this.supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", String.valueOf(string)));
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        block13: {
            LDIFWriter lDIFWriter;
            assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
            try {
                lDIFWriter = new LDIFWriter(lDIFExportConfig);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
                int n = 9699342;
                String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
            }
            try {
                lDIFWriter.writeEntry(this.getBaseMonitorEntry());
            }
            catch (Exception exception) {
                block12: {
                    assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
                    try {
                        lDIFWriter.close();
                    }
                    catch (Exception exception2) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", exception2)) break block12;
                        throw new AssertionError();
                    }
                }
                int n = 9699355;
                String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
            }
            for (MonitorProvider monitorProvider : DirectoryServer.getMonitorProviders().values()) {
            }
            try {
                lDIFWriter.close();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", exception)) break block13;
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return false;
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
        int n = 9699357;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(backupConfig)));
        int n = 9699358;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
        int n = 9699358;
        String string2 = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return false;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(restoreConfig)));
        int n = 9699358;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        return new LinkedList<ConfigAttribute>();
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        for (List<Attribute> object : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute attribute : object) {
                if (this.isMonitorConfigAttribute(attribute)) continue;
                arrayList2.add(attribute);
            }
        }
        for (List<Attribute> list : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute attribute : list) {
                if (this.isMonitorConfigAttribute(attribute)) continue;
                arrayList2.add(attribute);
            }
        }
        this.userDefinedAttributes = arrayList2;
        if (bl) {
            int n = 9437215;
            String string = MessageHandler.getMessage(n);
            arrayList.add(string);
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

