/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SynchronizationProviderResult;

public abstract class SynchronizationProvider {
    private static final String CLASS_NAME = "org.opends.server.api.SynchronizationProvider";

    public abstract void initializeSynchronizationProvider(ConfigEntry var1) throws ConfigException, InitializationException;

    public void finalizeSynchronizationProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSynchronizationProvider", new String[0]));
    }

    public SynchronizationProviderResult handleConflictResolution(AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "handleConflictResolution", String.valueOf(addOperation)));
        return new SynchronizationProviderResult(true);
    }

    public abstract SynchronizationProviderResult doPreOperation(AddOperation var1) throws DirectoryException;

    public abstract void doPostOperation(AddOperation var1) throws DirectoryException;

    public SynchronizationProviderResult handleConflictResolution(DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "handleConflictResolution", String.valueOf(deleteOperation)));
        return new SynchronizationProviderResult(true);
    }

    public abstract SynchronizationProviderResult doPreOperation(DeleteOperation var1) throws DirectoryException;

    public abstract void doPostOperation(DeleteOperation var1) throws DirectoryException;

    public SynchronizationProviderResult handleConflictResolution(ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "handleConflictResolution", String.valueOf(modifyOperation)));
        return new SynchronizationProviderResult(true);
    }

    public abstract SynchronizationProviderResult doPreOperation(ModifyOperation var1) throws DirectoryException;

    public abstract void doPostOperation(ModifyOperation var1) throws DirectoryException;

    public SynchronizationProviderResult handleConflictResolution(ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "handleConflictResolution", String.valueOf(modifyDNOperation)));
        return new SynchronizationProviderResult(true);
    }

    public abstract SynchronizationProviderResult doPreOperation(ModifyDNOperation var1) throws DirectoryException;

    public abstract void doPostOperation(ModifyDNOperation var1) throws DirectoryException;
}

