/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public abstract class PasswordStorageScheme {
    private static final String CLASS_NAME = "org.opends.server.api.PasswordStorageScheme";

    public abstract void initializePasswordStorageScheme(ConfigEntry var1) throws ConfigException, InitializationException;

    public void finalizePasswordStorageScheme() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizePasswordStorageScheme", new String[0]));
    }

    public abstract String getStorageSchemeName();

    public abstract ByteString encodePassword(ByteString var1) throws DirectoryException;

    public abstract ByteString encodePasswordWithScheme(ByteString var1) throws DirectoryException;

    public abstract boolean passwordMatches(ByteString var1, ByteString var2);

    public abstract boolean supportsAuthPasswordSyntax();

    public String getAuthPasswordSchemeName() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordSchemeName", new String[0]));
        return this.getStorageSchemeName();
    }

    public abstract ByteString encodeAuthPassword(ByteString var1) throws DirectoryException;

    public abstract boolean authPasswordMatches(ByteString var1, String var2, String var3);

    public abstract boolean isReversible();

    public abstract ByteString getPlaintextValue(ByteString var1) throws DirectoryException;

    public abstract ByteString getAuthPasswordPlaintextValue(String var1, String var2) throws DirectoryException;

    public abstract boolean isStorageSchemeSecure();
}

