/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.Attribute;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitorProvider
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.api.MonitorProvider";
    private boolean stopRequested;
    private Thread monitorThread;

    protected MonitorProvider(String string) {
        super(string);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.stopRequested = false;
        this.monitorThread = null;
    }

    public abstract void initializeMonitorProvider(ConfigEntry var1) throws ConfigException, InitializationException;

    public void finalizeMonitorProvider() {
        block4: {
            assert (Debug.debugEnter(CLASS_NAME, "finalizeMonitorProvider", new String[0]));
            this.stopRequested = true;
            try {
                if (this.monitorThread != null) {
                    this.monitorThread.interrupt();
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeMonitorProvider", exception)) break block4;
                throw new AssertionError();
            }
        }
    }

    public abstract String getMonitorInstanceName();

    public abstract long getUpdateInterval();

    public abstract void updateMonitorData();

    public abstract List<Attribute> getMonitorData();

    @Override
    public final void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.monitorThread = Thread.currentThread();
        if (this.getUpdateInterval() <= 0L) {
            return;
        }
        this.setName(this.getMonitorInstanceName() + " Monitor Provider");
        while (!this.stopRequested) {
            long l = System.currentTimeMillis() + this.getUpdateInterval();
            this.updateMonitorData();
            long l2 = l - System.currentTimeMillis();
            while (!this.stopRequested && l2 > 0L) {
                if (l2 > 1000L) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                l2 = l - System.currentTimeMillis();
            }
        }
    }
}

