/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Bitmap;
import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.ImageSource;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import com.sun.media.content.application.x_shockwave_flash.SCharacter;
import com.sun.media.content.application.x_shockwave_flash.SObject;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.Semaphore;
import com.sun.media.content.application.x_shockwave_flash.Sound;
import com.sun.media.content.application.x_shockwave_flash.SoundMixer;
import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.PullSourceStream;

final class ScriptPlayer
extends SParser
implements Runnable {
    static final int noErr = 0;
    static final int badHeaderErr = -1;
    static final int noMemErr = -2;
    static final int noScriptErr = -3;
    static final int playOK = 0;
    static final int playNeedData = 1;
    static final int playAtEnd = 2;
    static final int stagEnd = 0;
    static final int stagShowFrame = 1;
    static final int stagDefineShape = 2;
    static final int stagFreeCharacter = 3;
    static final int stagPlaceObject = 4;
    static final int stagRemoveObject = 5;
    static final int stagDefineBits = 6;
    static final int stagDefineButton = 7;
    static final int stagJPEGTables = 8;
    static final int stagSetBackgroundColor = 9;
    static final int stagDefineFont = 10;
    static final int stagDefineText = 11;
    static final int stagDoAction = 12;
    static final int stagDefineFontInfo = 13;
    static final int stagDefineSound = 14;
    static final int stagStartSound = 15;
    static final int stagStopSound = 16;
    static final int stagDefineButtonSound = 17;
    static final int stagSoundStreamHead = 18;
    static final int stagSoundStreamBlock = 19;
    static final int stagDefineBitsLossless = 20;
    static final int stagDefineBitsJPEG2 = 21;
    static final int stagDefineShape2 = 22;
    static final int stagDefineButtonCxform = 23;
    static final int stagProtect = 24;
    static final int stagPathsArePostScript = 25;
    static final int sactionHasLength = 128;
    static final int sactionNone = 0;
    static final int sactionGotoFrame = 129;
    static final int sactionGetURL = 131;
    static final int sactionNextFrame = 4;
    static final int sactionPrevFrame = 5;
    static final int sactionPlay = 6;
    static final int sactionStop = 7;
    static final int sactionToggleQuality = 8;
    static final int sactionStopSounds = 9;
    static final int sactionWaitForFrame = 138;
    static final int soundHasInPoint = 1;
    static final int soundHasOutPoint = 2;
    static final int soundHasLoops = 4;
    static final int soundHasEnvelope = 8;
    static final int syncNoMultiple = 1;
    static final int syncStop = 2;
    int nextPos;
    int startPos;
    int scriptErr;
    int len;
    int scriptLen;
    Rect frame;
    int frameRate;
    int frameDelay;
    int numFrames;
    int version;
    int headerLen;
    byte[] headerBuf = new byte[8];
    boolean gotHeader;
    boolean atEnd;
    int curFrame;
    Semaphore gotData = new Semaphore(false);
    DisplayList display;
    private Flash flash;
    static final int maxActions = 16;
    public int[] actionList = new int[16];
    public int nActions;
    static final int charIndexSize = 64;
    static final int charIndexMask = 63;
    SCharacter[] charIndex = new SCharacter[64];
    Sound streamSound = new Sound(0, 0, null, 0);
    int mixFormat;
    boolean mute;
    static final int START_MARKER = 216;
    static final int END_MARKER = 217;
    static final int TAG_MARKER = 255;
    private int jpegTablePos;
    private int jpegTableLen;
    private static int imageClassToUse;
    private static final int IMAGE_NOT_INITIALIZED = 0;
    private static final int IMAGE_TOOLKIT = 1;
    private static final int IMAGE_SUN = 2;
    private static final int IMAGE_NONE = 3;
    private int numFramesComplete;
    private int numFramesCompletePos;
    private InputStream scriptStream = null;
    private boolean scriptComplete;

    ScriptPlayer() {
        this.frame = new Rect(0, 0, 600, 600);
        this.ClearScript();
    }

    ScriptPlayer(Flash flash, DisplayList display) {
        this();
        this.flash = flash;
        this.display = display;
    }

    public final boolean ScriptComplete() {
        return this.script != null && this.len >= this.scriptLen;
    }

    public final boolean GotHeader() {
        return this.gotHeader;
    }

    public final int GetFrame() {
        return this.curFrame;
    }

    public final boolean AtEnd() {
        return this.atEnd;
    }

    void PlayButtonSound(SObject btn, int state) {
        int oldState = btn.buttonState;
        if (oldState == state || state != 1 && oldState > state) {
            return;
        }
        if (btn.character.soundPos > 0) {
            int tag;
            SParser parser = new SParser();
            parser.Attach(this.script, btn.character.soundPos);
            int i2 = 1;
            while (i2 < state) {
                tag = parser.GetWord();
                if (tag > 0) {
                    parser.GetSoundInfo(null, null, true);
                }
                i2 <<= 1;
            }
            tag = parser.GetWord();
            if (tag > 0) {
                SCharacter ch = this.FindCharacter(tag);
                if (ch == null || ch.type != 5) {
                    return;
                }
                int[] loops = new int[1];
                int[] syncSound = new int[1];
                Sound sound = (Sound)ch.object;
                parser.GetSoundInfo(loops, syncSound, false);
                if (sound.ConvertToMulaw(loops[0])) {
                    if ((syncSound[0] & 2) != 0) {
                        sound.stop();
                    } else if ((syncSound[0] & 1) != 0 && !this.mute) {
                        sound.playNoMultiple(loops[0]);
                    } else if (!this.mute) {
                        sound.playMultiple(loops[0]);
                    }
                }
            }
        }
    }

    void SoundStreamHead() {
        this.mixFormat = this.GetByte();
        this.streamSound.SetFormat(this.GetByte());
        this.streamSound.SetSamples(this.GetWord());
    }

    void SoundStreamBlock() {
    }

    void StopAllSounds() {
        Sound sound = this.streamSound;
        while (sound != null) {
            sound.stop();
            sound = sound.next;
        }
        SoundMixer.StopAllStreams();
    }

    void StartSound() {
        int tag = this.GetWord();
        SCharacter ch = this.FindCharacter(tag);
        if (ch == null || ch.type != 5) {
            return;
        }
        int[] loops = new int[1];
        int[] syncSound = new int[1];
        Sound sound = (Sound)ch.object;
        this.GetSoundInfo(loops, syncSound, false);
        if (sound.ConvertToMulaw(loops[0])) {
            if ((syncSound[0] & 2) != 0) {
                sound.stop();
            } else if ((syncSound[0] & 1) != 0 && !this.mute) {
                sound.playNoMultiple(loops[0]);
            } else if (!this.mute) {
                sound.playMultiple(loops[0]);
            }
        }
    }

    public void FreeAll() {
        if (this.display != null) {
            this.display.FreeAll();
        }
        this.pos = this.startPos;
        this.curFrame = -1;
        this.atEnd = false;
    }

    public void ClearScript() {
        this.FreeAll();
        this.gotHeader = false;
        this.curFrame = -1;
        this.atEnd = false;
        this.headerLen = 0;
        this.len = 0;
        this.scriptLen = -1;
        this.pos = 0;
        this.script = null;
        this.scriptErr = 0;
        this.nActions = 0;
    }

    public SCharacter FindCharacter(int tag) {
        SCharacter ch = this.charIndex[tag & 0x3F];
        while (ch != null && ch.tag != tag) {
            ch = ch.next;
        }
        return ch;
    }

    private SCharacter CreateCharacter(int tag) {
        SCharacter ch = new SCharacter();
        if (ch != null) {
            ch.next = this.charIndex[tag & 0x3F];
            this.charIndex[tag & 0x3F] = ch;
            ch.player = this;
            ch.tag = tag;
        }
        return ch;
    }

    private void FreeCharacter(int tag) {
        Object prev = null;
        SCharacter ch = this.charIndex[tag & 0x3F];
    }

    private void DefineShape() {
        int tag = this.GetWord();
        if (this.FindCharacter(tag) != null) {
            return;
        }
        SCharacter ch = this.CreateCharacter(tag);
        ch.type = 0;
        ch.bounds = this.GetRect();
        ch.dataPos = this.pos;
    }

    private void PlaceObject() {
        int tag = this.GetWord();
        int depth = this.GetWord();
        SCharacter ch = this.FindCharacter(tag);
        Matrix mat = this.GetMatrix();
        if (this.pos < this.end) {
            ColorTransform cx = new ColorTransform();
            this.GetColorTransform(cx);
            this.display.PlaceObject(ch, tag << 16 | depth, mat, cx);
        } else {
            this.display.PlaceObject(ch, tag << 16 | depth, mat, null);
        }
    }

    private void RemoveObject() {
        int tag = this.GetWord();
        int depth = this.GetWord();
        this.display.RemoveObject(tag << 16 | depth);
    }

    private void DefineButton() {
        int tag = this.GetWord();
        if (this.FindCharacter(tag) != null) {
            return;
        }
        SCharacter ch = this.CreateCharacter(tag);
        ch.type = 2;
        ch.dataPos = this.pos;
        ch.bounds = new Rect();
    }

    void DefineButtonExtra(boolean sound) {
        int tag = this.GetWord();
        SCharacter ch = this.FindCharacter(tag);
        if (ch == null || ch.type != 2) {
            return;
        }
        if (sound) {
            ch.soundPos = this.pos;
        } else {
            ch.cxformPos = this.pos;
        }
    }

    void DefineSound(int tagLen) {
        int tag = this.GetWord();
        if (this.FindCharacter(tag) != null) {
            return;
        }
        SCharacter ch = this.CreateCharacter(tag);
        if (ch == null) {
            return;
        }
        ch.type = 5;
        int format = this.GetByte();
        int samples = this.GetDWord();
        Sound sound = new Sound(format, samples, this.script, this.pos);
        ch.object = sound;
        if (sound == null) {
            this.FreeCharacter(tag);
            return;
        }
        ch.dataPos = this.pos;
        if (sound.CompressFormat() > 16) {
            this.FreeCharacter(tag);
        } else {
            sound.characterTag = tag;
            sound.next = this.streamSound.next;
            this.streamSound.next = sound;
        }
    }

    private void DefineFont() {
        int tag = this.GetWord();
        if (this.FindCharacter(tag) != null) {
            return;
        }
        SCharacter ch = this.CreateCharacter(tag);
        ch.type = 3;
        ch.bounds = new Rect();
        ch.dataPos = this.pos;
    }

    private void DefineText() {
        int tag = this.GetWord();
        if (this.FindCharacter(tag) != null) {
            return;
        }
        SCharacter ch = this.CreateCharacter(tag);
        ch.type = 4;
        ch.bounds = this.GetRect();
        ch.dataPos = this.pos;
    }

    private void ParseHeader() {
        if (this.scriptErr != 0) {
            return;
        }
        if (this.gotHeader) {
            return;
        }
        if (this.len < 21) {
            return;
        }
        this.frame = this.GetRect();
        this.frameRate = this.GetWord() << 8;
        this.frameDelay = 65536000 / this.frameRate;
        this.numFrames = this.GetWord();
        this.numFramesCompletePos = this.startPos = this.pos;
        this.curFrame = -1;
        this.gotHeader = true;
    }

    public void PushData(byte[] data, int chunkLen) {
        if (this.scriptErr != 0) {
            return;
        }
        int dataPos = 0;
        if (this.scriptLen < 0) {
            int n2 = Math.min(8 - this.headerLen, chunkLen);
            System.arraycopy(data, dataPos, this.headerBuf, this.headerLen, n2);
            dataPos += n2;
            chunkLen -= n2;
            this.headerLen += n2;
            if (this.headerLen == 8) {
                if (this.headerBuf[0] != 70 || this.headerBuf[1] != 87 || this.headerBuf[2] != 83) {
                    this.scriptErr = -1;
                    return;
                }
                this.version = this.headerBuf[3];
                System.out.println("Flash file version = " + this.version);
                this.scriptLen = this.headerBuf[4] & 0xFF | (this.headerBuf[5] & 0xFF) << 8 | (this.headerBuf[6] & 0xFF) << 16 | (this.headerBuf[7] & 0xFF) << 24;
                this.scriptLen -= 8;
                this.script = new byte[this.scriptLen];
                if (this.script == null) {
                    this.scriptErr = -2;
                    return;
                }
            } else {
                return;
            }
        }
        if (this.len + chunkLen > this.scriptLen) {
            chunkLen = Math.min(chunkLen, this.scriptLen - this.len);
        }
        System.arraycopy(data, dataPos, this.script, this.len, chunkLen);
        this.len += chunkLen;
        if (!this.gotHeader) {
            this.ParseHeader();
        }
        this.gotData.set();
    }

    private void DefineJPEGTables(int tagLen) {
        this.jpegTableLen = tagLen - 2;
        this.jpegTablePos = this.pos;
    }

    private int ImageClassToUse() {
        if (imageClassToUse == 0) {
            if (("SLAV" + System.getProperty("java.version")).indexOf("SLAV1.0") == -1) {
                imageClassToUse = 1;
            } else {
                imageClassToUse = 3;
                try {
                    Class.forName("sun.awt.image.ImageDecoder");
                    imageClassToUse = 2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return imageClassToUse;
    }

    private void DefineBits(int tagLen, int type) {
        block15: {
            block16: {
                int tag = this.GetWord();
                int tableStart = 0;
                int tableLen = 0;
                int dataStart = 0;
                int dataLen = 0;
                if (this.FindCharacter(tag) != null) {
                    return;
                }
                SCharacter ch = this.CreateCharacter(tag);
                if (ch == null) {
                    return;
                }
                ch.type = 1;
                ch.dataPos = this.pos - 8;
                if (type == 6) {
                    dataStart = this.pos + 2;
                    dataLen = tagLen - 4;
                    tableStart = this.jpegTablePos;
                    tableLen = this.jpegTableLen;
                } else {
                    int i2 = tableStart = this.pos;
                    while (i2 < this.end) {
                        if ((this.script[i2] & 0xFF) == 255 && (this.script[i2 + 1] & 0xFF) == 217) {
                            tableLen = i2 - tableStart;
                            break;
                        }
                        ++i2;
                    }
                    int i3 = tableStart + tableLen;
                    while (i3 < this.end) {
                        if ((this.script[i3] & 0xFF) == 255 && (this.script[i3 + 1] & 0xFF) == 216) {
                            dataStart = i3 + 2;
                            dataLen = tagLen - 6 - tableLen;
                            break;
                        }
                        ++i3;
                    }
                }
                byte[] bits = new byte[tableLen + dataLen];
                if (bits == null) break block16;
                System.arraycopy(this.script, tableStart, bits, 0, tableLen);
                System.arraycopy(this.script, dataStart, bits, tableLen, dataLen);
                switch (this.ImageClassToUse()) {
                    case 1: {
                        ch.object = new Bitmap(this.flash.getToolkit().createImage(bits), this.display);
                        break;
                    }
                    case 2: {
                        try {
                            Object object = Class.forName("ImageSource").newInstance();
                            if (object != null) {
                                ((ImageSource)object).SetData(bits);
                                ((ImageSource)object).CreateInputStream();
                                Bitmap bitmap = new Bitmap((ImageSource)object, this.display);
                                ((ImageSource)object).DestroyInputStream();
                                ch.object = bitmap;
                            }
                            break block15;
                        }
                        catch (Exception e2) {
                            ch.object = null;
                        }
                        break block15;
                    }
                    default: {
                        ch.object = null;
                        break;
                    }
                }
                break block15;
            }
            ch.object = null;
        }
    }

    private int DoTag() {
        if (this.script == null) {
            return -3;
        }
        if (this.scriptErr != 0) {
            return this.scriptErr;
        }
        if (this.atEnd) {
            return 2;
        }
        if (this.len - this.pos < 2) {
            return 1;
        }
        int savedPos = this.pos;
        int code = this.GetWord();
        int tagLen = code & 0x3F;
        if (tagLen == 63) {
            if (this.len - this.pos < 4) {
                this.pos = savedPos;
                return 1;
            }
            tagLen = this.GetDWord();
        }
        this.end = this.nextPos = this.pos + tagLen;
        if (this.nextPos > this.len) {
            this.pos = savedPos;
            return 1;
        }
        switch (code >> 6) {
            case 0: {
                this.atEnd = true;
                break;
            }
            case 1: {
                ++this.curFrame;
                break;
            }
            case 2: 
            case 22: {
                this.DefineShape();
                break;
            }
            case 3: {
                this.FreeCharacter(this.GetWord());
                break;
            }
            case 4: {
                this.PlaceObject();
                break;
            }
            case 5: {
                this.RemoveObject();
                break;
            }
            case 6: 
            case 21: {
                this.DefineBits(tagLen, code >> 6);
                break;
            }
            case 20: {
                break;
            }
            case 8: {
                this.DefineJPEGTables(tagLen);
                break;
            }
            case 14: {
                this.DefineSound(tagLen);
                break;
            }
            case 15: {
                this.StartSound();
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                this.DefineButtonExtra(true);
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 7: {
                this.DefineButton();
                break;
            }
            case 10: {
                this.DefineFont();
                break;
            }
            case 11: {
                this.DefineText();
                break;
            }
            case 9: {
                this.display.SetBackgroundColor(this.GetColor(), 3);
                break;
            }
            case 12: {
                if (this.nActions >= 16) break;
                this.actionList[this.nActions] = this.pos;
                ++this.nActions;
                break;
            }
            case 23: {
                this.DefineButtonExtra(false);
                break;
            }
        }
        this.pos = this.nextPos;
        return this.scriptErr;
    }

    public int DrawFrame(int fnum) {
        if (this.scriptErr != 0) {
            return this.scriptErr;
        }
        if (!this.gotHeader) {
            return 1;
        }
        if (this.curFrame > fnum) {
            this.FreeAll();
        }
        int res = 0;
        while (this.curFrame < fnum && res == 0) {
            res = this.DoTag();
        }
        return res;
    }

    boolean FrameComplete(int f2) {
        if (this.numFramesComplete >= f2) {
            return true;
        }
        if (this.scriptComplete) {
            return true;
        }
        if (this.script == null || this.scriptErr != -3) {
            return false;
        }
        SParser parser = new SParser();
        parser.Attach(this.script, this.numFramesCompletePos);
        while (true) {
            if (this.len - parser.pos < 2) {
                return false;
            }
            int code = parser.GetWord();
            int tagLen = code & 0x3F;
            if (tagLen == 63) {
                if (this.len - this.pos < 4) {
                    return false;
                }
                tagLen = parser.GetDWord();
            }
            parser.pos += tagLen;
            if (parser.pos > this.len) {
                return false;
            }
            this.numFramesCompletePos = parser.pos;
            if (code >> 6 != 1) continue;
            ++this.numFramesComplete;
            if (this.numFramesComplete >= f2) break;
        }
        return true;
    }

    public void loadScript(InputStream stream) {
        this.ClearScript();
        this.scriptStream = stream;
        Thread loader = new Thread(this);
        loader.setPriority(6);
        loader.start();
    }

    public boolean loadScript(PullSourceStream pss) {
        this.ClearScript();
        try {
            int len;
            byte[] buffer = new byte[512];
            while ((len = pss.read(buffer, 0, buffer.length)) >= 0) {
                this.PushData(buffer, len);
            }
        }
        catch (IOException e2) {
            this.scriptComplete = true;
            return false;
        }
        this.scriptComplete = true;
        return true;
    }

    public void run() {
        try {
            int len;
            byte[] buffer = new byte[512];
            while ((len = this.scriptStream.read(buffer)) >= 0) {
                this.PushData(buffer, len);
            }
            this.scriptStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.scriptStream = null;
        this.scriptComplete = true;
    }

    public int percentLoaded() {
        if (this.scriptComplete || this.len >= this.scriptLen) {
            return 100;
        }
        return this.len / this.scriptLen;
    }
}

