/*
 * Decompiled with CFR 0.152.
 */
package studio.ultoolapp.lotusutil;

import android.content.Context;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import java.util.ArrayList;
import java.util.List;

public class ViewPagerUtil {
    public static void BindNavigationAndViewPager(Context context, FragmentAdapter adapter, ViewPager viewPager, BottomNavigationView bottomNavigationView) {
        viewPager.setAdapter((PagerAdapter)adapter);
        bottomNavigationView.setOnNavigationItemSelectedListener((BottomNavigationView.OnNavigationItemSelectedListener)new EasyBottomNavigationViewItemSelectedListener(context, bottomNavigationView.getMenu(), viewPager));
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new EasyPageChangeListener(context, bottomNavigationView.getMenu()));
    }

    public static class EasyBottomNavigationViewItemSelectedListener
    implements BottomNavigationView.OnNavigationItemSelectedListener {
        private final List<MenuItem> items = new ArrayList<MenuItem>();
        private String debugTag;
        private Menu menu;
        private ViewPager viewPager;

        public EasyBottomNavigationViewItemSelectedListener(Context context, Menu navigationMenu, ViewPager viewPager) {
            this.debugTag = context.getClass().getSimpleName();
            if (this.debugTag.length() > 23) {
                this.debugTag = this.debugTag.substring(0, 22);
            }
            this.menu = navigationMenu;
            this.viewPager = viewPager;
            if (this.menu == null || this.menu.size() == 0) {
                Log.e((String)this.debugTag, (String)"EasyBottomNavigationViewItemSelectedListener: menu is null or no items inside. VIEW PAGER WON'T WORK CORRECTLY. Please make sure there're items and they belongs directly to this menu (not the sub menu).", (Throwable)new NullPointerException("menu"));
                return;
            }
            for (int i = 0; i < this.menu.size(); ++i) {
                this.items.add(this.menu.getItem(i));
            }
        }

        public boolean onNavigationItemSelected(@NonNull MenuItem menuItem) {
            int index = this.items.indexOf(menuItem);
            if (index < 0) {
                Log.e((String)this.debugTag, (String)"onNavigationItemSelected: ViewPager items not enough! View Pager won't change page. Did you forget to add enough fragment?");
                return true;
            }
            Log.d((String)this.debugTag, (String)("onNavigationItemSelected: select item " + index));
            this.viewPager.setCurrentItem(index);
            return false;
        }
    }

    public static class EasyPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private String debugTag;
        private MenuItem prevMenuItem = null;
        private Menu menu;

        public EasyPageChangeListener(Context context, Menu navigationMenu) {
            this.debugTag = context.getClass().getSimpleName();
            if (this.debugTag.length() > 23) {
                this.debugTag = this.debugTag.substring(0, 22);
            }
            this.menu = navigationMenu;
            if (this.menu == null || this.menu.size() == 0) {
                Log.e((String)this.debugTag, (String)"EasyPageChangeListener: menu is null or no items inside. VIEW PAGER WON'T WORK CORRECTLY. Please make sure there're items and they belongs directly to this menu (not the sub menu).", (Throwable)new NullPointerException("menu"));
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixel) {
        }

        public void onPageSelected(int position) {
            if (this.menu == null || this.menu.size() == 0) {
                Log.e((String)this.debugTag, (String)"onPageSelected: menu is null or no items inside. VIEW PAGER WON'T WORK CORRECTLY. Please make sure there're items and they belongs directly to this menu (not the sub menu).");
                return;
            }
            if (this.prevMenuItem != null) {
                this.prevMenuItem.setChecked(false);
            } else {
                this.menu.getItem(0).setChecked(false);
            }
            Log.d((String)this.debugTag, (String)("onPageSelected: select page " + position));
            if (position >= this.menu.size()) {
                Log.e((String)this.debugTag, (String)"onPageSelected: out of menu bounds! Won't change the navigation selected. Did you add too many fragments, or is navigation menu too few to match them?");
                return;
            }
            this.menu.getItem(position).setChecked(true);
            this.prevMenuItem = this.menu.getItem(position);
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    public static final class FragmentAdapter
    extends FragmentPagerAdapter {
        private static final String TAG = "FragmentAdapter";
        private List<Fragment> mFragmentList = new ArrayList<Fragment>();
        private List<String> mFragmentTitleList = new ArrayList<String>();

        public FragmentAdapter(FragmentManager manager) {
            super(manager, 1);
        }

        public Fragment getItem(int position) {
            return this.mFragmentList.get(position);
        }

        public int getCount() {
            return this.mFragmentList.size();
        }

        public void addFragment(Fragment fragment, String title) {
            this.mFragmentList.add(fragment);
            this.mFragmentTitleList.add(title);
        }

        public void addFragment(Fragment fragment, String title, int atPosition) {
            if (atPosition >= this.mFragmentList.size()) {
                Log.w((String)TAG, (String)"addFragment: trying to add fragment at out-of-list position. Will be treated as add at last.");
                this.addFragment(fragment, title);
                return;
            }
            if (atPosition < 0) {
                Log.w((String)TAG, (String)"addFragment: trying to add fragment at negative position! Will be treated as add at first.");
                atPosition = 0;
            }
            this.mFragmentList.add(atPosition, fragment);
            this.mFragmentTitleList.add(atPosition, title);
        }

        public void removeFragment(int position) {
            this.mFragmentList.remove(position);
            this.mFragmentTitleList.remove(position);
        }

        public void removeFragment(Fragment fragment) {
            int position = this.mFragmentList.indexOf(fragment);
            if (position < 0) {
                Log.e((String)TAG, (String)"removeFragment: trying to remove a fragment which has not been added to this adapter. (Operation ignored.)", (Throwable)new IndexOutOfBoundsException());
                return;
            }
            this.removeFragment(position);
        }

        public void setPageTitle(int position, String title) {
            if (position >= this.mFragmentTitleList.size() || position < 0) {
                Log.e((String)TAG, (String)"setPageTitle: illegal position: too large or negative! (Operation ignored.)", (Throwable)new IndexOutOfBoundsException());
                return;
            }
            this.mFragmentTitleList.set(position, title);
        }

        public CharSequence getPageTitle(int position) {
            return this.mFragmentTitleList.get(position);
        }
    }
}

