/*
 * Decompiled with CFR 0.152.
 */
package studio.ultoolapp.lotusutil;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;

public abstract class EasyRecyclerViewAdapter<T>
extends RecyclerView.Adapter {
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_HEADER = 1;
    private static final int TYPE_FOOTER = 2;
    @LayoutRes
    protected int mViewHolderLayout;
    protected Context mContext;
    protected RecyclerView mRecyclerView;
    protected List<T> mDataList;
    private View headerView = null;
    private View footerView = null;

    public EasyRecyclerViewAdapter(Context context, @LayoutRes int viewHolderLayout, List<T> data) {
        this.mContext = context;
        this.mViewHolderLayout = viewHolderLayout;
        this.mDataList = data;
    }

    public abstract void bindData(View var1, int var2, T var3);

    public View getHeaderView() {
        return this.headerView;
    }

    public void setHeaderView(View headerView) {
        this.headerView = headerView;
        this.notifyItemInserted(0);
    }

    public void setHeaderView(@LayoutRes int headerViewLayout) {
        if (this.mRecyclerView == null) {
            Log.e((String)this.mContext.getClass().getSimpleName(), (String)"setHeaderView: no recycler view applied. Please call RecyclerView.setAdapter() before this method.", (Throwable)new NullPointerException("RecyclerView"));
            return;
        }
        this.setHeaderView(this.mRecyclerView, headerViewLayout);
    }

    public void setHeaderView(RecyclerView parent, @LayoutRes int headerViewLayout) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(headerViewLayout, (ViewGroup)parent, false);
        if (view == null) {
            Log.e((String)this.mContext.getClass().getSimpleName(), (String)"setHeaderView: error when inflating / creating view.", (Throwable)new NullPointerException("View"));
            return;
        }
        this.setHeaderView(view);
    }

    public View getFooterView() {
        return this.footerView;
    }

    public void setFooterView(View footerView) {
        this.footerView = footerView;
        this.notifyItemInserted(this.getItemCount() - 1);
    }

    public void setFooterView(@LayoutRes int headerViewLayout) {
        if (this.mRecyclerView == null) {
            Log.e((String)this.mContext.getClass().getSimpleName(), (String)"setFooterView: no recycler view applied. Please call RecyclerView.setAdapter() before this method.", (Throwable)new NullPointerException("RecyclerView"));
            return;
        }
        this.setFooterView(this.mRecyclerView, headerViewLayout);
    }

    public void setFooterView(RecyclerView parent, @LayoutRes int footerViewLayout) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(footerViewLayout, (ViewGroup)parent, false);
        if (view == null) {
            Log.e((String)this.mContext.getClass().getSimpleName(), (String)"setFooterView: error when inflating / creating view.", (Throwable)new NullPointerException("View"));
            return;
        }
        this.setFooterView(view);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.headerView != null && viewType == 1) {
            return new RecyclerView.ViewHolder(this.headerView){};
        }
        if (this.footerView != null && viewType == 2) {
            return new RecyclerView.ViewHolder(this.footerView){};
        }
        View baseView = LayoutInflater.from((Context)this.mContext).inflate(this.mViewHolderLayout, parent, false);
        return new RecyclerView.ViewHolder(baseView){};
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        int correctFactor;
        int n = correctFactor = this.headerView != null ? 1 : 0;
        if (this.getItemViewType(position) == 0) {
            this.bindData(viewHolder.itemView, position - correctFactor, this.mDataList.get(position - correctFactor));
        }
    }

    public int getItemCount() {
        return this.mDataList.size() + (this.headerView != null ? 1 : 0) + (this.footerView != null ? 1 : 0);
    }

    public int getItemViewType(int position) {
        if (this.headerView != null && position == 0) {
            return 1;
        }
        if (this.footerView != null && position == this.getItemCount() - 1) {
            return 2;
        }
        return 0;
    }

    public static abstract class OnScrollToEndListener
    extends RecyclerView.OnScrollListener {
        private boolean isVertical;
        private boolean smoothOperation = false;

        protected OnScrollToEndListener(boolean isVertical) {
            this.isVertical = isVertical;
        }

        public OnScrollToEndListener setSmoothOperation(boolean smoothOperation) {
            this.smoothOperation = smoothOperation;
            return this;
        }

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            if (newState == 0 && !this.smoothOperation) {
                if (this.isVertical) {
                    if (!recyclerView.canScrollVertically(1)) {
                        this.onScrollToEnd();
                    }
                } else if (!recyclerView.canScrollHorizontally(1)) {
                    this.onScrollToEnd();
                }
            }
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            if (this.smoothOperation) {
                if (this.isVertical) {
                    if (!recyclerView.canScrollVertically(1)) {
                        this.onScrollToEnd();
                    }
                } else if (!recyclerView.canScrollHorizontally(1)) {
                    this.onScrollToEnd();
                }
            }
        }

        public abstract void onScrollToEnd();
    }
}

