/*
 * Decompiled with CFR 0.152.
 */
package studio.crud.crudframework.utils.utils;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ParameterLock
implements Lock {
    private static final Map<Object, WeakKeyLockPair> locks = new WeakHashMap<Object, WeakKeyLockPair>();
    private final Object key;
    private final Lock lock;

    private ParameterLock(Object key, Lock lock) {
        this.key = key;
        this.lock = lock;
    }

    public static Lock getCanonicalParameterLock(String prefix, String ... params) {
        String key = prefix;
        for (String param : params) {
            key = key + "_" + param;
        }
        return ParameterLock.getCanonicalParameterLock(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock getCanonicalParameterLock(Object param) {
        Object canonical = null;
        Lock lock = null;
        Map<Object, WeakKeyLockPair> map = locks;
        synchronized (map) {
            WeakKeyLockPair pair = locks.get(param);
            if (pair != null) {
                canonical = pair.param.get();
            }
            if (canonical == null) {
                canonical = param;
                pair = new WeakKeyLockPair(canonical, new ReentrantLock());
                locks.put(canonical, pair);
            }
        }
        lock = locks.get(canonical).lock;
        return new ParameterLock(canonical, lock);
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(time, unit);
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }

    public String toString() {
        return "ParameterLock [key=" + this.key + ", lock=" + this.lock + ']';
    }

    private static final class WeakKeyLockPair {
        private final Reference<Object> param;
        private final Lock lock;

        private WeakKeyLockPair(Object param, Lock lock) {
            this.param = new WeakReference<Object>(param);
            this.lock = lock;
        }
    }
}

