/*
 * Decompiled with CFR 0.152.
 */
package studio.crud.crudframework.utils.component.startup;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import studio.crud.crudframework.utils.component.startup.annotation.PostStartUp;
import studio.crud.crudframework.utils.utils.ReflectionUtils;

public class PostStartupHandler
implements ApplicationListener<ContextRefreshedEvent> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    private boolean wasLoaded = false;

    public synchronized void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (this.wasLoaded) {
            return;
        }
        try {
            this.wasLoaded = true;
            Map beans = this.applicationContext.getBeansWithAnnotation(Component.class);
            TreeMap<Integer, ArrayList<MethodHandlerDTO>> methodsByPriority = new TreeMap<Integer, ArrayList<MethodHandlerDTO>>();
            for (Map.Entry entry : beans.entrySet()) {
                Object handler = entry.getValue();
                if (handler instanceof TargetClassAware) {
                    handler = ((Advised)handler).getTargetSource().getTarget();
                }
                List<Method> methods = ReflectionUtils.getMethods(handler.getClass());
                for (Method method : methods) {
                    PostStartUp annotation = (PostStartUp)AnnotationUtils.findAnnotation((Method)method, PostStartUp.class);
                    if (annotation == null) continue;
                    ArrayList<MethodHandlerDTO> methodsOfPriority = (ArrayList<MethodHandlerDTO>)methodsByPriority.get(annotation.priority());
                    if (methodsOfPriority == null) {
                        methodsOfPriority = new ArrayList<MethodHandlerDTO>();
                        methodsByPriority.put(annotation.priority(), methodsOfPriority);
                    }
                    methodsOfPriority.add(new MethodHandlerDTO(method, handler));
                }
            }
            for (Map.Entry entry : methodsByPriority.descendingMap().entrySet()) {
                for (MethodHandlerDTO dto : (List)entry.getValue()) {
                    try {
                        dto.method.setAccessible(true);
                        dto.method.invoke(dto.handler, new Object[0]);
                        dto.method.setAccessible(false);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to load postStartUp of bean - " + dto.handler.getClass().getSimpleName(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed postStartUp process", (Throwable)e);
        }
    }

    class MethodHandlerDTO {
        Method method;
        Object handler;

        public MethodHandlerDTO(Method method, Object handler) {
            this.method = method;
            this.handler = handler;
        }
    }
}

