/*
 * Decompiled with CFR 0.152.
 */
package studio.clapp.wheelpicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.OverScroller;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.clapp.wheelpicker.OnValueChangeListener;
import studio.clapp.wheelpicker.R;
import studio.clapp.wheelpicker.adapters.WheelAdapter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0018\u0002\n\u0002\b(\u0018\u0000 \u0099\u00012\u00020\u0001:\u0004\u0099\u0001\u009a\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00109\u001a\u000207H\u0002J \u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u0007H\u0002J\u0010\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020\u0007H\u0002J\b\u0010@\u001a\u00020\u0007H\u0002J\b\u0010A\u001a\u000207H\u0016J\b\u0010B\u001a\u00020\u0007H\u0002J\b\u0010C\u001a\u000207H\u0002J\u0010\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u00020\u0013H\u0014J\u0006\u0010H\u001a\u00020\u0007J\u0006\u0010I\u001a\u00020(J\b\u0010J\u001a\u00020\u0007H\u0002J\b\u0010K\u001a\u00020\u0007H\u0002J\u0006\u0010L\u001a\u00020(J\u0006\u0010M\u001a\u00020(J\b\u0010N\u001a\u00020\u0007H\u0016J\u0010\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020(H\u0002J\u0006\u0010Q\u001a\u00020\u0013J\u0006\u0010R\u001a\u00020\u0007J\b\u0010S\u001a\u00020\u0007H\u0014J\b\u0010T\u001a\u00020\u0007H\u0014J\b\u0010U\u001a\u00020\u0013H\u0014J\u000e\u0010V\u001a\u00020(2\u0006\u0010W\u001a\u00020\u0007J\u0006\u0010X\u001a\u00020\u000eJ\u0010\u0010Y\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0010\u0010[\u001a\u0002072\u0006\u0010\\\u001a\u00020\u0007H\u0002J\b\u0010]\u001a\u000207H\u0002J\b\u0010^\u001a\u000207H\u0002J\b\u0010_\u001a\u000207H\u0002J\b\u0010`\u001a\u000207H\u0002J\u0010\u0010a\u001a\u00020\u000e2\u0006\u0010W\u001a\u00020\u0007H\u0002J\u001f\u0010b\u001a\u0004\u0018\u0001072\u0006\u0010c\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010eJ\u0010\u0010f\u001a\u0002072\u0006\u0010E\u001a\u00020FH\u0014J0\u0010g\u001a\u0002072\u0006\u0010h\u001a\u00020\u000e2\u0006\u0010i\u001a\u00020\u00072\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u00020\u0007H\u0014J\u0018\u0010m\u001a\u0002072\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u0007H\u0014J\u0010\u0010p\u001a\u0002072\u0006\u0010d\u001a\u00020\u0007H\u0002J\u0010\u0010q\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020sH\u0017J\u0010\u0010t\u001a\u0002072\u0006\u0010r\u001a\u00020sH\u0002J\b\u0010u\u001a\u000207H\u0002J\u0006\u0010v\u001a\u000207J\u0018\u0010w\u001a\u0002072\u0006\u0010x\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\u0007H\u0016J\u000e\u0010y\u001a\u0002072\u0006\u0010W\u001a\u00020\u0007J\u000e\u0010z\u001a\u0002072\u0006\u0010P\u001a\u00020(J\u001a\u0010{\u001a\u0002072\b\u0010|\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010}\u001a\u00020\u000eJ\u0016\u0010~\u001a\u0002072\b\u0010\u007f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0003\u0010\u0080\u0001J\u0010\u0010\u0081\u0001\u001a\u0002072\u0007\u0010\u0082\u0001\u001a\u00020\u0007J\u0018\u0010\u0083\u0001\u001a\u0002072\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0003\u0010\u0080\u0001J\u0010\u0010\u0085\u0001\u001a\u0002072\u0007\u0010\u0086\u0001\u001a\u00020\u0007J\u0015\u0010\u0087\u0001\u001a\u0002072\f\u00105\u001a\b\u0012\u0004\u0012\u00020706J\u0015\u0010\u0088\u0001\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020706J\u0010\u0010\u0089\u0001\u001a\u0002072\u0007\u0010\u008a\u0001\u001a\u00020\u001cJ\u0012\u0010\u008b\u0001\u001a\u0002072\t\b\u0001\u0010\u008c\u0001\u001a\u00020\u0007J\u000f\u0010\u008d\u0001\u001a\u0002072\u0006\u0010!\u001a\u00020\u0013J\u0012\u0010\u008e\u0001\u001a\u0002072\t\b\u0001\u0010\u008f\u0001\u001a\u00020\u0007J\u0012\u0010\u0090\u0001\u001a\u0002072\t\b\u0001\u0010\u008c\u0001\u001a\u00020\u0007J\u000f\u0010\u0091\u0001\u001a\u0002072\u0006\u0010P\u001a\u00020(J\u0010\u0010\u0092\u0001\u001a\u0002072\u0007\u0010\u0093\u0001\u001a\u00020\u0007J\u0010\u0010\u0094\u0001\u001a\u0002072\u0007\u0010\u0095\u0001\u001a\u00020\u000eJ\u000f\u0010\u0096\u0001\u001a\u0002072\u0006\u0010W\u001a\u00020\u0007J\u000f\u0010\u0097\u0001\u001a\u0002072\u0006\u0010P\u001a\u00020(J\u0011\u0010\u0098\u0001\u001a\u00020\u00072\u0006\u0010W\u001a\u00020\u0007H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020706X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020706X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lstudio/clapp/wheelpicker/WheelPicker;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAdapter", "Lstudio/clapp/wheelpicker/adapters/WheelAdapter;", "mCurSelectedItemIndex", "mCurrentFirstItemOffset", "mFadingEdgeEnabled", "", "mInitialFirstItemOffset", "mIsDragging", "mItemHeight", "mLastY", "", "mMaxIndex", "mMaxValidIndex", "Ljava/lang/Integer;", "mMaximumVelocity", "mMinIndex", "mMinValidIndex", "mMinimumVelocity", "mOnValueChangeListener", "Lstudio/clapp/wheelpicker/OnValueChangeListener;", "mOverScroller", "Landroid/widget/OverScroller;", "mPreviousScrollerY", "mSelectedTextColor", "mSelectedTextScale", "mSelectorItemCount", "mSelectorItemIndices", "Ljava/util/ArrayList;", "mSelectorItemValidStatus", "mSelectorVisibleItemCount", "mTextAlign", "", "mTextGapHeight", "mTextHeight", "mTextPaint", "Landroid/graphics/Paint;", "mTextSize", "mTouchSlop", "mUnSelectedTextColor", "mVelocityTracker", "Landroid/view/VelocityTracker;", "mWheelMiddleItemIndex", "mWheelVisibleItemMiddleIndex", "mWrapSelectorWheelPreferred", "touchDownListener", "Lkotlin/Function0;", "", "touchUpListener", "adjustItemVertical", "calculateSize", "suggestedSize", "paramSize", "measureSpec", "changeValueBySteps", "steps", "computeMaximumWidth", "computeScroll", "computeTextHeight", "decreaseSelectorsIndex", "drawVertical", "canvas", "Landroid/graphics/Canvas;", "getBottomFadingEdgeStrength", "getCurrentIndex", "getCurrentItem", "getGapHeight", "getItemHeight", "getMaxValue", "getMinValue", "getMinimumWidth", "getPosition", "value", "getSelectedTextScale", "getSuggestedMinHeight", "getSuggestedMinimumHeight", "getSuggestedMinimumWidth", "getTopFadingEdgeStrength", "getValue", "position", "getWrapSelectorWheel", "getWrappedSelectorIndex", "selectorIndex", "handlerClickVertical", "y", "increaseSelectorsIndex", "initializeFadingEdges", "initializeSelectorWheel", "initializeSelectorWheelIndices", "isValidPosition", "notifyChange", "previous", "current", "(II)Lkotlin/Unit;", "onDraw", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSelectionChanged", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onTouchEventVertical", "recyclerVelocityTracker", "reset", "scrollBy", "x", "scrollTo", "scrollToValue", "setAdapter", "adapter", "indexRangeBasedOnAdapterSize", "setMaxValidValue", "maxValid", "(Ljava/lang/Integer;)V", "setMaxValue", "max", "setMinValidValue", "minValid", "setMinValue", "min", "setOnDownListener", "setOnUpListener", "setOnValueChangedListener", "onValueChangeListener", "setSelectedTextColor", "colorId", "setSelectedTextScale", "setTextSize", "mTextSizeRes", "setUnselectedTextColor", "setValue", "setWheelItemCount", "count", "setWrapSelectorWheel", "wrap", "smoothScrollTo", "smoothScrollToValue", "validatePosition", "Companion", "TextAlign", "wheelpicker_release"})
public final class WheelPicker
extends View {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int mSelectorItemCount;
    private int mSelectorVisibleItemCount;
    private int mMinIndex;
    private int mMaxIndex;
    @Nullable
    private Integer mMaxValidIndex;
    @Nullable
    private Integer mMinValidIndex;
    private int mWheelMiddleItemIndex;
    private int mWheelVisibleItemMiddleIndex;
    @NotNull
    private ArrayList<Integer> mSelectorItemIndices;
    @NotNull
    private ArrayList<Boolean> mSelectorItemValidStatus;
    private int mCurSelectedItemIndex;
    private boolean mWrapSelectorWheelPreferred;
    @NotNull
    private Paint mTextPaint;
    private int mSelectedTextColor;
    private int mUnSelectedTextColor;
    private int mTextSize;
    @NotNull
    private String mTextAlign;
    @Nullable
    private OverScroller mOverScroller;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private final int mTouchSlop;
    private final int mMaximumVelocity;
    private final int mMinimumVelocity;
    private float mLastY;
    private boolean mIsDragging;
    private int mCurrentFirstItemOffset;
    private int mInitialFirstItemOffset;
    private int mTextGapHeight;
    private int mItemHeight;
    private int mTextHeight;
    private int mPreviousScrollerY;
    @Nullable
    private OnValueChangeListener mOnValueChangeListener;
    @Nullable
    private WheelAdapter mAdapter;
    private boolean mFadingEdgeEnabled;
    private float mSelectedTextScale;
    private Function0<Unit> touchDownListener;
    private Function0<Unit> touchUpListener;
    @Deprecated
    public static final float TOP_AND_BOTTOM_FADING_EDGE_STRENGTH = 0.9f;
    @Deprecated
    public static final int SNAP_SCROLL_DURATION = 300;
    @Deprecated
    public static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 4;
    @Deprecated
    public static final int DEFAULT_ITEM_COUNT = 3;
    @Deprecated
    public static final int DEFAULT_TEXT_SIZE = 80;

    @JvmOverloads
    public WheelPicker(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mTextPaint = new Paint();
        this.mInitialFirstItemOffset = Integer.MIN_VALUE;
        this.mFadingEdgeEnabled = true;
        this.mSelectedTextScale = 0.3f;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WheelPicker, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026lPicker, defStyleAttr, 0)");
        TypedArray attributesArray = typedArray;
        this.mSelectorItemCount = attributesArray.getInt(R.styleable.WheelPicker_wheelItemCount, 3) + 2;
        this.mWheelMiddleItemIndex = (this.mSelectorItemCount - 1) / 2;
        this.mSelectorVisibleItemCount = this.mSelectorItemCount - 2;
        this.mWheelVisibleItemMiddleIndex = (this.mSelectorVisibleItemCount - 1) / 2;
        this.mSelectorItemIndices = new ArrayList(this.mSelectorItemCount);
        this.mSelectorItemValidStatus = new ArrayList(this.mSelectorItemCount);
        this.mMinIndex = attributesArray.getInt(R.styleable.WheelPicker_min, Integer.MIN_VALUE);
        this.mMaxIndex = attributesArray.getInt(R.styleable.WheelPicker_max, Integer.MAX_VALUE);
        if (attributesArray.hasValue(R.styleable.WheelPicker_maxValidIndex)) {
            this.mMaxValidIndex = attributesArray.getInt(R.styleable.WheelPicker_maxValidIndex, 0);
        }
        if (attributesArray.hasValue(R.styleable.WheelPicker_minValidIndex)) {
            this.mMinValidIndex = attributesArray.getInt(R.styleable.WheelPicker_minValidIndex, 0);
        }
        this.mWrapSelectorWheelPreferred = attributesArray.getBoolean(R.styleable.WheelPicker_wrapSelectorWheel, false);
        this.mSelectedTextScale = attributesArray.getFloat(R.styleable.WheelPicker_selectedTextScale, 0.3f);
        this.mOverScroller = new OverScroller(context, (Interpolator)new DecelerateInterpolator(2.5f));
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity() / 4;
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mSelectedTextColor = attributesArray.getColor(R.styleable.WheelPicker_selectedTextColor, ContextCompat.getColor((Context)context, (int)R.color.text_color_time_picker));
        this.mUnSelectedTextColor = attributesArray.getColor(R.styleable.WheelPicker_textColor, ContextCompat.getColor((Context)context, (int)R.color.text_color_time_picker));
        this.mTextSize = attributesArray.getDimensionPixelSize(R.styleable.WheelPicker_textSize, 80);
        int textAlignInt = attributesArray.getInt(R.styleable.WheelPicker_align, 1);
        TextAlign[] textAlignArray = TextAlign.values();
        this.mTextAlign = textAlignArray[textAlignInt % textAlignArray.length].toString();
        this.mFadingEdgeEnabled = attributesArray.getBoolean(R.styleable.WheelPicker_fadingEdgeEnabled, true);
        Paint paint = this.mTextPaint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$_init__u24lambda_u2d0 = paint;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d0.setAntiAlias(true);
        $this$_init__u24lambda_u2d0.setAntiAlias(true);
        $this$_init__u24lambda_u2d0.setTextSize((float)this.mTextSize);
        $this$_init__u24lambda_u2d0.setTextAlign(Paint.Align.valueOf((String)this.mTextAlign));
        $this$_init__u24lambda_u2d0.setStyle(Paint.Style.FILL_AND_STROKE);
        int typefaceResId = attributesArray.getResourceId(R.styleable.WheelPicker_android_fontFamily, 0);
        if (typefaceResId != 0) {
            $this$_init__u24lambda_u2d0.setTypeface(ResourcesCompat.getFont((Context)context, (int)typefaceResId));
        }
        attributesArray.recycle();
        this.initializeSelectorWheelIndices();
    }

    public /* synthetic */ WheelPicker(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (lp == null) {
            lp = new ViewGroup.LayoutParams(-2, -2);
        }
        int width = this.calculateSize(this.getSuggestedMinimumWidth(), lp.width, widthMeasureSpec);
        int height = this.calculateSize(this.getSuggestedMinimumHeight(), lp.height, heightMeasureSpec);
        this.setMeasuredDimension(width += this.getPaddingLeft() + this.getPaddingRight(), height += this.getPaddingTop() + this.getPaddingBottom());
    }

    protected int getSuggestedMinimumWidth() {
        int suggested = super.getSuggestedMinimumHeight();
        if (this.mSelectorVisibleItemCount > 0) {
            suggested = RangesKt.coerceAtLeast((int)suggested, (int)this.computeMaximumWidth());
        }
        return suggested;
    }

    protected int getSuggestedMinimumHeight() {
        int suggested = super.getSuggestedMinimumWidth();
        if (this.mSelectorVisibleItemCount > 0) {
            Paint.FontMetricsInt fontMetricsInt = this.mTextPaint.getFontMetricsInt();
            int height = fontMetricsInt.descent - fontMetricsInt.ascent;
            suggested = RangesKt.coerceAtLeast((int)suggested, (int)(height * this.mSelectorVisibleItemCount));
        }
        return suggested;
    }

    public int getMinimumWidth() {
        return this.getSuggestedMinimumWidth();
    }

    protected float getBottomFadingEdgeStrength() {
        return 0.9f;
    }

    protected float getTopFadingEdgeStrength() {
        return 0.9f;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawVertical(canvas);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onTouchEventVertical(event);
        return true;
    }

    public void scrollBy(int x, int y) {
        Object object;
        int gap;
        block19: {
            block20: {
                block17: {
                    block18: {
                        if (y == 0) {
                            return;
                        }
                        gap = this.mTextGapHeight;
                        if (this.mWrapSelectorWheelPreferred || y <= 0) break block17;
                        object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
                        if (((Number)object).intValue() <= this.mMinIndex) break block18;
                        if (this.mMinValidIndex == null) break block17;
                        object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
                        int n = ((Number)object).intValue();
                        Integer n2 = this.mMinValidIndex;
                        Intrinsics.checkNotNull((Object)n2);
                        if (n > n2) break block17;
                    }
                    if (this.mCurrentFirstItemOffset + y - this.mInitialFirstItemOffset < gap / 2) {
                        object = this;
                        object.mCurrentFirstItemOffset += y;
                    } else {
                        this.mCurrentFirstItemOffset = this.mInitialFirstItemOffset + gap / 2;
                        OverScroller overScroller = this.mOverScroller;
                        Intrinsics.checkNotNull((Object)overScroller);
                        if (!overScroller.isFinished() && !this.mIsDragging) {
                            OverScroller overScroller2 = this.mOverScroller;
                            Intrinsics.checkNotNull((Object)overScroller2);
                            overScroller2.abortAnimation();
                        }
                    }
                    return;
                }
                if (this.mWrapSelectorWheelPreferred || y >= 0) break block19;
                object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
                if (((Number)object).intValue() >= this.mMaxIndex) break block20;
                if (this.mMaxValidIndex == null) break block19;
                object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
                int n = ((Number)object).intValue();
                Integer n3 = this.mMaxValidIndex;
                Intrinsics.checkNotNull((Object)n3);
                if (n < n3) break block19;
            }
            if (this.mCurrentFirstItemOffset + y - this.mInitialFirstItemOffset > -(gap / 2)) {
                object = this;
                object.mCurrentFirstItemOffset += y;
            } else {
                this.mCurrentFirstItemOffset = this.mInitialFirstItemOffset - gap / 2;
                OverScroller overScroller = this.mOverScroller;
                Intrinsics.checkNotNull((Object)overScroller);
                if (!overScroller.isFinished() && !this.mIsDragging) {
                    OverScroller overScroller3 = this.mOverScroller;
                    Intrinsics.checkNotNull((Object)overScroller3);
                    overScroller3.abortAnimation();
                }
            }
            return;
        }
        object = this;
        object.mCurrentFirstItemOffset += y;
        while (this.mCurrentFirstItemOffset - this.mInitialFirstItemOffset < -gap) {
            object = this;
            object.mCurrentFirstItemOffset += this.mItemHeight;
            this.increaseSelectorsIndex();
            if (this.mWrapSelectorWheelPreferred) continue;
            object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
            if (((Number)object).intValue() < this.mMaxIndex) {
                if (this.mMaxValidIndex == null) continue;
                object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
                int n = ((Number)object).intValue();
                Integer n4 = this.mMaxValidIndex;
                Intrinsics.checkNotNull((Object)n4);
                if (n < n4) continue;
            }
            this.mCurrentFirstItemOffset = this.mInitialFirstItemOffset;
        }
        while (this.mCurrentFirstItemOffset - this.mInitialFirstItemOffset > gap) {
            object = this;
            object.mCurrentFirstItemOffset -= this.mItemHeight;
            this.decreaseSelectorsIndex();
            if (this.mWrapSelectorWheelPreferred) continue;
            object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
            if (((Number)object).intValue() > this.mMinIndex) {
                if (this.mMinValidIndex == null) continue;
                object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
                int n = ((Number)object).intValue();
                Integer n5 = this.mMinValidIndex;
                Intrinsics.checkNotNull((Object)n5);
                if (n > n5) continue;
            }
            this.mCurrentFirstItemOffset = this.mInitialFirstItemOffset;
        }
        object = this.mSelectorItemIndices.get(this.mWheelMiddleItemIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mSelectorItemIndices[mWheelMiddleItemIndex]");
        this.onSelectionChanged(((Number)object).intValue());
    }

    public void computeScroll() {
        super.computeScroll();
        OverScroller overScroller = this.mOverScroller;
        Intrinsics.checkNotNull((Object)overScroller);
        if (overScroller.computeScrollOffset()) {
            OverScroller overScroller2 = this.mOverScroller;
            Intrinsics.checkNotNull((Object)overScroller2);
            int x = overScroller2.getCurrX();
            OverScroller overScroller3 = this.mOverScroller;
            Intrinsics.checkNotNull((Object)overScroller3);
            int y = overScroller3.getCurrY();
            if (this.mPreviousScrollerY == 0) {
                OverScroller overScroller4 = this.mOverScroller;
                Intrinsics.checkNotNull((Object)overScroller4);
                this.mPreviousScrollerY = overScroller4.getStartY();
            }
            this.scrollBy(x, y - this.mPreviousScrollerY);
            this.mPreviousScrollerY = y;
            this.invalidate();
        } else if (!this.mIsDragging) {
            this.adjustItemVertical();
        }
    }

    public final int getSuggestedMinHeight() {
        return this.getSuggestedMinimumHeight();
    }

    public final float getSelectedTextScale() {
        return this.mSelectedTextScale;
    }

    public final void setSelectedTextScale(float mSelectedTextScale) {
        this.mSelectedTextScale = mSelectedTextScale;
    }

    public final void setTextSize(@DimenRes int mTextSizeRes) {
        this.mTextSize = (int)this.getContext().getResources().getDimension(mTextSizeRes);
    }

    public final void setOnUpListener(@NotNull Function0<Unit> touchUpListener) {
        Intrinsics.checkNotNullParameter(touchUpListener, (String)"touchUpListener");
        this.touchUpListener = touchUpListener;
    }

    public final void setOnDownListener(@NotNull Function0<Unit> touchDownListener) {
        Intrinsics.checkNotNullParameter(touchDownListener, (String)"touchDownListener");
        this.touchDownListener = touchDownListener;
    }

    public final void scrollTo(int position) {
        if (this.mCurSelectedItemIndex == position) {
            return;
        }
        this.mCurSelectedItemIndex = position;
        this.mSelectorItemIndices.clear();
        int n = 0;
        int n2 = this.mSelectorItemCount;
        if (n < n2) {
            do {
                int i = n++;
                int selectorIndex = this.mCurSelectedItemIndex + (i - this.mWheelMiddleItemIndex);
                if (this.mWrapSelectorWheelPreferred) {
                    selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
                }
                this.mSelectorItemIndices.add(selectorIndex);
            } while (n < n2);
        }
        this.invalidate();
    }

    public final void setOnValueChangedListener(@NotNull OnValueChangeListener onValueChangeListener) {
        Intrinsics.checkNotNullParameter((Object)onValueChangeListener, (String)"onValueChangeListener");
        this.mOnValueChangeListener = onValueChangeListener;
    }

    public final void smoothScrollTo(int position) {
        int realPosition = this.validatePosition(position);
        this.changeValueBySteps(realPosition - this.mCurSelectedItemIndex);
    }

    public final void smoothScrollToValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.smoothScrollTo(this.getPosition(value));
    }

    public final void scrollToValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.scrollTo(this.getPosition(value));
    }

    public final void setUnselectedTextColor(@ColorRes int colorId) {
        this.mUnSelectedTextColor = ContextCompat.getColor((Context)this.getContext(), (int)colorId);
        this.invalidate();
    }

    public final void setAdapter(@Nullable WheelAdapter adapter, boolean indexRangeBasedOnAdapterSize) {
        this.mAdapter = adapter;
        if (this.mAdapter == null) {
            this.initializeSelectorWheelIndices();
            this.invalidate();
            return;
        }
        WheelAdapter wheelAdapter = adapter;
        Intrinsics.checkNotNull((Object)wheelAdapter);
        if (wheelAdapter.getSize() != -1 && indexRangeBasedOnAdapterSize) {
            this.mMaxIndex = adapter.getSize() - 1;
            this.mMinIndex = 0;
        }
        this.mMaxValidIndex = adapter.getMaxValidIndex();
        this.mMinValidIndex = adapter.getMinValidIndex();
        this.initializeSelectorWheelIndices();
        this.invalidate();
        WheelAdapter wheelAdapter2 = this.mAdapter;
        if (wheelAdapter2 != null) {
            wheelAdapter2.setPicker(this);
        }
    }

    public static /* synthetic */ void setAdapter$default(WheelPicker wheelPicker, WheelAdapter wheelAdapter, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        wheelPicker.setAdapter(wheelAdapter, bl);
    }

    public final void setWrapSelectorWheel(boolean wrap) {
        this.mWrapSelectorWheelPreferred = wrap;
        this.invalidate();
    }

    public final boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheelPreferred;
    }

    public final void setWheelItemCount(int count) {
        this.mSelectorItemCount = count + 2;
        this.mWheelMiddleItemIndex = (this.mSelectorItemCount - 1) / 2;
        this.mSelectorVisibleItemCount = this.mSelectorItemCount - 2;
        this.mWheelVisibleItemMiddleIndex = (this.mSelectorVisibleItemCount - 1) / 2;
        this.mSelectorItemIndices = new ArrayList(this.mSelectorItemCount);
        this.mSelectorItemValidStatus = new ArrayList(this.mSelectorItemCount);
        this.reset();
        this.invalidate();
    }

    public final void setSelectedTextColor(@ColorRes int colorId) {
        this.mSelectedTextColor = ContextCompat.getColor((Context)this.getContext(), (int)colorId);
        this.invalidate();
    }

    @NotNull
    public final String getValue(int position) {
        String string;
        if (this.mAdapter != null) {
            WheelAdapter wheelAdapter = this.mAdapter;
            Intrinsics.checkNotNull((Object)wheelAdapter);
            string = wheelAdapter.getValue(position);
        } else {
            string = !this.mWrapSelectorWheelPreferred ? (position > this.mMaxIndex ? "" : (position < this.mMinIndex ? "" : String.valueOf(position))) : String.valueOf(this.getWrappedSelectorIndex(position));
        }
        return string;
    }

    public final void setValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.scrollToValue(value);
    }

    public final void setMaxValue(int max) {
        this.mMaxIndex = max;
    }

    @NotNull
    public final String getMaxValue() {
        String string;
        if (this.mAdapter != null) {
            WheelAdapter wheelAdapter = this.mAdapter;
            Intrinsics.checkNotNull((Object)wheelAdapter);
            string = wheelAdapter.getValue(this.mMaxIndex);
        } else {
            string = String.valueOf(this.mMaxIndex);
        }
        return string;
    }

    public final void setMinValue(int min) {
        this.mMinIndex = min;
    }

    public final void setMinValidValue(@Nullable Integer minValid) {
        this.mMinValidIndex = minValid;
    }

    public final void setMaxValidValue(@Nullable Integer maxValid) {
        this.mMaxValidIndex = maxValid;
    }

    @NotNull
    public final String getMinValue() {
        String string;
        if (this.mAdapter != null) {
            WheelAdapter wheelAdapter = this.mAdapter;
            Intrinsics.checkNotNull((Object)wheelAdapter);
            string = wheelAdapter.getValue(this.mMinIndex);
        } else {
            string = String.valueOf(this.mMinIndex);
        }
        return string;
    }

    public final void reset() {
        this.initializeSelectorWheelIndices();
        this.initializeSelectorWheel();
        this.invalidate();
    }

    @NotNull
    public final String getCurrentItem() {
        return this.getValue(this.mCurSelectedItemIndex);
    }

    public final int getCurrentIndex() {
        return this.mCurSelectedItemIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidPosition(int position) {
        if (this.mMinValidIndex != null) {
            Integer n = this.mMinValidIndex;
            Intrinsics.checkNotNull((Object)n);
            if (position < n) {
                return false;
            }
        }
        if (this.mMaxValidIndex == null) return true;
        Integer n = this.mMaxValidIndex;
        Intrinsics.checkNotNull((Object)n);
        if (position <= n) return true;
        return false;
    }

    private final void adjustItemVertical() {
        this.mPreviousScrollerY = 0;
        int deltaY = this.mInitialFirstItemOffset - this.mCurrentFirstItemOffset;
        boolean bl = false;
        if (Math.abs(deltaY) > this.mItemHeight / 2) {
            deltaY += deltaY > 0 ? -this.mItemHeight : this.mItemHeight;
        }
        if (deltaY != 0) {
            OverScroller overScroller = this.mOverScroller;
            Intrinsics.checkNotNull((Object)overScroller);
            overScroller.startScroll(this.getScrollX(), this.getScrollY(), 0, deltaY, 800);
            this.postInvalidateOnAnimation();
        }
    }

    private final void recyclerVelocityTracker() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
        }
        this.mVelocityTracker = null;
    }

    private final int getItemHeight() {
        return this.getHeight() / (this.mSelectorItemCount - 2);
    }

    private final int getGapHeight() {
        return this.getItemHeight() - this.computeTextHeight();
    }

    private final int computeTextHeight() {
        Paint.FontMetricsInt metricsInt = this.mTextPaint.getFontMetricsInt();
        int n = metricsInt.bottom + metricsInt.top;
        boolean bl = false;
        return Math.abs(n);
    }

    private final void drawVertical(Canvas canvas) {
        float f;
        if (this.mSelectorItemIndices.size() == 0) {
            return;
        }
        int itemHeight = this.getItemHeight();
        Paint.Align align = this.mTextPaint.getTextAlign();
        int n = align == null ? -1 : WhenMappings.$EnumSwitchMapping$0[align.ordinal()];
        switch (n) {
            case 1: {
                f = this.getPaddingLeft();
                break;
            }
            case 2: {
                f = (this.getRight() - this.getLeft()) / 2;
                break;
            }
            case 3: {
                f = (float)(this.getRight() - this.getLeft()) - (float)this.getPaddingRight();
                break;
            }
            default: {
                f = (this.getRight() - this.getLeft()) / 2;
            }
        }
        float x = f;
        float y = this.mCurrentFirstItemOffset;
        int i = 0;
        int topIndexDiffToMid = this.mWheelVisibleItemMiddleIndex;
        int bottomIndexDiffToMid = this.mSelectorVisibleItemCount - this.mWheelVisibleItemMiddleIndex - 1;
        int maxIndexDiffToMid = RangesKt.coerceAtLeast((int)topIndexDiffToMid, (int)bottomIndexDiffToMid);
        while (i < this.mSelectorItemIndices.size()) {
            float f2;
            float scale = 0.0f;
            float f3 = y - (float)(this.mInitialFirstItemOffset + this.mWheelMiddleItemIndex * itemHeight);
            boolean bl = false;
            float offsetToMiddle = Math.abs(f3);
            f3 = (float)(itemHeight * maxIndexDiffToMid) - offsetToMiddle;
            bl = false;
            if (Math.abs(f3) == 100.0f) {
                f2 = this.mSelectedTextScale * ((float)itemHeight / 1.01f * (float)maxIndexDiffToMid - offsetToMiddle) / (float)(itemHeight * maxIndexDiffToMid) + 1.0f;
            } else {
                f3 = (float)(itemHeight * maxIndexDiffToMid) - offsetToMiddle;
                bl = false;
                f2 = this.mSelectedTextScale * ((float)itemHeight / (((float)100 + Math.abs(f3) / 100.0f) / (float)100) * (float)maxIndexDiffToMid - offsetToMiddle) / (float)(itemHeight * maxIndexDiffToMid) + 1.0f;
            }
            scale = f2;
            scale /= 1.5f;
            Comparable<Boolean> comparable = this.mSelectorItemValidStatus.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"mSelectorItemValidStatus[i]");
            if (comparable.booleanValue()) {
                if (offsetToMiddle < (float)(this.mItemHeight / 2)) {
                    this.mTextPaint.setColor(this.mSelectedTextColor);
                } else {
                    this.mTextPaint.setColor(this.mUnSelectedTextColor);
                }
            } else {
                this.mTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_color_time_picker_selected));
            }
            canvas.save();
            canvas.scale(scale, scale, x, y);
            comparable = this.mSelectorItemIndices.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"mSelectorItemIndices[i]");
            canvas.drawText(this.getValue(((Number)((Object)comparable)).intValue()), x, y, this.mTextPaint);
            canvas.restore();
            y += (float)itemHeight;
            int n2 = i;
            i = n2 + 1;
        }
    }

    private final int getPosition(String value) {
        int n;
        if (this.mAdapter != null) {
            WheelAdapter wheelAdapter = this.mAdapter;
            Intrinsics.checkNotNull((Object)wheelAdapter);
            n = this.validatePosition(wheelAdapter.getPosition(value));
        } else {
            int n2;
            try {
                String string = value;
                boolean bl = false;
                int position = Integer.parseInt(string);
                n2 = this.validatePosition(position);
            }
            catch (NumberFormatException e) {
                n2 = 0;
            }
            n = n2;
        }
        return n;
    }

    private final void increaseSelectorsIndex() {
        int n = 0;
        int n2 = this.mSelectorItemIndices.size() - 1;
        if (n < n2) {
            do {
                int i = n++;
                this.mSelectorItemIndices.set(i, this.mSelectorItemIndices.get(i + 1));
                this.mSelectorItemValidStatus.set(i, this.mSelectorItemValidStatus.get(i + 1));
            } while (n < n2);
        }
        int nextScrollSelectorIndex = ((Number)this.mSelectorItemIndices.get(this.mSelectorItemIndices.size() - 2)).intValue() + 1;
        if (this.mWrapSelectorWheelPreferred && nextScrollSelectorIndex > this.mMaxIndex) {
            nextScrollSelectorIndex = this.mMinIndex;
        }
        this.mSelectorItemIndices.set(this.mSelectorItemIndices.size() - 1, nextScrollSelectorIndex);
        this.mSelectorItemValidStatus.set(this.mSelectorItemIndices.size() - 1, this.isValidPosition(nextScrollSelectorIndex));
    }

    private final void decreaseSelectorsIndex() {
        int n = this.mSelectorItemIndices.size() - 1;
        if (1 <= n) {
            do {
                int i = n--;
                this.mSelectorItemIndices.set(i, this.mSelectorItemIndices.get(i - 1));
                this.mSelectorItemValidStatus.set(i, this.mSelectorItemValidStatus.get(i - 1));
            } while (1 <= n);
        }
        int nextScrollSelectorIndex = ((Number)this.mSelectorItemIndices.get(1)).intValue() - 1;
        if (this.mWrapSelectorWheelPreferred && nextScrollSelectorIndex < this.mMinIndex) {
            nextScrollSelectorIndex = this.mMaxIndex;
        }
        this.mSelectorItemIndices.set(0, nextScrollSelectorIndex);
        this.mSelectorItemValidStatus.set(0, this.isValidPosition(nextScrollSelectorIndex));
    }

    private final void changeValueBySteps(int steps) {
        this.mPreviousScrollerY = 0;
        OverScroller overScroller = this.mOverScroller;
        Intrinsics.checkNotNull((Object)overScroller);
        overScroller.startScroll(0, 0, 0, -this.mItemHeight * steps, 300);
        this.invalidate();
    }

    private final void onSelectionChanged(int current) {
        int previous = this.mCurSelectedItemIndex;
        this.mCurSelectedItemIndex = current;
        if (previous != current) {
            this.notifyChange(previous, current);
        }
    }

    private final int getWrappedSelectorIndex(int selectorIndex) {
        return selectorIndex > this.mMaxIndex ? this.mMinIndex + (selectorIndex - this.mMaxIndex) % (this.mMaxIndex - this.mMinIndex + 1) - 1 : (selectorIndex < this.mMinIndex ? this.mMaxIndex - (this.mMinIndex - selectorIndex) % (this.mMaxIndex - this.mMinIndex + 1) + 1 : selectorIndex);
    }

    private final Unit notifyChange(int previous, int current) {
        Unit unit;
        OnValueChangeListener onValueChangeListener = this.mOnValueChangeListener;
        if (onValueChangeListener == null) {
            unit = null;
        } else {
            onValueChangeListener.onValueChange(this, this.getValue(previous), this.getValue(current));
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int validatePosition(int position) {
        int n;
        if (this.mWrapSelectorWheelPreferred) {
            n = this.getWrappedSelectorIndex(position);
            return n;
        }
        if (this.mMaxValidIndex == null && position > this.mMaxIndex) {
            n = this.mMaxIndex;
            return n;
        }
        if (this.mMaxValidIndex != null) {
            Integer n2 = this.mMaxValidIndex;
            Intrinsics.checkNotNull((Object)n2);
            if (position > n2) {
                Integer n3 = this.mMaxValidIndex;
                Intrinsics.checkNotNull((Object)n3);
                n = n3;
                return n;
            }
        }
        if (this.mMinValidIndex == null && position < this.mMinIndex) {
            n = this.mMinIndex;
            return n;
        }
        if (this.mMinValidIndex != null) {
            Integer n4 = this.mMinValidIndex;
            Intrinsics.checkNotNull((Object)n4);
            if (position < n4) {
                Integer n5 = this.mMinValidIndex;
                Intrinsics.checkNotNull((Object)n5);
                n = n5;
                return n;
            }
        }
        n = position;
        return n;
    }

    private final void onTouchEventVertical(MotionEvent event) {
        VelocityTracker velocityTracker;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        if ((velocityTracker = this.mVelocityTracker) != null) {
            velocityTracker.addMovement(event);
        }
        int n = event.getActionMasked();
        switch (n) {
            case 0: {
                if (this.touchDownListener != null) {
                    Function0<Unit> function0;
                    Function0<Unit> function02 = this.touchDownListener;
                    if (function02 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"touchDownListener");
                        function0 = null;
                    } else {
                        function0 = function02;
                    }
                    function0.invoke();
                }
                OverScroller overScroller = this.mOverScroller;
                Intrinsics.checkNotNull((Object)overScroller);
                if (!overScroller.isFinished()) {
                    OverScroller overScroller2 = this.mOverScroller;
                    Intrinsics.checkNotNull((Object)overScroller2);
                    overScroller2.forceFinished(true);
                }
                this.mLastY = event.getY();
                break;
            }
            case 2: {
                float deltaY = event.getY() - this.mLastY;
                if (!this.mIsDragging) {
                    boolean bl = false;
                    if (Math.abs(deltaY) > (float)this.mTouchSlop) {
                        ViewParent viewParent = this.getParent();
                        if (viewParent != null) {
                            viewParent.requestDisallowInterceptTouchEvent(true);
                        }
                        deltaY = deltaY > 0.0f ? (deltaY -= (float)this.mTouchSlop) : (deltaY += (float)this.mTouchSlop);
                        this.mIsDragging = true;
                    }
                }
                if (!this.mIsDragging) break;
                this.scrollBy(0, (int)deltaY);
                this.invalidate();
                this.mLastY = event.getY();
                break;
            }
            case 1: {
                ViewParent deltaY;
                if (this.touchUpListener != null) {
                    ViewParent viewParent;
                    deltaY = this.touchUpListener;
                    if (deltaY == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"touchUpListener");
                        viewParent = null;
                    } else {
                        viewParent = deltaY;
                    }
                    viewParent.invoke();
                }
                if (this.mIsDragging) {
                    int n2;
                    this.mIsDragging = false;
                    deltaY = this.getParent();
                    if (deltaY != null) {
                        deltaY.requestDisallowInterceptTouchEvent(false);
                    }
                    deltaY = this.mVelocityTracker;
                    if (deltaY != null) {
                        deltaY.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    }
                    VelocityTracker velocityTracker2 = this.mVelocityTracker;
                    if (velocityTracker2 == null) {
                        n2 = 0;
                    } else {
                        int n3;
                        float f = velocityTracker2.getYVelocity();
                        n2 = n3 = (int)f;
                    }
                    int velocity = n2;
                    this.mPreviousScrollerY = 0;
                    velocityTracker2 = this.mOverScroller;
                    if (velocityTracker2 != null) {
                        velocityTracker2.fling(this.getScrollX(), this.getScrollY(), 0, velocity, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, (int)((double)this.getItemHeight() * 0.7));
                    }
                    this.postInvalidateOnAnimation();
                    this.recyclerVelocityTracker();
                    break;
                }
                int y = (int)event.getY();
                this.handlerClickVertical(y);
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.mIsDragging = false;
                }
                this.recyclerVelocityTracker();
            }
        }
    }

    private final void handlerClickVertical(int y) {
        int selectorIndexOffset = y / this.mItemHeight - this.mWheelVisibleItemMiddleIndex;
        this.changeValueBySteps(selectorIndexOffset);
    }

    private final int computeMaximumWidth() {
        this.mTextPaint.setTextSize((float)this.mTextSize * 1.3f);
        if (this.mAdapter != null) {
            int n;
            WheelAdapter wheelAdapter = this.mAdapter;
            Intrinsics.checkNotNull((Object)wheelAdapter);
            CharSequence charSequence = wheelAdapter.getTextWithMaximumLength();
            boolean bl = false;
            if (charSequence.length() > 0) {
                WheelAdapter wheelAdapter2 = this.mAdapter;
                Intrinsics.checkNotNull((Object)wheelAdapter2);
                int suggestedWith = (int)this.mTextPaint.measureText(wheelAdapter2.getTextWithMaximumLength());
                this.mTextPaint.setTextSize((float)this.mTextSize);
                n = suggestedWith;
            } else {
                int suggestedWith = (int)this.mTextPaint.measureText("00");
                this.mTextPaint.setTextSize((float)this.mTextSize);
                n = suggestedWith;
            }
            return n;
        }
        int widthForMinIndex = (int)this.mTextPaint.measureText(String.valueOf(this.mMinIndex));
        int widthForMaxIndex = (int)this.mTextPaint.measureText(String.valueOf(this.mMaxIndex));
        this.mTextPaint.setTextSize((float)this.mTextSize * 1.0f);
        return widthForMinIndex > widthForMaxIndex ? widthForMinIndex : widthForMaxIndex;
    }

    private final int calculateSize(int suggestedSize, int paramSize, int measureSpec) {
        int result = 0;
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int n = View.MeasureSpec.getMode((int)mode);
        switch (n) {
            case -2147483648: {
                int n2;
                int n3 = paramSize;
                switch (n3) {
                    case -2: {
                        n2 = RangesKt.coerceAtMost((int)suggestedSize, (int)size);
                        break;
                    }
                    case -1: {
                        n2 = size;
                        break;
                    }
                    default: {
                        n2 = RangesKt.coerceAtMost((int)paramSize, (int)size);
                    }
                }
                result = n2;
                break;
            }
            case 0x40000000: {
                result = size;
                break;
            }
            case 0: {
                int n4;
                switch (paramSize) {
                    case -2: 
                    case -1: {
                        n4 = suggestedSize;
                        break;
                    }
                    default: {
                        n4 = paramSize;
                    }
                }
                result = n4;
            }
        }
        return result;
    }

    private final void initializeSelectorWheel() {
        this.mItemHeight = this.getItemHeight();
        this.mTextHeight = this.computeTextHeight();
        this.mTextGapHeight = this.getGapHeight();
        int visibleMiddleItemPos = this.mItemHeight * this.mWheelVisibleItemMiddleIndex + (this.mItemHeight + this.mTextHeight) / 2;
        this.mCurrentFirstItemOffset = this.mInitialFirstItemOffset = visibleMiddleItemPos - this.mItemHeight * this.mWheelMiddleItemIndex;
    }

    private final void initializeFadingEdges() {
        this.setVerticalFadingEdgeEnabled(this.mFadingEdgeEnabled);
        if (this.mFadingEdgeEnabled) {
            this.setFadingEdgeLength((this.getBottom() - this.getTop() - this.mTextSize) / 2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void initializeSelectorWheelIndices() {
        this.mSelectorItemIndices.clear();
        this.mSelectorItemValidStatus.clear();
        if (this.mMinValidIndex == null) ** GOTO lbl-1000
        v0 = this.mMinValidIndex;
        Intrinsics.checkNotNull((Object)v0);
        if (v0 < this.mMinIndex) lbl-1000:
        // 2 sources

        {
            v1 = this.mMinIndex <= 0 ? 0 : this.mMinIndex;
        } else {
            v2 = this.mMinValidIndex;
            Intrinsics.checkNotNull((Object)v2);
            if (v2 <= 0) {
                v1 = 0;
            } else {
                v3 = this.mMinValidIndex;
                Intrinsics.checkNotNull((Object)v3);
                v1 = v3;
            }
        }
        this.mCurSelectedItemIndex = v1;
        var1_1 = 0;
        var2_2 = this.mSelectorItemCount;
        if (var1_1 < var2_2) {
            do {
                i = var1_1++;
                selectorIndex = this.mCurSelectedItemIndex + (i - this.mWheelMiddleItemIndex);
                if (this.mWrapSelectorWheelPreferred) {
                    selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
                }
                this.mSelectorItemIndices.add(selectorIndex);
                this.mSelectorItemValidStatus.add(this.isValidPosition(selectorIndex));
            } while (var1_1 < var2_2);
        }
    }

    @JvmOverloads
    public WheelPicker(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public WheelPicker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lstudio/clapp/wheelpicker/WheelPicker$TextAlign;", "", "(Ljava/lang/String;I)V", "LEFT", "CENTER", "RIGHT", "wheelpicker_release"})
    private static final class TextAlign
    extends Enum<TextAlign> {
        public static final /* enum */ TextAlign LEFT = new TextAlign();
        public static final /* enum */ TextAlign CENTER = new TextAlign();
        public static final /* enum */ TextAlign RIGHT = new TextAlign();
        private static final /* synthetic */ TextAlign[] $VALUES;

        public static TextAlign[] values() {
            return (TextAlign[])$VALUES.clone();
        }

        public static TextAlign valueOf(String value) {
            return Enum.valueOf(TextAlign.class, value);
        }

        static {
            $VALUES = textAlignArray = new TextAlign[]{TextAlign.LEFT, TextAlign.CENTER, TextAlign.RIGHT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lstudio/clapp/wheelpicker/WheelPicker$Companion;", "", "()V", "DEFAULT_ITEM_COUNT", "", "DEFAULT_TEXT_SIZE", "SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT", "SNAP_SCROLL_DURATION", "TOP_AND_BOTTOM_FADING_EDGE_STRENGTH", "", "wheelpicker_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Paint.Align.values().length];
            nArray[Paint.Align.LEFT.ordinal()] = 1;
            nArray[Paint.Align.CENTER.ordinal()] = 2;
            nArray[Paint.Align.RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

