/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.cluster.Broker;
import kafka.cluster.Cluster;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZkUtils$
implements ScalaObject {
    public static final ZkUtils$ MODULE$;
    private final String consumersPath;
    private final String brokerIdsPath;
    private final String brokerTopicsPath;
    private final Logger logger;

    static {
        new ZkUtils$();
    }

    public String consumersPath() {
        return this.consumersPath;
    }

    public String brokerIdsPath() {
        return this.brokerIdsPath;
    }

    public String brokerTopicsPath() {
        return this.brokerTopicsPath;
    }

    private Logger logger() {
        return this.logger;
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.createEphemeral(path, (Object)data);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path, String data) {
        String storedData;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path, data);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData = null;
                try {
                    storedData = this.readData(client, path);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if (storedData == null) break block6;
                String string = storedData;
                String string2 = data;
                if (string != null ? !string.equals(string2) : string2 != null) break block6;
                this.logger().info((Object)new StringBuilder().append((Object)path).append((Object)" exists with value ").append((Object)data).append((Object)" during connection loss; this is ok").toString());
            }
            return;
        }
        this.logger().info((Object)new StringBuilder().append((Object)"conflict in ").append((Object)path).append((Object)" data: ").append((Object)data).append((Object)" stored data: ").append((Object)storedData).toString());
        throw zkNodeExistsException2;
    }

    public void updatePersistentPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, (Object)data);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, (Object)data);
            }
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    public void deletePath(ZkClient client, String path) {
        try {
            client.delete(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.logger().info((Object)new StringBuilder().append((Object)path).append((Object)" deleted during connection loss; this is ok").toString());
        }
    }

    public void deletePathRecursive(ZkClient client, String path) {
        try {
            client.deleteRecursive(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.logger().info((Object)new StringBuilder().append((Object)path).append((Object)" deleted during connection loss; this is ok").toString());
        }
    }

    public String readData(ZkClient client, String path) {
        return (String)client.readData(path);
    }

    public String readDataMaybeNull(ZkClient client, String path) {
        return (String)client.readData(path, true);
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        java.util.List ret = null;
        try {
            ret = client.getChildren(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
        return JavaConversions$.MODULE$.asBuffer(ret);
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    public String getLastPart(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$1) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$1, this.brokerIdsPath());
        nodes.foreach((Function1)new anonfun.getCluster.1(zkClient$1, cluster$1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<String>> getPartitionsForTopics(ZkClient zkClient$2, Iterator<String> topics) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topics.foreach((Function1)new anonfun.getPartitionsForTopics.1(zkClient$2, ret$1));
        return var3_3;
    }

    public void setupPartition(ZkClient zkClient, int brokerId, String host, int port, String topic, int nParts) {
        String brokerIdPath = new StringBuilder().append((Object)this.brokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        Broker broker = new Broker(brokerId, ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString(), host, port);
        this.createEphemeralPathExpectConflict(zkClient, brokerIdPath, broker.getZKString());
        String brokerPartTopicPath = new StringBuilder().append((Object)this.brokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        this.createEphemeralPathExpectConflict(zkClient, brokerPartTopicPath, ((Object)BoxesRunTime.boxToInteger((int)nParts)).toString());
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.brokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.brokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.consumersPath = "/consumers";
        this.brokerIdsPath = "/brokers/ids";
        this.brokerTopicsPath = "/brokers/topics";
        this.logger = Logger.getLogger(this.getClass());
    }
}

