/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.utils.SnapshotStats$;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001bMs\u0017\r]:i_R\u001cF/\u0019;t\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0011!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"aC*dC2\fwJ\u00196fGRD\u0001b\u0006\u0001\u0003\u0006\u0004%I\u0001G\u0001\u0012[>t\u0017\u000e^8s\tV\u0014\u0018\r^5p]:\u001bX#A\r\u0011\u0005EQ\u0012BA\u000e\u0013\u0005\u0011auN\\4\t\u0011u\u0001!\u0011!Q\u0001\ne\t!#\\8oSR|'\u000fR;sCRLwN\u001c(tA!)q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!I\u0012\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000f]q\u0002\u0013!a\u00013!9Q\u0005\u0001b\u0001\n\u00131\u0013\u0001\u0002;j[\u0016,\u0012a\n\t\u0003E!J!!\u000b\u0002\u0003\tQKW.\u001a\u0005\u0007W\u0001\u0001\u000b\u0011B\u0014\u0002\u000bQLW.\u001a\u0011\t\u000f5\u0002!\u0019!C\u0005]\u0005A1m\\7qY\u0016$X-F\u00010!\r\u0001t'O\u0007\u0002c)\u0011!gM\u0001\u0007CR|W.[2\u000b\u0005Q*\u0014AC2p]\u000e,(O]3oi*\u0011a\u0007D\u0001\u0005kRLG.\u0003\u00029c\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002;w5\t\u0001A\u0002\u0005=\u0001\u0011\u0005\t\u0011!\u0001>\u0005\u0015\u0019F/\u0019;t'\rY\u0004\u0002\u0005\u0005\u0006?m\"\ta\u0010\u000b\u0002s!9\u0011i\u000fb\u0001\n\u0003A\u0012!B:uCJ$\bBB\"<A\u0003%\u0011$\u0001\u0004ti\u0006\u0014H\u000f\t\u0005\b\u000bn\u0002\r\u0011\"\u0001G\u0003\r)g\u000eZ\u000b\u0002\u000fB\u0011\u0001\u0007S\u0005\u0003\u0013F\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u001dY5\b1A\u0005\u00021\u000bq!\u001a8e?\u0012*\u0017\u000f\u0006\u0002N!B\u0011\u0011CT\u0005\u0003\u001fJ\u0011A!\u00168ji\"9\u0011KSA\u0001\u0002\u00049\u0015a\u0001=%c!11k\u000fQ!\n\u001d\u000bA!\u001a8eA!9Qk\u000fa\u0001\n\u00031\u0016a\u00038v[J+\u0017/^3tiN,\u0012a\u0016\t\u0003#aK!!\u0017\n\u0003\u0007%sG\u000fC\u0004\\w\u0001\u0007I\u0011\u0001/\u0002\u001f9,XNU3rk\u0016\u001cHo]0%KF$\"!T/\t\u000fES\u0016\u0011!a\u0001/\"1ql\u000fQ!\n]\u000bAB\\;n%\u0016\fX/Z:ug\u0002Bq!Y\u001eA\u0002\u0013\u0005\u0001$\u0001\nu_R\fGNU3rk\u0016\u001cH/T3ue&\u001c\u0007bB2<\u0001\u0004%\t\u0001Z\u0001\u0017i>$\u0018\r\u001c*fcV,7\u000f^'fiJL7m\u0018\u0013fcR\u0011Q*\u001a\u0005\b#\n\f\t\u00111\u0001\u001a\u0011\u001997\b)Q\u00053\u0005\u0019Bo\u001c;bYJ+\u0017/^3ti6+GO]5dA!9\u0011n\u000fa\u0001\n\u0003A\u0012\u0001E7bqJ+\u0017/^3ti6+GO]5d\u0011\u001dY7\b1A\u0005\u00021\fA#\\1y%\u0016\fX/Z:u\u001b\u0016$(/[2`I\u0015\fHCA'n\u0011\u001d\t&.!AA\u0002eAaa\\\u001e!B\u0013I\u0012!E7bqJ+\u0017/^3ti6+GO]5dA!9\u0011o\u000fa\u0001\n\u0003A\u0012!\u0003;pi\u0006dG)\u0019;b\u0011\u001d\u00198\b1A\u0005\u0002Q\fQ\u0002^8uC2$\u0015\r^1`I\u0015\fHCA'v\u0011\u001d\t&/!AA\u0002eAaa^\u001e!B\u0013I\u0012A\u0003;pi\u0006dG)\u0019;bA!9\u0011p\u000fb\u0001\n\u0013Q\u0018\u0001\u00027pG.,\u0012\u0001\u0003\u0005\u0007yn\u0002\u000b\u0011\u0002\u0005\u0002\u000b1|7m\u001b\u0011\t\u000by\\D\u0011A@\u0002\u000f\u0005$G\rR1uCR\u0019Q*!\u0001\t\r\u0005\rQ\u00101\u0001\u001a\u0003\u0011!\u0017\r^1\t\u000f\u0005\u001d1\b\"\u0001\u0002\n\u0005\u0019\u0011\r\u001a3\u0015\u00075\u000bY\u0001C\u0004\u0002\u000e\u0005\u0015\u0001\u0019A\r\u0002\u0013I,\u0017/^3ti:\u001b\bbBA\tw\u0011\u0005\u00111C\u0001\u0010IV\u0014\u0018\r^5p]N+7m\u001c8egV\u0011\u0011Q\u0003\t\u0004#\u0005]\u0011bAA\r%\t1Ai\\;cY\u0016Dq!!\b<\t\u0003\t\u0019\"\u0001\u0006ekJ\fG/[8o\u001bNDq!!\t\u0001A\u0003%q&A\u0005d_6\u0004H.\u001a;fA!A\u0011Q\u0005\u0001C\u0002\u0013%a&A\u0004dkJ\u0014XM\u001c;\t\u000f\u0005%\u0002\u0001)A\u0005_\u0005A1-\u001e:sK:$\b\u0005\u0003\u0005\u0002.\u0001\u0011\r\u0011\"\u0003G\u0003QqW/\\\"v[Vd\u0017\r^3e%\u0016\fX/Z:ug\"9\u0011\u0011\u0007\u0001!\u0002\u00139\u0015!\u00068v[\u000e+X.\u001e7bi\u0016$'+Z9vKN$8\u000f\t\u0005\b\u0003k\u0001A\u0011AA\u001c\u0003M\u0011XmY8sIJ+\u0017/^3ti6+GO]5d)\ri\u0015\u0011\b\u0005\b\u0003\u001b\t\u0019\u00041\u0001\u001a\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\taC]3d_J$G\u000b\u001b:pk\u001eD\u0007/\u001e;NKR\u0014\u0018n\u0019\u000b\u0004\u001b\u0006\u0005\u0003bBA\u0002\u0003w\u0001\r!\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u000399W\r\u001e(v[J+\u0017/^3tiN$\u0012!\u0007\u0005\b\u0003\u0017\u0002A\u0011AA\n\u0003Q9W\r\u001e*fcV,7\u000f^:QKJ\u001cVmY8oI\"9\u0011q\n\u0001\u0005\u0002\u0005M\u0011!D4fiRC'o\\;hQB,H\u000fC\u0004\u0002T\u0001!\t!a\u0005\u0002\u0019\u001d,G/\u0011<h\u001b\u0016$(/[2\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\u0014\u0005aq-\u001a;NCblU\r\u001e:jG\u001eI\u00111\f\u0002\u0002\u0002#\u0015\u0011QL\u0001\u000e':\f\u0007o\u001d5piN#\u0018\r^:\u0011\u0007\t\nyFB\u0005\u0002\u0005\u0011\r\t\u0011#\u0002\u0002bM!\u0011q\f\u0005\u0011\u0011\u001dy\u0012q\fC\u0001\u0003K\"\"!!\u0018\t\u0015\u0005%\u0014qLI\u0001\n\u0003\tY'\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055$fA\r\u0002p-\u0012\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003%)hn\u00195fG.,GMC\u0002\u0002|I\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class SnapshotStats
implements ScalaObject {
    private final long monitorDurationNs;
    private final Time kafka$utils$SnapshotStats$$time;
    private final AtomicReference<Stats> complete;
    private final AtomicReference<Stats> current;
    private final AtomicLong numCumulatedRequests;

    public static final long init$default$1() {
        return SnapshotStats$.MODULE$.init$default$1();
    }

    private long monitorDurationNs() {
        return this.monitorDurationNs;
    }

    public final Time kafka$utils$SnapshotStats$$time() {
        return this.kafka$utils$SnapshotStats$$time;
    }

    private AtomicReference<Stats> complete() {
        return this.complete;
    }

    private AtomicReference<Stats> current() {
        return this.current;
    }

    private AtomicLong numCumulatedRequests() {
        return this.numCumulatedRequests;
    }

    public void recordRequestMetric(long requestNs) {
        boolean swapped;
        Stats stats = this.current().get();
        stats.add(requestNs);
        this.numCumulatedRequests().getAndAdd(1L);
        long ageNs = this.kafka$utils$SnapshotStats$$time().nanoseconds() - stats.start();
        if (ageNs >= this.monitorDurationNs() && (swapped = this.current().compareAndSet(stats, new Stats()))) {
            this.complete().set(stats);
            stats.end().set(this.kafka$utils$SnapshotStats$$time().nanoseconds());
        }
    }

    public void recordThroughputMetric(long data) {
        boolean swapped;
        Stats stats = this.current().get();
        stats.addData(data);
        long ageNs = this.kafka$utils$SnapshotStats$$time().nanoseconds() - stats.start();
        if (ageNs >= this.monitorDurationNs() && (swapped = this.current().compareAndSet(stats, new Stats()))) {
            this.complete().set(stats);
            stats.end().set(this.kafka$utils$SnapshotStats$$time().nanoseconds());
        }
    }

    public long getNumRequests() {
        return this.numCumulatedRequests().get();
    }

    public double getRequestsPerSecond() {
        Stats stats = this.complete().get();
        return (double)stats.numRequests() / stats.durationSeconds();
    }

    public double getThroughput() {
        Stats stats = this.complete().get();
        return (double)stats.totalData() / stats.durationSeconds();
    }

    public double getAvgMetric() {
        Stats stats = this.complete().get();
        return stats.numRequests() == 0 ? 0.0 : (double)(stats.totalRequestMetric() / (long)stats.numRequests());
    }

    public double getMaxMetric() {
        return this.complete().get().maxRequestMetric();
    }

    public SnapshotStats(long monitorDurationNs) {
        this.monitorDurationNs = monitorDurationNs;
        this.kafka$utils$SnapshotStats$$time = SystemTime$.MODULE$;
        this.complete = new AtomicReference<Stats>(new Stats());
        this.current = new AtomicReference<Stats>(new Stats());
        this.numCumulatedRequests = new AtomicLong(0L);
    }

    public class Stats
    implements ScalaObject {
        private final long start;
        private AtomicLong end;
        private int numRequests;
        private long totalRequestMetric;
        private long maxRequestMetric;
        private long totalData;
        private final Object lock;

        public long start() {
            return this.start;
        }

        public AtomicLong end() {
            return this.end;
        }

        public void end_$eq(AtomicLong atomicLong) {
            this.end = atomicLong;
        }

        public int numRequests() {
            return this.numRequests;
        }

        public void numRequests_$eq(int n) {
            this.numRequests = n;
        }

        public long totalRequestMetric() {
            return this.totalRequestMetric;
        }

        public void totalRequestMetric_$eq(long l) {
            this.totalRequestMetric = l;
        }

        public long maxRequestMetric() {
            return this.maxRequestMetric;
        }

        public void maxRequestMetric_$eq(long l) {
            this.maxRequestMetric = l;
        }

        public long totalData() {
            return this.totalData;
        }

        public void totalData_$eq(long l) {
            this.totalData = l;
        }

        private Object lock() {
            return this.lock;
        }

        public void addData(long data) {
            Object object = this.lock();
            synchronized (object) {
                this.totalData_$eq(this.totalData() + data);
                return;
            }
        }

        public void add(long requestNs) {
            Object object = this.lock();
            synchronized (object) {
                this.numRequests_$eq(this.numRequests() + 1);
                this.totalRequestMetric_$eq(this.totalRequestMetric() + requestNs);
                this.maxRequestMetric_$eq(package$.MODULE$.max(this.maxRequestMetric(), requestNs));
                return;
            }
        }

        public double durationSeconds() {
            return (double)(this.end().get() - this.start()) / 1.0E9;
        }

        public double durationMs() {
            return (double)(this.end().get() - this.start()) / 1000000.0;
        }

        public /* synthetic */ SnapshotStats kafka$utils$SnapshotStats$Stats$$$outer() {
            return SnapshotStats.this;
        }

        public Stats() {
            if (SnapshotStats.this == null) {
                throw new NullPointerException();
            }
            this.start = SnapshotStats.this.kafka$utils$SnapshotStats$$time().nanoseconds();
            this.end = new AtomicLong(-1L);
            this.numRequests = 0;
            this.totalRequestMetric = 0L;
            this.maxRequestMetric = 0L;
            this.totalData = 0L;
            this.lock = new Object();
        }
    }
}

