/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000f\tYA)\u001a7bs\u0016$\u0017\n^3n\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001\u0003\u0013\u0014\t\u0001I\u0011#\u0007\t\u0003\u0015=i\u0011a\u0003\u0006\u0003\u00195\tA\u0001\\1oO*\ta\"\u0001\u0003kCZ\f\u0017B\u0001\t\f\u0005\u0019y%M[3diB\u0011!cF\u0007\u0002')\u0011A#F\u0001\u000bG>t7-\u001e:sK:$(B\u0001\f\u000e\u0003\u0011)H/\u001b7\n\u0005a\u0019\"a\u0002#fY\u0006LX\r\u001a\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0001\"\u0003\u0011IG/Z7\u0016\u0003\t\u0002\"a\t\u0013\r\u0001\u0011AQ\u0005\u0001C\u0001\u0002\u000b\u0007aEA\u0001U#\t9#\u0006\u0005\u0002\u001bQ%\u0011\u0011f\u0007\u0002\b\u001d>$\b.\u001b8h!\tQ2&\u0003\u0002-7\t\u0019\u0011I\\=\t\u00119\u0002!\u0011!Q\u0001\n\t\nQ!\u001b;f[\u0002B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0006I\u0016d\u0017-\u001f\t\u00035IJ!aM\u000e\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005!QO\\5u!\t\u0011r'\u0003\u00029'\tAA+[7f+:LG\u000fC\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0005yyz\u0004\tE\u0002>\u0001\tj\u0011A\u0001\u0005\u0006Ae\u0002\rA\t\u0005\u0006ae\u0002\r!\r\u0005\u0006ke\u0002\rA\u000e\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003\u001d!W\r\\1z\u001bN,\u0012!\r\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u0019\u0002\u0011\u0011,G.Y=Ng\u0002Bqa\u0012\u0001C\u0002\u0013\u00051)A\u0005de\u0016\fG/\u001a3Ng\"1\u0011\n\u0001Q\u0001\nE\n!b\u0019:fCR,G-T:!\u0011\u0015Q\u0004\u0001\"\u0001L)\raD*\u0014\u0005\u0006A)\u0003\rA\t\u0005\u0006\u0005*\u0003\r!\r\u0005\u0006\u001f\u0002!\t\u0001U\u0001\tO\u0016$H)\u001a7bsR\u0011\u0011'\u0015\u0005\u0006k9\u0003\rA\u000e\u0005\u0006'\u0002!\t\u0001V\u0001\nG>l\u0007/\u0019:f)>$\"!\u0016-\u0011\u0005i1\u0016BA,\u001c\u0005\rIe\u000e\u001e\u0005\u00063J\u0003\r!E\u0001\u0002I\u0002")
public class DelayedItem<T>
implements Delayed,
ScalaObject {
    private final T item;
    private final long delayMs;
    private final long createdMs;

    public T item() {
        return this.item;
    }

    public long delayMs() {
        return this.delayMs;
    }

    public long createdMs() {
        return this.createdMs;
    }

    public DelayedItem(T item, long delayMs) {
        this(item, delayMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long ellapsedMs = System.currentTimeMillis() - this.createdMs();
        return unit.convert(package$.MODULE$.max(this.delayMs() - ellapsedMs, 0L), unit);
    }

    @Override
    public int compareTo(Delayed d) {
        long yourEnd;
        DelayedItem delayed = (DelayedItem)d;
        long myEnd = this.createdMs() + this.delayMs();
        return myEnd < (yourEnd = delayed.createdMs() - delayed.delayMs()) ? -1 : (myEnd > yourEnd ? 1 : 0);
    }

    public DelayedItem(T item, long delay, TimeUnit unit) {
        this.item = item;
        this.delayMs = unit.toMillis(delay);
        this.createdMs = System.currentTimeMillis();
    }
}

