/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.net.URI;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.FetchRequest;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.tools.SimpleConsumerPerformance$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SimpleConsumerPerformance$
implements ScalaObject {
    public static final SimpleConsumerPerformance$ MODULE$;

    static {
        new SimpleConsumerPerformance$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec urlOpt = parser$1.accepts("server", "REQUIRED: The hostname of the server to connect to.").withRequiredArg().describedAs("kafka://hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser$1.accepts("fetch-size", "REQUIRED: The fetch size to use for consumption.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{urlOpt, topicOpt})).foreach((Function1)new anonfun.main.1(parser$1, options$1));
        URI url = new URI((String)options$1.valueOf((OptionSpec)urlOpt));
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        int fetchSize = (Integer)options$1.valueOf((OptionSpec)fetchSizeOpt);
        SimpleConsumer consumer = new SimpleConsumer(url.getHost(), url.getPort(), 30000, 2 * fetchSize);
        long startMs = System.currentTimeMillis();
        boolean done = false;
        int totalRead = 0;
        int reportingInterval = 100000;
        int consumedInInterval = 0;
        long offset = 0L;
        while (true) {
            if (done) {
                double ellapsedSeconds = (double)(System.currentTimeMillis() - startMs) / 1000.0;
                Predef$.MODULE$.println((Object)new StringBuilder().append(totalRead).append((Object)" messages read, ").append((Object)BoxesRunTime.boxToLong((long)offset)).append((Object)" bytes").toString());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Messages/sec: ").append((Object)BoxesRunTime.boxToDouble((double)((double)totalRead / ellapsedSeconds))).toString());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"MB/sec: ").append((Object)BoxesRunTime.boxToDouble((double)((double)offset / ellapsedSeconds / 1048576.0))).toString());
                System.exit(0);
                return;
            }
            ByteBufferMessageSet messages = consumer.fetch(new FetchRequest(topic, 0, offset, fetchSize));
            IntRef messagesRead$1 = new IntRef(0);
            messages.foreach((Function1)new anonfun.main.2(messagesRead$1));
            if (messagesRead$1.elem == 0) {
                done = true;
            } else {
                offset += (long)messages.validBytes();
            }
            totalRead += messagesRead$1.elem;
            if ((consumedInInterval += messagesRead$1.elem) <= reportingInterval) continue;
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Bytes read: ").append((Object)BoxesRunTime.boxToInteger((int)totalRead)).toString());
            consumedInInterval = 0;
        }
    }

    private SimpleConsumerPerformance$() {
        MODULE$ = this;
    }
}

