/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.producer.SyncProducer;
import kafka.producer.SyncProducerConfig;
import kafka.tools.ProducerShell$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ProducerShell$
implements ScalaObject {
    public static final ProducerShell$ MODULE$;

    static {
        new ProducerShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec urlOpt = parser$1.accepts("server", "REQUIRED: The hostname of the server to connect to.").withRequiredArg().describedAs("kafka://hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to produce to.").withRequiredArg().describedAs("topic").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{urlOpt, topicOpt})).foreach((Function1)new anonfun.main.1(parser$1, options$1));
        URI url = new URI((String)options$1.valueOf((OptionSpec)urlOpt));
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        Properties props = new Properties();
        props.put("host", url.getHost());
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)url.getPort())).toString());
        props.put("buffer.size", "65536");
        props.put("connect.timeout.ms", "10000");
        props.put("reconnect.interval", "100");
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        while (true) {
            if (done) {
                producer.close();
                return;
            }
            String line = input.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            byte[] lineBytes = line.trim().getBytes();
            ByteBufferMessageSet messages = new ByteBufferMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(lineBytes)}));
            producer.send(topic, messages);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"sent: ").append((Object)line).append((Object)" (").append((Object)BoxesRunTime.boxToLong((long)messages.sizeInBytes())).append((Object)" bytes)").toString());
        }
    }

    private ProducerShell$() {
        MODULE$ = this;
    }
}

