/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.serializer.StringEncoder;
import kafka.tools.ProducerPerformance$;
import kafka.tools.ProducerPerformance$$anonfun$kafka$tools$ProducerPerformance$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ProducerPerformance$
implements ScalaObject {
    public static final ProducerPerformance$ MODULE$;

    static {
        new ProducerPerformance$();
    }

    public void main(String[] args) {
        Object object;
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec brokerInfoOpt = parser$1.accepts("brokerinfo", "REQUIRED: broker info (either from zookeeper or a list.").withRequiredArg().describedAs("broker.list=brokerid:hostname:port or zk.connect=host:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec numMessagesOpt = parser$1.accepts("messages", "REQUIRED: The number of messages to send.").withRequiredArg().describedAs("count").ofType(Integer.class);
        ArgumentAcceptingOptionSpec messageSizeOpt = parser$1.accepts("message-size", "The size of each message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        OptionSpecBuilder varyMessageSizeOpt = parser$1.accepts("vary-message-size", "If set, message size will vary up to the given maximum.");
        OptionSpecBuilder asyncOpt = parser$1.accepts("async", "If set, messages are sent asynchronously.");
        ArgumentAcceptingOptionSpec delayMSBtwBatchOpt = parser$1.accepts("delay-btw-batch-ms", "Delay in ms between 2 batch sends.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec batchSizeOpt = parser$1.accepts("batch-size", "Number of messages to send in a single batch.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numThreadsOpt = parser$1.accepts("threads", "Number of sending threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec reportingIntervalOpt = parser$1.accepts("reporting-interval", "Interval at which to print progress info.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100000), (Object[])new Integer[0]);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{brokerInfoOpt, topicOpt, numMessagesOpt})).foreach((Function1)new anonfun.main.2(parser$1, options$1));
        String brokerInfo = (String)options$1.valueOf((OptionSpec)brokerInfoOpt);
        int numMessages = (Integer)options$1.valueOf((OptionSpec)numMessagesOpt);
        int messageSize$1 = (Integer)options$1.valueOf((OptionSpec)messageSizeOpt);
        boolean isFixSize$1 = !options$1.has((OptionSpec)varyMessageSizeOpt);
        boolean isAsync = options$1.has((OptionSpec)asyncOpt);
        long delayedMSBtwSend$1 = (Long)options$1.valueOf((OptionSpec)delayMSBtwBatchOpt);
        int batchSize$1 = (Integer)options$1.valueOf((OptionSpec)batchSizeOpt);
        int numThreads = (Integer)options$1.valueOf((OptionSpec)numThreadsOpt);
        String topic$1 = (String)options$1.valueOf((OptionSpec)topicOpt);
        int reportingInterval$1 = (Integer)options$1.valueOf((OptionSpec)reportingIntervalOpt);
        Random rand$1 = new Random();
        String[] brokerInfoList = brokerInfo.split("=");
        Properties props$1 = new Properties();
        String string = brokerInfoList[0];
        String string2 = "zk.connect";
        Object object2 = !(string != null ? !string.equals(string2) : string2 != null) ? props$1.put("zk.connect", brokerInfoList[1]) : props$1.put("broker.list", brokerInfoList[1]);
        if (isAsync) {
            object = props$1.put("producer.type", "async");
        } else {
            props$1.put("producer.type", "sync");
            props$1.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize$1)).toString());
            object = props$1.put("event.handler", "kafka.producer.async.EventHandler");
        }
        props$1.put("reconnect.interval", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        StringEncoder encoder$1 = new StringEncoder();
        int messagesPerThread$1 = numMessages / numThreads;
        AtomicLong totalBytesSent$1 = new AtomicLong(0L);
        AtomicLong totalMessagesSent$1 = new AtomicLong(0L);
        ExecutorService executor$1 = Executors.newFixedThreadPool(numThreads);
        CountDownLatch allDone$1 = new CountDownLatch(numThreads);
        long startMs = System.currentTimeMillis();
        Predef$.MODULE$.intWrapper(0).until(numThreads).foreach$mVc$sp((Function1)new anonfun.main.1(messageSize$1, isFixSize$1, delayedMSBtwSend$1, batchSize$1, topic$1, reportingInterval$1, rand$1, props$1, encoder$1, messagesPerThread$1, totalBytesSent$1, totalMessagesSent$1, executor$1, allDone$1));
        allDone$1.await();
        double elapsedSecs = (double)(System.currentTimeMillis() - startMs) / 1000.0;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total Num Messages: ").append((Object)BoxesRunTime.boxToLong((long)totalMessagesSent$1.get())).append((Object)" bytes: ").append((Object)BoxesRunTime.boxToLong((long)totalBytesSent$1.get())).append((Object)" in ").append((Object)BoxesRunTime.boxToDouble((double)elapsedSecs)).append((Object)" secs").toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Messages/sec: ").append((Object)Predef$.MODULE$.any2stringadd((Object)BoxesRunTime.boxToDouble((double)(1.0 * (double)totalMessagesSent$1.get() / elapsedSecs))).formatted("%.4f")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"MB/sec: ").append((Object)Predef$.MODULE$.any2stringadd((Object)BoxesRunTime.boxToDouble((double)((double)totalBytesSent$1.get() / elapsedSecs / 1048576.0))).formatted("%.4f")).toString());
        System.exit(0);
    }

    public final String kafka$tools$ProducerPerformance$$getStringOfLength(int len) {
        char[] strArray$1 = new char[len];
        Predef$.MODULE$.intWrapper(0).until(len).foreach$mVc$sp((Function1)new anonfun$kafka$tools$ProducerPerformance$$getStringOfLength$1(strArray$1));
        return new String(strArray$1);
    }

    private ProducerPerformance$() {
        MODULE$ = this;
    }
}

