/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.net.URI;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.SimpleConsumer;
import kafka.tools.GetOffsetShell$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class GetOffsetShell$
implements ScalaObject {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec urlOpt = parser$1.accepts("server", "REQUIRED: The hostname of the server to connect to.").withRequiredArg().describedAs("kafka://hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser$1.accepts("partition", "partition id").withRequiredArg().describedAs("partition id").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser$1.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec nOffsetsOpt = parser$1.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{urlOpt, topicOpt, timeOpt})).foreach((Function1)new anonfun.main.2(parser$1, options$1));
        URI url = new URI((String)options$1.valueOf((OptionSpec)urlOpt));
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        int partition = (Integer)options$1.valueOf((OptionSpec)partitionOpt);
        long time = (Long)options$1.valueOf((OptionSpec)timeOpt);
        int nOffsets = (Integer)options$1.valueOf((OptionSpec)nOffsetsOpt);
        SimpleConsumer consumer = new SimpleConsumer(url.getHost(), url.getPort(), 10000, 100000);
        long[] offsets = consumer.getOffsetsBefore(topic, partition, time, nOffsets);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"get ").append((Object)BoxesRunTime.boxToInteger((int)offsets.length)).append((Object)" results").toString());
        Predef$.MODULE$.longArrayOps(offsets).foreach((Function1)new anonfun.main.1());
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

