/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchRequest$;
import kafka.api.MultiProducerRequest;
import kafka.api.MultiProducerRequest$;
import kafka.api.OffsetArraySend;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.common.ErrorMapping$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.MessageSet$;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.server.KafkaRequestHandlers$;
import kafka.server.MessageSetSend;
import kafka.server.MultiMessageSetSend;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001Y4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\t\u0001\u0002\u0004\u0003)-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:t\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lCN\u0019\u0001aB\b\u0011\u0005!iQ\"A\u0005\u000b\u0005)Y\u0011\u0001\u00027b]\u001eT\u0011\u0001D\u0001\u0005U\u00064\u0018-\u0003\u0002\u000f\u0013\t1qJ\u00196fGR\u0004\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u00111bU2bY\u0006|%M[3di\"Aa\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0006m_\u001el\u0015M\\1hKJ\u001c\u0001!F\u0001\u001a!\tQR$D\u0001\u001c\u0015\taB!A\u0002m_\u001eL!AH\u000e\u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001a\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0001C\u0003\u0017C\u0001\u0007\u0011\u0004C\u0004)\u0001\t\u0007I\u0011B\u0015\u0002\r1|wmZ3s+\u0005Q\u0003CA\u00163\u001b\u0005a#BA\u0017/\u0003\u0015awn\u001a\u001bk\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\n\u0005Mb#A\u0002'pO\u001e,'\u000f\u0003\u00046\u0001\u0001\u0006IAK\u0001\bY><w-\u001a:!\u0011\u00159\u0004\u0001\"\u00019\u0003)A\u0017M\u001c3mKJ4uN\u001d\u000b\u0004s\rC\u0005C\u0001\u001eA\u001d\tYd(D\u0001=\u0015\tiD!A\u0004oKR<xN]6\n\u0005}b\u0014a\u0002%b]\u0012dWM]\u0005\u0003\u0003\n\u0013q\u0001S1oI2,'O\u0003\u0002@y!)AI\u000ea\u0001\u000b\u0006i!/Z9vKN$H+\u001f9f\u0013\u0012\u0004\"\u0001\u0005$\n\u0005\u001d\u000b\"!B*i_J$\b\"B%7\u0001\u0004Q\u0015a\u0002:fcV,7\u000f\u001e\t\u0003w-K!\u0001\u0014\u001f\u0003\u000fI+7-Z5wK\")a\n\u0001C\u0001\u001f\u0006)\u0002.\u00198eY\u0016\u0004&o\u001c3vG\u0016\u0014(+Z9vKN$HC\u0001)W!\r\u0001\u0012kU\u0005\u0003%F\u0011aa\u00149uS>t\u0007CA\u001eU\u0013\t)FH\u0001\u0003TK:$\u0007\"B,N\u0001\u0004Q\u0015a\u0002:fG\u0016Lg/\u001a\u0005\u00063\u0002!\tAW\u0001\u001bQ\u0006tG\r\\3Nk2$\u0018\u000e\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e\u000b\u0003!nCQa\u0016-A\u0002)CQ!\u0018\u0001\u0005\u0002y\u000b!\u0003[1oI2,g)\u001a;dQJ+\u0017/^3tiR\u0011\u0001k\u0018\u0005\u0006\u0013r\u0003\rA\u0013\u0005\u0006C\u0002!\tAY\u0001\u0018Q\u0006tG\r\\3Nk2$\u0018NR3uG\"\u0014V-];fgR$\"\u0001U2\t\u000b%\u0003\u0007\u0019\u0001&\t\u000b\u0015\u0004A\u0011\u00024\u0002\u001dI,\u0017\rZ'fgN\fw-Z*fiR\u0011qM\u001b\t\u0003K!L!!\u001b\u0002\u0003\u001d5+7o]1hKN+GoU3oI\")1\u000e\u001aa\u0001Y\u0006aa-\u001a;dQJ+\u0017/^3tiB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eB\u0001\u0004CBL\u0017BA9o\u000511U\r^2i%\u0016\fX/Z:u\u0011\u0015\u0019\b\u0001\"\u0001u\u0003MA\u0017M\u001c3mK>3gm]3u%\u0016\fX/Z:u)\t\u0001V\u000fC\u0003Je\u0002\u0007!\n")
public class KafkaRequestHandlers
implements ScalaObject {
    private final LogManager logManager;
    private final Logger kafka$server$KafkaRequestHandlers$$logger;

    public LogManager logManager() {
        return this.logManager;
    }

    public final Logger kafka$server$KafkaRequestHandlers$$logger() {
        return this.kafka$server$KafkaRequestHandlers$$logger;
    }

    public Function1<Receive, Option<Send>> handlerFor(short requestTypeId, Receive request) {
        block7: {
            AbstractFunction1 abstractFunction1;
            block3: {
                short s;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                s = requestTypeId;
                                if (s != RequestKeys$.MODULE$.Produce()) break block2;
                                abstractFunction1 = new $anonfun$handlerFor$1(this);
                                break block3;
                            }
                            if (s != RequestKeys$.MODULE$.Fetch()) break block4;
                            abstractFunction1 = new $anonfun$handlerFor$2(this);
                            break block3;
                        }
                        if (s != RequestKeys$.MODULE$.MultiFetch()) break block5;
                        abstractFunction1 = new $anonfun$handlerFor$3(this);
                        break block3;
                    }
                    if (s != RequestKeys$.MODULE$.MultiProduce()) break block6;
                    abstractFunction1 = new $anonfun$handlerFor$4(this);
                    break block3;
                }
                if (s != RequestKeys$.MODULE$.Offsets()) break block7;
                abstractFunction1 = new $anonfun$handlerFor$5(this);
            }
            return abstractFunction1;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"No mapping found for handler id ").append((Object)BoxesRunTime.boxToShort((short)requestTypeId)).toString());
    }

    public Option<Send> handleProducerRequest(Receive receive) {
        long sTime;
        block5: {
            sTime = SystemTime$.MODULE$.milliseconds();
            if (this.kafka$server$KafkaRequestHandlers$$logger().isTraceEnabled()) {
                this.kafka$server$KafkaRequestHandlers$$logger().trace((Object)"Handling producer request");
            }
            ProducerRequest request = ProducerRequest$.MODULE$.readFrom(receive.buffer());
            int partition = request.getTranslatedPartition((Function1<String, Integer>)new $anonfun$1(this));
            try {
                this.logManager().getOrCreateLog(request.topic(), partition).append(request.messages());
                if (!this.kafka$server$KafkaRequestHandlers$$logger().isTraceEnabled()) break block5;
                this.kafka$server$KafkaRequestHandlers$$logger().trace((Object)new StringBuilder().append(request.messages().sizeInBytes()).append((Object)" bytes written to logs.").toString());
            }
            catch (Throwable throwable) {
                this.kafka$server$KafkaRequestHandlers$$logger().error((Object)new StringBuilder().append((Object)"error processing ProduceRequst on ").append((Object)request.topic()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString(), throwable);
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    this.kafka$server$KafkaRequestHandlers$$logger().error((Object)new StringBuilder().append((Object)"force shutdown due to ").append((Object)throwable).toString());
                    Runtime.getRuntime().halt(1);
                }
                throw throwable;
            }
        }
        if (this.kafka$server$KafkaRequestHandlers$$logger().isDebugEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$logger().debug((Object)new StringBuilder().append((Object)"kafka produce time ").append((Object)BoxesRunTime.boxToLong((long)(SystemTime$.MODULE$.milliseconds() - sTime))).append((Object)" ms").toString());
        }
        return None$.MODULE$;
    }

    public Option<Send> handleMultiProducerRequest(Receive receive) {
        if (this.kafka$server$KafkaRequestHandlers$$logger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$logger().trace((Object)"Handling multiproducer request");
        }
        MultiProducerRequest request = MultiProducerRequest$.MODULE$.readFrom(receive.buffer());
        Predef$.MODULE$.refArrayOps((Object[])request.produces()).foreach((Function1)new $anonfun$handleMultiProducerRequest$1(this));
        return None$.MODULE$;
    }

    public Option<Send> handleFetchRequest(Receive request) {
        if (this.kafka$server$KafkaRequestHandlers$$logger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$logger().trace((Object)"Handling fetch request");
        }
        FetchRequest fetchRequest = FetchRequest$.MODULE$.readFrom(request.buffer());
        return new Some((Object)this.kafka$server$KafkaRequestHandlers$$readMessageSet(fetchRequest));
    }

    public Option<Send> handleMultiFetchRequest(Receive request) {
        if (this.kafka$server$KafkaRequestHandlers$$logger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$logger().trace((Object)"Handling multifetch request");
        }
        MultiFetchRequest multiFetchRequest = MultiFetchRequest$.MODULE$.readFrom(request.buffer());
        List responses = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).map((Function1)new $anonfun$3(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(MessageSetSend.class)))).toList();
        return new Some((Object)new MultiMessageSetSend((List<MessageSetSend>)responses));
    }

    /*
     * WARNING - void declaration
     */
    public final MessageSetSend kafka$server$KafkaRequestHandlers$$readMessageSet(FetchRequest fetchRequest) {
        void var2_2;
        MessageSetSend response = null;
        try {
            Log log = this.logManager().getOrCreateLog(fetchRequest.topic(), fetchRequest.partition());
            response = new MessageSetSend(log.read(fetchRequest.offset(), fetchRequest.maxSize()));
        }
        catch (Throwable throwable) {
            this.kafka$server$KafkaRequestHandlers$$logger().error((Object)new StringBuilder().append((Object)"error when processing request ").append((Object)fetchRequest).toString(), throwable);
            response = new MessageSetSend(MessageSet$.MODULE$.Empty(), ErrorMapping$.MODULE$.codeFor(throwable.getClass()));
        }
        return var2_2;
    }

    public Option<Send> handleOffsetRequest(Receive request) {
        if (this.kafka$server$KafkaRequestHandlers$$logger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$logger().trace((Object)"Handling offset request");
        }
        OffsetRequest offsetRequest = OffsetRequest$.MODULE$.readFrom(request.buffer());
        Log log = this.logManager().getOrCreateLog(offsetRequest.topic(), offsetRequest.partition());
        long[] offsets = log.getOffsetsBefore(offsetRequest);
        OffsetArraySend response = new OffsetArraySend(offsets);
        return new Some((Object)response);
    }

    public KafkaRequestHandlers(LogManager logManager) {
        this.logManager = logManager;
        this.kafka$server$KafkaRequestHandlers$$logger = Logger.getLogger(KafkaRequestHandlers.class);
    }
}

