/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.message.Message$;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011!B;uS2\u001c\u0018BA\u0007\u000b\u0005!Q6jQ8oM&<\u0007CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0006aJ|\u0007o\u001d\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tA!\u001e;jY*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001a\u0003C\u0001\u0012\u0001\u001b\u0005\u0011\u0001\"B\u000b\u001f\u0001\u00041\u0002bB\u0013\u0001\u0005\u0004%\tAJ\u0001\u0005a>\u0014H/F\u0001(!\ty\u0001&\u0003\u0002*!\t\u0019\u0011J\u001c;\t\r-\u0002\u0001\u0015!\u0003(\u0003\u0015\u0001xN\u001d;!\u0011\u001di\u0003A1A\u0005\u00029\n\u0001\u0002[8ti:\u000bW.Z\u000b\u0002_A\u0011\u0001g\r\b\u0003\u001fEJ!A\r\t\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eAAaa\u000e\u0001!\u0002\u0013y\u0013!\u00035pgRt\u0015-\\3!\u0011\u001dI\u0004A1A\u0005\u0002\u0019\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u0014\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAJ\u0001\u0011g>\u001c7.\u001a;TK:$')\u001e4gKJDaa\u0010\u0001!\u0002\u00139\u0013!E:pG.,GoU3oI\n+hMZ3sA!9\u0011\t\u0001b\u0001\n\u00031\u0013aE:pG.,GOU3dK&4XMQ;gM\u0016\u0014\bBB\"\u0001A\u0003%q%\u0001\u000bt_\u000e\\W\r\u001e*fG\u0016Lg/\u001a\"vM\u001a,'\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001'\u0003Qi\u0017\r_*pG.,GOU3rk\u0016\u001cHoU5{K\"1q\t\u0001Q\u0001\n\u001d\nQ#\\1y'>\u001c7.\u001a;SKF,Xm\u001d;TSj,\u0007\u0005C\u0004J\u0001\t\u0007I\u0011\u0001\u0014\u0002\u00159,X\u000e\u00165sK\u0006$7\u000f\u0003\u0004L\u0001\u0001\u0006IaJ\u0001\f]VlG\u000b\u001b:fC\u0012\u001c\b\u0005C\u0004N\u0001\t\u0007I\u0011\u0001\u0014\u0002)5|g.\u001b;pe&tw\rU3sS>$7+Z2t\u0011\u0019y\u0005\u0001)A\u0005O\u0005)Rn\u001c8ji>\u0014\u0018N\\4QKJLw\u000eZ*fGN\u0004\u0003bB)\u0001\u0005\u0004%\tAJ\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\rM\u0003\u0001\u0015!\u0003(\u00039qW/\u001c)beRLG/[8og\u0002Bq!\u0016\u0001C\u0002\u0013\u0005a&\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007/\u0002\u0001\u000b\u0011B\u0018\u0002\u000f1|w\rR5sA!9\u0011\f\u0001b\u0001\n\u00031\u0013a\u00037pO\u001aKG.Z*ju\u0016Daa\u0017\u0001!\u0002\u00139\u0013\u0001\u00047pO\u001aKG.Z*ju\u0016\u0004\u0003bB/\u0001\u0005\u0004%\tAJ\u0001\u000eM2,8\u000f[%oi\u0016\u0014h/\u00197\t\r}\u0003\u0001\u0015!\u0003(\u000391G.^:i\u0013:$XM\u001d<bY\u0002Bq!\u0019\u0001C\u0002\u0013\u0005a%A\tm_\u001e\u0014V\r^3oi&|g\u000eS8veNDaa\u0019\u0001!\u0002\u00139\u0013A\u00057pOJ+G/\u001a8uS>t\u0007j\\;sg\u0002Bq!\u001a\u0001C\u0002\u0013\u0005a-\u0001\u000bm_\u001e\u0014V\r^3oi&|g\u000eS8veNl\u0015\r]\u000b\u0002OB!\u0001n[\u0018(\u001b\u0005I'B\u00016\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Y&\u00141!T1q\u0011\u0019q\u0007\u0001)A\u0005O\u0006)Bn\\4SKR,g\u000e^5p]\"{WO]:NCB\u0004\u0003b\u00029\u0001\u0005\u0004%\tAJ\u0001\u001aY><7\t\\3b]V\u0004\u0018J\u001c;feZ\fG.T5okR,7\u000f\u0003\u0004s\u0001\u0001\u0006IaJ\u0001\u001bY><7\t\\3b]V\u0004\u0018J\u001c;feZ\fG.T5okR,7\u000f\t\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0003=)g.\u00192mKj{wn[3fa\u0016\u0014X#\u0001<\u0011\u0005=9\u0018B\u0001=\u0011\u0005\u001d\u0011un\u001c7fC:DaA\u001f\u0001!\u0002\u00131\u0018\u0001E3oC\ndWMW8pW\u0016,\u0007/\u001a:!\u0011\u001da\bA1A\u0005\u0002\u0019\f\u0001C\u001a7vg\"Le\u000e^3sm\u0006dW*\u00199\t\ry\u0004\u0001\u0015!\u0003h\u0003E1G.^:i\u0013:$XM\u001d<bY6\u000b\u0007\u000f\t\u0005\t\u0003\u0003\u0001!\u0019!C\u0001M\u0005Ab\r\\;tQN\u001b\u0007.\u001a3vY\u0016\u0014H\u000b\u001b:fC\u0012\u0014\u0016\r^3\t\u000f\u0005\u0015\u0001\u0001)A\u0005O\u0005Ib\r\\;tQN\u001b\u0007.\u001a3vY\u0016\u0014H\u000b\u001b:fC\u0012\u0014\u0016\r^3!\u0011!\tI\u0001\u0001b\u0001\n\u00031\u0013A\u00063fM\u0006,H\u000e\u001e$mkND\u0017J\u001c;feZ\fG.T:\t\u000f\u00055\u0001\u0001)A\u0005O\u00059B-\u001a4bk2$h\t\\;tQ&sG/\u001a:wC2l5\u000f\t\u0005\t\u0003#\u0001!\u0019!C\u0001M\u0006\u0011Bo\u001c9jGB\u000b'\u000f^5uS>t7/T1q\u0011\u001d\t)\u0002\u0001Q\u0001\n\u001d\f1\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]'ba\u0002\u0002")
public class KafkaConfig
extends ZKConfig
implements ScalaObject {
    private final int port;
    private final String hostName;
    private final int brokerId;
    private final int socketSendBuffer;
    private final int socketReceiveBuffer;
    private final int maxSocketRequestSize;
    private final int numThreads;
    private final int monitoringPeriodSecs;
    private final int numPartitions;
    private final String logDir;
    private final int logFileSize;
    private final int flushInterval;
    private final int logRetentionHours;
    private final Map<String, Integer> logRetentionHoursMap;
    private final int logCleanupIntervalMinutes;
    private final boolean enableZookeeper;
    private final Map<String, Integer> flushIntervalMap;
    private final int flushSchedulerThreadRate;
    private final int defaultFlushIntervalMs;
    private final Map<String, Integer> topicPartitionsMap;

    public int port() {
        return this.port;
    }

    public String hostName() {
        return this.hostName;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int socketSendBuffer() {
        return this.socketSendBuffer;
    }

    public int socketReceiveBuffer() {
        return this.socketReceiveBuffer;
    }

    public int maxSocketRequestSize() {
        return this.maxSocketRequestSize;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public int monitoringPeriodSecs() {
        return this.monitoringPeriodSecs;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public String logDir() {
        return this.logDir;
    }

    public int logFileSize() {
        return this.logFileSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public int logRetentionHours() {
        return this.logRetentionHours;
    }

    public Map<String, Integer> logRetentionHoursMap() {
        return this.logRetentionHoursMap;
    }

    public int logCleanupIntervalMinutes() {
        return this.logCleanupIntervalMinutes;
    }

    public boolean enableZookeeper() {
        return this.enableZookeeper;
    }

    public Map<String, Integer> flushIntervalMap() {
        return this.flushIntervalMap;
    }

    public int flushSchedulerThreadRate() {
        return this.flushSchedulerThreadRate;
    }

    public int defaultFlushIntervalMs() {
        return this.defaultFlushIntervalMs;
    }

    public Map<String, Integer> topicPartitionsMap() {
        return this.topicPartitionsMap;
    }

    public KafkaConfig(Properties props) {
        super(props);
        this.port = Utils$.MODULE$.getInt(props, "port", 6667);
        this.hostName = Utils$.MODULE$.getString(props, "hostname", null);
        this.brokerId = Utils$.MODULE$.getInt(props, "brokerid");
        this.socketSendBuffer = Utils$.MODULE$.getInt(props, "socket.send.buffer", 102400);
        this.socketReceiveBuffer = Utils$.MODULE$.getInt(props, "socket.receive.buffer", 102400);
        this.maxSocketRequestSize = Utils$.MODULE$.getIntInRange(props, "max.socket.request.bytes", 0x6400000, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numThreads = Utils$.MODULE$.getIntInRange(props, "num.threads", Runtime.getRuntime().availableProcessors(), (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.monitoringPeriodSecs = Utils$.MODULE$.getIntInRange(props, "monitoring.period.secs", 600, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numPartitions = Utils$.MODULE$.getIntInRange(props, "num.partitions", 1, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logDir = Utils$.MODULE$.getString(props, "log.dir");
        this.logFileSize = Utils$.MODULE$.getIntInRange(props, "log.file.size", 0x40000000, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(Message$.MODULE$.HeaderSize(), Integer.MAX_VALUE));
        this.flushInterval = Utils$.MODULE$.getIntInRange(props, "log.flush.interval", 500, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logRetentionHours = Utils$.MODULE$.getIntInRange(props, "log.retention.hours", 168, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logRetentionHoursMap = Utils$.MODULE$.getTopicRentionHours(Utils$.MODULE$.getString(props, "topic.log.retention.hours", ""));
        this.logCleanupIntervalMinutes = Utils$.MODULE$.getIntInRange(props, "log.cleanup.interval.mins", 10, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.enableZookeeper = Utils$.MODULE$.getBoolean(props, "enable.zookeeper", true);
        this.flushIntervalMap = Utils$.MODULE$.getTopicFlushIntervals(Utils$.MODULE$.getString(props, "topic.flush.intervals.ms", ""));
        this.flushSchedulerThreadRate = Utils$.MODULE$.getInt(props, "log.default.flush.scheduler.interval.ms", 3000);
        this.defaultFlushIntervalMs = Utils$.MODULE$.getInt(props, "log.default.flush.interval.ms", this.flushSchedulerThreadRate());
        this.topicPartitionsMap = Utils$.MODULE$.getTopicPartitions(Utils$.MODULE$.getString(props, "topic.partition.count.map", ""));
    }
}

