/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.common.InvalidConfigException;
import kafka.common.InvalidPartitionException;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.ConfigBrokerPartitionInfo;
import kafka.producer.DefaultPartitioner;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.producer.ProducerPool;
import kafka.producer.ZKBrokerPartitionInfo;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0005%gM\u0019\u0001!C\t\u0011\u0005)yQ\"A\u0006\u000b\u00051i\u0011\u0001\u00027b]\u001eT\u0011AD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0011\u0017\t1qJ\u00196fGR\u0004\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u00111bU2bY\u0006|%M[3di\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0004d_:4\u0017n\u001a\t\u00035mi\u0011AA\u0005\u00039\t\u0011a\u0002\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003-\u0001\u0018M\u001d;ji&|g.\u001a:\u0011\u0007i\u0001#%\u0003\u0002\"\u0005\tY\u0001+\u0019:uSRLwN\\3s!\t\u0019C\u0005\u0004\u0001\u0005\u0011\u0015\u0002A\u0011!AC\u0002\u0019\u0012\u0011aS\t\u0003O)\u0002\"A\u0005\u0015\n\u0005%\u001a\"a\u0002(pi\"Lgn\u001a\t\u0003%-J!\u0001L\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00031\u0001(o\u001c3vG\u0016\u0014\bk\\8m!\rQ\u0002GM\u0005\u0003c\t\u0011A\u0002\u0015:pIV\u001cWM\u001d)p_2\u0004\"aI\u001a\u0005\u0011Q\u0002A\u0011!AC\u0002\u0019\u0012\u0011A\u0016\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005!\u0002o\u001c9vY\u0006$X\r\u0015:pIV\u001cWM\u001d)p_2\u0004\"A\u0005\u001d\n\u0005e\u001a\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000burt\bQ!\u0011\ti\u0001!E\r\u0005\u00061i\u0002\r!\u0007\u0005\u0006=i\u0002\ra\b\u0005\u0006]i\u0002\ra\f\u0005\bmi\u0002\n\u00111\u00018\u0011\u001d\u0019\u0005A1A\u0005\n\u0011\u000ba\u0001\\8hO\u0016\u0014X#A#\u0011\u0005\u0019kU\"A$\u000b\u0005!K\u0015!\u00027pORR'B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!AT$\u0003\r1{wmZ3s\u0011\u0019\u0001\u0006\u0001)A\u0005\u000b\u00069An\\4hKJ\u0004\u0003b\u0002*\u0001\u0005\u0004%IaU\u0001\fQ\u0006\u001c8\u000b[;uI><h.F\u0001U!\t)F,D\u0001W\u0015\t9\u0006,\u0001\u0004bi>l\u0017n\u0019\u0006\u00033j\u000b!bY8oGV\u0014(/\u001a8u\u0015\tYV\"\u0001\u0003vi&d\u0017BA/W\u00055\tEo\\7jG\n{w\u000e\\3b]\"1q\f\u0001Q\u0001\nQ\u000bA\u0002[1t'\",H\u000fZ8x]\u0002Bq!\u0019\u0001C\u0002\u0013%!-\u0001\u0004sC:$w.\\\u000b\u0002GB\u0011A-Z\u0007\u00025&\u0011aM\u0017\u0002\u0007%\u0006tGm\\7\t\r!\u0004\u0001\u0015!\u0003d\u0003\u001d\u0011\u0018M\u001c3p[\u0002BqA\u001b\u0001A\u0002\u0013%1.A\nce>\\WM\u001d)beRLG/[8o\u0013:4w.F\u0001m!\tQR.\u0003\u0002o\u0005\t\u0019\"I]8lKJ\u0004\u0016M\u001d;ji&|g.\u00138g_\"9\u0001\u000f\u0001a\u0001\n\u0013\t\u0018a\u00062s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|w\fJ3r)\t\u0011X\u000f\u0005\u0002\u0013g&\u0011Ao\u0005\u0002\u0005+:LG\u000fC\u0004w_\u0006\u0005\t\u0019\u00017\u0002\u0007a$\u0013\u0007\u0003\u0004y\u0001\u0001\u0006K\u0001\\\u0001\u0015EJ|7.\u001a:QCJ$\u0018\u000e^5p]&sgm\u001c\u0011\t\u000fi\u0004!\u0019!C\u0005w\u0006I!p[#oC\ndW\rZ\u000b\u0002o!1Q\u0010\u0001Q\u0001\n]\n!B_6F]\u0006\u0014G.\u001a3!\u0011\u0015Y\u0004\u0001\"\u0001\u0000)\ri\u0014\u0011\u0001\u0005\u00061y\u0004\r!\u0007\u0005\u0007w\u0001!\t!!\u0002\u0015\u0017u\n9!!\u0003\u0002\u001a\u0005%\u00121\u0007\u0005\u00071\u0005\r\u0001\u0019A\r\t\u0011\u0005-\u00111\u0001a\u0001\u0003\u001b\tq!\u001a8d_\u0012,'\u000fE\u0003\u0002\u0010\u0005U!'\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0003\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0002\u0018\u0005E!aB#oG>$WM\u001d\u0005\t\u00037\t\u0019\u00011\u0001\u0002\u001e\u0005aQM^3oi\"\u000bg\u000e\u001a7feB)\u0011qDA\u0013e5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\u0011\u0011!B1ts:\u001c\u0017\u0002BA\u0014\u0003C\u0011A\"\u0012<f]RD\u0015M\u001c3mKJD\u0001\"a\u000b\u0002\u0004\u0001\u0007\u0011QF\u0001\u000bG\n\\\u0007*\u00198eY\u0016\u0014\b#BA\u0010\u0003_\u0011\u0014\u0002BA\u0019\u0003C\u0011qbQ1mY\n\f7m\u001b%b]\u0012dWM\u001d\u0005\u0007=\u0005\r\u0001\u0019A\u0010\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u0005!1/\u001a8e)\r\u0011\u00181\b\u0005\t\u0003{\t)\u00041\u0001\u0002@\u0005a\u0001O]8ek\u000e,'\u000fR1uCB)!#!\u0011\u0002F%\u0019\u00111I\n\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0003\u001b\u0003\u000f\u0012#'C\u0002\u0002J\t\u0011A\u0002\u0015:pIV\u001cWM\u001d#bi\u0006Dq!!\u0014\u0001\t\u0013\ty%\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002R\u0005]\u00131\f\t\u0004%\u0005M\u0013bAA+'\t\u0019\u0011J\u001c;\t\u000f\u0005e\u00131\na\u0001E\u0005\u00191.Z=\t\u0011\u0005u\u00131\na\u0001\u0003#\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bbBA1\u0001\u0011%\u00111M\u0001\faJ|G-^2fe\u000e\u00137\u000eF\u0004s\u0003K\nI'a\u001f\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003#\n1AY5e\u0011!\tY'a\u0018A\u0002\u00055\u0014\u0001\u00025pgR\u0004B!a\u001c\u0002v9\u0019!#!\u001d\n\u0007\u0005M4#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u001a\u0002\u0002CA?\u0003?\u0002\r!!\u0015\u0002\tA|'\u000f\u001e\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003\u0015\u0019Gn\\:f)\u0005\u0011x!CAD\u0005\u0005\u0005\tRAAE\u0003!\u0001&o\u001c3vG\u0016\u0014\bc\u0001\u000e\u0002\f\u001aI\u0011A\u0001C\u0002\u0002#\u0015\u0011QR\n\u0005\u0003\u0017K\u0011\u0003C\u0004<\u0003\u0017#\t!!%\u0015\u0005\u0005%\u0005BCAK\u0003\u0017\u000b\n\u0011\"\u0001\u0002\u0018\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012\"TCBAM\u0003[\u000byKK\u00028\u00037[#!!(\u0011\t\u0005}\u0015\u0011V\u0007\u0003\u0003CSA!a)\u0002&\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\u001b\u0012AC1o]>$\u0018\r^5p]&!\u00111VAQ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\nK\u0005ME\u0011!AC\u0002\u0019\"\u0011\u0002NAJ\t\u0003\u0005)\u0019\u0001\u0014")
public class Producer<K, V>
implements ScalaObject {
    private final Partitioner<K> partitioner;
    public final ProducerPool kafka$producer$Producer$$producerPool;
    private final boolean populateProducerPool;
    private final Logger kafka$producer$Producer$$logger;
    private final AtomicBoolean hasShutdown;
    private final Random kafka$producer$Producer$$random;
    private BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo;
    private final boolean kafka$producer$Producer$$zkEnabled;

    public static final boolean init$default$4() {
        return Producer$.MODULE$.init$default$4();
    }

    public final Logger kafka$producer$Producer$$logger() {
        return this.kafka$producer$Producer$$logger;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final Random kafka$producer$Producer$$random() {
        return this.kafka$producer$Producer$$random;
    }

    public final BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo() {
        return this.kafka$producer$Producer$$brokerPartitionInfo;
    }

    private void kafka$producer$Producer$$brokerPartitionInfo_$eq(BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
    }

    public final boolean kafka$producer$Producer$$zkEnabled() {
        return this.kafka$producer$Producer$$zkEnabled;
    }

    public Producer(ProducerConfig config) {
        this(config, (Partitioner)Utils$.MODULE$.getObject(config.partitionerClass()), new ProducerPool(config, (Encoder)Utils$.MODULE$.getObject(config.serializerClass())), Producer$.MODULE$.init$default$4());
    }

    public Producer(ProducerConfig config, Encoder<V> encoder, EventHandler<V> eventHandler, CallbackHandler<V> cbkHandler, Partitioner<K> partitioner) {
        this(config, partitioner == null ? new DefaultPartitioner() : partitioner, new ProducerPool<V>(config, encoder, eventHandler, cbkHandler), Producer$.MODULE$.init$default$4());
    }

    public void send(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = (Seq)producerData.map((Function1)new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    /*
     * WARNING - void declaration
     */
    public final int kafka$producer$Producer$$getPartition(Object key, int numPartitions) {
        void var3_3;
        int partition;
        if (numPartitions <= 0) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid number of partitions: ").append((Object)BoxesRunTime.boxToInteger((int)numPartitions)).append((Object)"\n Valid values are > 0").toString());
        }
        int n = partition = key == null ? this.kafka$producer$Producer$$random().nextInt(numPartitions) : this.partitioner.partition(key, numPartitions);
        if (partition < 0 || partition >= numPartitions) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid partition id : ").append((Object)BoxesRunTime.boxToInteger((int)partition)).append((Object)"\n Valid values are in the range inclusive [0, ").append((Object)BoxesRunTime.boxToInteger((int)(numPartitions - 1))).append((Object)"]").toString());
        }
        return (int)var3_3;
    }

    public final void kafka$producer$Producer$$producerCbk(int bid, String host, int port) {
        if (this.populateProducerPool) {
            this.kafka$producer$Producer$$producerPool.addProducer(new Broker(bid, host, host, port));
        } else {
            this.kafka$producer$Producer$$logger().debug((Object)"Skipping the callback since populateProducerPool = false");
        }
    }

    public void close() {
        boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
        if (canShutdown) {
            this.kafka$producer$Producer$$producerPool.close();
            this.kafka$producer$Producer$$brokerPartitionInfo().close();
        }
    }

    public Producer(ProducerConfig config, Partitioner<K> partitioner, ProducerPool<V> producerPool, boolean populateProducerPool) {
        block4: {
            boolean bl;
            block7: {
                block6: {
                    block5: {
                        this.partitioner = partitioner;
                        this.kafka$producer$Producer$$producerPool = producerPool;
                        this.populateProducerPool = populateProducerPool;
                        this.kafka$producer$Producer$$logger = Logger.getLogger(Producer.class);
                        this.hasShutdown = new AtomicBoolean(false);
                        if (!Utils$.MODULE$.propertyExists(config.zkConnect()) && !Utils$.MODULE$.propertyExists(config.brokerPartitionInfo())) break block4;
                        this.kafka$producer$Producer$$random = new Random();
                        this.kafka$producer$Producer$$brokerPartitionInfo = null;
                        this.kafka$producer$Producer$$zkEnabled = Utils$.MODULE$.propertyExists(config.zkConnect());
                        bl = this.kafka$producer$Producer$$zkEnabled();
                        if (!bl) break block5;
                        Properties zkProps = new Properties();
                        zkProps.put("zk.connect", config.zkConnect());
                        zkProps.put("zk.sessiontimeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.zkSessionTimeoutMs())).toString());
                        zkProps.put("zk.connectiontimeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.zkConnectionTimeoutMs())).toString());
                        zkProps.put("zk.synctime.ms", ((Object)BoxesRunTime.boxToInteger((int)config.zkSyncTimeMs())).toString());
                        this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ZKBrokerPartitionInfo(new ZKConfig(zkProps), (Function3<Integer, String, Integer, Object>)new $anonfun$1(this)));
                        break block6;
                    }
                    if (bl) break block7;
                    this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ConfigBrokerPartitionInfo(config));
                }
                if (populateProducerPool) {
                    Map<Integer, Broker> allBrokers = this.kafka$producer$Producer$$brokerPartitionInfo().getAllBrokerInfo();
                    allBrokers.foreach((Function1)new $anonfun$2(this));
                }
                return;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new InvalidConfigException("At least one of zk.connect or broker.list must be specified");
    }
}

