/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Date;
import java.util.Properties;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.producer.SyncProducer;
import kafka.producer.SyncProducerConfig;
import kafka.producer.async.MissingConfigException;
import kafka.serializer.Encoder;
import kafka.utils.Utils$;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003%-\u000bgm[1M_\u001e$$.\u00119qK:$WM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006Y><GG\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\t\u0001\u0012\t\u001d9f]\u0012,'oU6fY\u0016$xN\u001c\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001a\u0001\n\u0003y\u0012\u0001\u00029peR,\u0012\u0001\t\t\u0003'\u0005J!A\t\u000b\u0003\u0007%sG\u000fC\u0004%\u0001\u0001\u0007I\u0011A\u0013\u0002\u0011A|'\u000f^0%KF$\"AJ\u0015\u0011\u0005M9\u0013B\u0001\u0015\u0015\u0005\u0011)f.\u001b;\t\u000f)\u001a\u0013\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\r1\u0002\u0001\u0015)\u0003!\u0003\u0015\u0001xN\u001d;!\u0011\u001dq\u0003\u00011A\u0005\u0002=\nA\u0001[8tiV\t\u0001\u0007\u0005\u00022i9\u00111CM\u0005\u0003gQ\ta\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111\u0007\u0006\u0005\bq\u0001\u0001\r\u0011\"\u0001:\u0003!Awn\u001d;`I\u0015\fHC\u0001\u0014;\u0011\u001dQs'!AA\u0002ABa\u0001\u0010\u0001!B\u0013\u0001\u0014!\u00025pgR\u0004\u0003b\u0002 \u0001\u0001\u0004%\taL\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u0003%!x\u000e]5d?\u0012*\u0017\u000f\u0006\u0002'\u0005\"9!fPA\u0001\u0002\u0004\u0001\u0004B\u0002#\u0001A\u0003&\u0001'\u0001\u0004u_BL7\r\t\u0005\b\r\u0002\u0001\r\u0011\"\u00010\u00031)gnY8eKJ\u001cE.Y:t\u0011\u001dA\u0005\u00011A\u0005\u0002%\u000b\u0001#\u001a8d_\u0012,'o\u00117bgN|F%Z9\u0015\u0005\u0019R\u0005b\u0002\u0016H\u0003\u0003\u0005\r\u0001\r\u0005\u0007\u0019\u0002\u0001\u000b\u0015\u0002\u0019\u0002\u001b\u0015t7m\u001c3fe\u000ec\u0017m]:!\u0011\u001d\u0019\u0001\u00011A\u0005\n9+\u0012a\u0014\t\u00039AK!!\u0015\u0002\u0003\u0019MKhn\u0019)s_\u0012,8-\u001a:\t\u000fM\u0003\u0001\u0019!C\u0005)\u0006a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u0011a%\u0016\u0005\bUI\u000b\t\u00111\u0001P\u0011\u00199\u0006\u0001)Q\u0005\u001f\u0006I\u0001O]8ek\u000e,'\u000f\t\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0003\u0019awnZ4feV\t1\f\u0005\u0002\n9&\u0011QL\u0003\u0002\u0007\u0019><w-\u001a:\t\r}\u0003\u0001\u0015!\u0003\\\u0003\u001dawnZ4fe\u0002Bq!\u0019\u0001A\u0002\u0013%!-A\u0004f]\u000e|G-\u001a:\u0016\u0003\r\u00042\u0001Z4j\u001b\u0005)'B\u00014\u0005\u0003)\u0019XM]5bY&TXM]\u0005\u0003Q\u0016\u0014q!\u00128d_\u0012,'\u000f\u0005\u0002\u0014U&\u00111\u000e\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000f5\u0004\u0001\u0019!C\u0005]\u0006YQM\\2pI\u0016\u0014x\fJ3r)\t1s\u000eC\u0004+Y\u0006\u0005\t\u0019A2\t\rE\u0004\u0001\u0015)\u0003d\u0003!)gnY8eKJ\u0004\u0003\"B:\u0001\t\u0003y\u0012aB4fiB{'\u000f\u001e\u0005\u0006k\u0002!\tA^\u0001\bg\u0016$\bk\u001c:u)\t1s\u000fC\u0003\u001fi\u0002\u0007\u0001\u0005C\u0003z\u0001\u0011\u0005q&A\u0004hKRDun\u001d;\t\u000bm\u0004A\u0011\u0001?\u0002\u000fM,G\u000fS8tiR\u0011a% \u0005\u0006]i\u0004\r\u0001\r\u0005\u0006\u007f\u0002!\taL\u0001\tO\u0016$Hk\u001c9jG\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011\u0001C:fiR{\u0007/[2\u0015\u0007\u0019\n9\u0001\u0003\u0004?\u0003\u0003\u0001\r\u0001\r\u0005\u0007\u0003\u0017\u0001A\u0011A\u0018\u0002\u0015\u001d,G/\u00128d_\u0012,'\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u0015M,G/\u00128d_\u0012,'\u000fF\u0002'\u0003'Aa!YA\u0007\u0001\u0004\u0001\u0004bBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\u0010C\u000e$\u0018N^1uK>\u0003H/[8ogR\ta\u0005C\u0004\u0002\u001e\u0001!\t%a\b\u0002\r\u0005\u0004\b/\u001a8e)\r1\u0013\u0011\u0005\u0005\t\u0003G\tY\u00021\u0001\u0002&\u0005)QM^3oiB!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,)\t1a\u001d9j\u0013\u0011\ty#!\u000b\u0003\u00191{wmZ5oO\u00163XM\u001c;\t\u000f\u0005M\u0002\u0001\"\u0011\u0002\u001a\u0005)1\r\\8tK\"9\u0011q\u0007\u0001\u0005B\u0005e\u0012A\u0004:fcVL'/Z:MCf|W\u000f\u001e\u000b\u0003\u0003w\u00012aEA\u001f\u0013\r\ty\u0004\u0006\u0002\b\u0005>|G.Z1o\u0001")
public class KafkaLog4jAppender
extends AppenderSkeleton
implements ScalaObject {
    private int port = 0;
    private String host = null;
    private String topic = null;
    private String encoderClass = null;
    private SyncProducer producer = null;
    private final Logger logger = Logger.getLogger(KafkaLog4jAppender.class);
    private Encoder<Object> encoder = null;

    public int port() {
        return this.port;
    }

    public void port_$eq(int n) {
        this.port = n;
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String string) {
        this.host = string;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String string) {
        this.topic = string;
    }

    public String encoderClass() {
        return this.encoderClass;
    }

    public void encoderClass_$eq(String string) {
        this.encoderClass = string;
    }

    private SyncProducer producer() {
        return this.producer;
    }

    private void producer_$eq(SyncProducer syncProducer) {
        this.producer = syncProducer;
    }

    private Logger logger() {
        return this.logger;
    }

    private Encoder<Object> encoder() {
        return this.encoder;
    }

    private void encoder_$eq(Encoder<Object> encoder) {
        this.encoder = encoder;
    }

    public int getPort() {
        return this.port();
    }

    public void setPort(int port) {
        this.port_$eq(port);
    }

    public String getHost() {
        return this.host();
    }

    public void setHost(String host) {
        this.host_$eq(host);
    }

    public String getTopic() {
        return this.topic();
    }

    public void setTopic(String topic) {
        this.topic_$eq(topic);
    }

    public String getEncoder() {
        return this.encoderClass();
    }

    public void setEncoder(String encoder) {
        this.encoderClass_$eq(encoder);
    }

    public void activateOptions() {
        if (this.host() == null) {
            throw new MissingConfigException("Broker Host must be specified by the Kafka log4j appender");
        }
        if (this.port() == 0) {
            throw new MissingConfigException("Broker Port must be specified by the Kafka log4j appender");
        }
        if (this.topic() == null) {
            throw new MissingConfigException("topic must be specified by the Kafka log4j appender");
        }
        if (this.encoderClass() == null) {
            this.logger().info((Object)"Using default encoder - kafka.producer.DefaultStringEncoder");
            this.encoder_$eq((Encoder)Utils$.MODULE$.getObject("kafka.producer.DefaultStringEncoder"));
        } else {
            this.encoder_$eq((Encoder)Utils$.MODULE$.getObject(this.encoderClass()));
        }
        Properties props = new Properties();
        props.put("host", this.host());
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        this.producer_$eq(new SyncProducer(new SyncProducerConfig(props)));
        this.logger().info((Object)new StringBuilder().append((Object)"Kafka producer connected to ").append((Object)this.host()).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        this.logger().info((Object)new StringBuilder().append((Object)"Logging for topic: ").append((Object)this.topic()).toString());
    }

    public void append(LoggingEvent event) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)new StringBuilder().append((Object)"[").append((Object)new Date(event.getTimeStamp()).toString()).append((Object)"]").append((Object)event.getRenderedMessage()).append((Object)" for ").append((Object)this.host()).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        }
        Message message = this.encoder().toMessage(event);
        this.producer().send(this.topic(), new ByteBufferMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message})));
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.producer().close();
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

