/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import kafka.message.Message$;
import kafka.utils.Utils$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055q!B\u0001\u0003\u0011\u000b9\u0011aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tq!\\3tg\u0006<WMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1\u0001B\u0003\u0002\u0005\u0002\u0003E)a\u0003\u0002\b\u001b\u0016\u001c8/Y4f'\rIA\u0002\u0006\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u\u0011\u0015Y\u0012\u0002\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u001f\u0013\t\u0007I\u0011A\u0010\u0002#\r+(O]3oi6\u000bw-[2WC2,X-F\u0001!!\t)\u0012%\u0003\u0002#-\t!!)\u001f;f\u0011\u0019!\u0013\u0002)A\u0005A\u0005\u00112)\u001e:sK:$X*Y4jGZ\u000bG.^3!\u0011\u001d1\u0013B1A\u0005\u0002\u001d\n1\"T1hS\u000e|eMZ:fiV\t\u0001\u0006\u0005\u0002\u0016S%\u0011!F\u0006\u0002\u0004\u0013:$\bB\u0002\u0017\nA\u0003%\u0001&\u0001\u0007NC\u001eL7m\u00144gg\u0016$\b\u0005C\u0004/\u0013\t\u0007I\u0011A\u0014\u0002\u00175\u000bw-[2MK:<G\u000f\u001b\u0005\u0007a%\u0001\u000b\u0011\u0002\u0015\u0002\u00195\u000bw-[2MK:<G\u000f\u001b\u0011\t\u000fIJ!\u0019!C\u0001O\u0005I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007i%\u0001\u000b\u0011\u0002\u0015\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u00047\u0013\t\u0007I\u0011A\u0014\u0002\u0013\r\u00138\rT3oORD\u0007B\u0002\u001d\nA\u0003%\u0001&\u0001\u0006De\u000edUM\\4uQ\u0002BqAO\u0005C\u0002\u0013\u0005q%A\u0007QCfdw.\u00193PM\u001a\u001cX\r\u001e\u0005\u0007y%\u0001\u000b\u0011\u0002\u0015\u0002\u001dA\u000b\u0017\u0010\\8bI>3gm]3uA!9a(\u0003b\u0001\n\u00039\u0013A\u0003%fC\u0012,'oU5{K\"1\u0001)\u0003Q\u0001\n!\n1\u0002S3bI\u0016\u00148+\u001b>fA\u0019A!B\u0001C\u0001\u0002\u0003\u0005!iE\u0002B\u0019QA\u0001\u0002R!\u0003\u0006\u0004%\t!R\u0001\u0007EV4g-\u001a:\u0016\u0003\u0019\u0003\"a\u0012&\u000e\u0003!S!!\u0013\t\u0002\u00079Lw.\u0003\u0002L\u0011\nQ!)\u001f;f\u0005V4g-\u001a:\t\u00115\u000b%\u0011!Q\u0001\n\u0019\u000bqAY;gM\u0016\u0014\b\u0005C\u0003\u001c\u0003\u0012\u0005q\n\u0006\u0002Q#B\u0011\u0001\"\u0011\u0005\u0006\t:\u0003\rA\u0012\u0005\u00067\u0005#\ta\u0015\u000b\u0004!RK\u0006\"B+S\u0001\u00041\u0016\u0001C2iK\u000e\\7/^7\u0011\u0005U9\u0016B\u0001-\u0017\u0005\u0011auN\\4\t\u000bi\u0013\u0006\u0019A.\u0002\u000b\tLH/Z:\u0011\u0007Ua\u0006%\u0003\u0002^-\t)\u0011I\u001d:bs\")1$\u0011C\u0001?R\u0011\u0001\u000b\u0019\u0005\u00065z\u0003\ra\u0017\u0005\u0006E\u0006#\taJ\u0001\u0005g&TX\rC\u0003e\u0003\u0012\u0005q%A\u0006qCfdw.\u00193TSj,\u0007\"\u00024B\t\u0003y\u0012!B7bO&\u001c\u0007\"B+B\t\u0003AW#\u0001,\t\u000b)\fE\u0011A#\u0002\u000fA\f\u0017\u0010\\8bI\")A.\u0011C\u0001[\u00069\u0011n\u001d,bY&$W#\u00018\u0011\u0005Uy\u0017B\u00019\u0017\u0005\u001d\u0011un\u001c7fC:DQA]!\u0005BM\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002iB\u0011Q\u000f\u001f\b\u0003+YL!a\u001e\f\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003oZAQ\u0001`!\u0005Bu\fa!Z9vC2\u001cHC\u00018\u007f\u0011\u0019y8\u00101\u0001\u0002\u0002\u0005\u0019\u0011M\\=\u0011\u0007U\t\u0019!C\u0002\u0002\u0006Y\u00111!\u00118z\u0011\u001d\tI!\u0011C!\u0003\u0017\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002Q\u0001")
public class Message
implements ScalaObject {
    private final ByteBuffer buffer;

    public static final int HeaderSize() {
        return Message$.MODULE$.HeaderSize();
    }

    public static final int PayloadOffset() {
        return Message$.MODULE$.PayloadOffset();
    }

    public static final int CrcLength() {
        return Message$.MODULE$.CrcLength();
    }

    public static final int CrcOffset() {
        return Message$.MODULE$.CrcOffset();
    }

    public static final int MagicLength() {
        return Message$.MODULE$.MagicLength();
    }

    public static final int MagicOffset() {
        return Message$.MODULE$.MagicOffset();
    }

    public static final byte CurrentMagicValue() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public Message(long checksum, byte[] bytes) {
        this(ByteBuffer.allocate(Message$.MODULE$.HeaderSize() + bytes.length));
        this.buffer().put(Message$.MODULE$.CurrentMagicValue());
        Utils$.MODULE$.putUnsignedInt(this.buffer(), checksum);
        this.buffer().put(bytes);
        this.buffer().rewind();
    }

    public Message(byte[] bytes) {
        this(Utils$.MODULE$.crc32(bytes), bytes);
    }

    public int size() {
        return this.buffer().limit();
    }

    public int payloadSize() {
        return this.size() - Message$.MODULE$.HeaderSize();
    }

    public byte magic() {
        return this.buffer().get(Message$.MODULE$.MagicOffset());
    }

    public long checksum() {
        return Utils$.MODULE$.getUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset());
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer payload() {
        void var1_1;
        ByteBuffer payload = this.buffer().duplicate();
        payload.position(Message$.MODULE$.HeaderSize());
        payload = payload.slice();
        payload.limit(this.payloadSize());
        payload.rewind();
        return var1_1;
    }

    public boolean isValid() {
        return this.checksum() == Utils$.MODULE$.crc32(this.buffer().array(), this.buffer().position() + this.buffer().arrayOffset() + Message$.MODULE$.PayloadOffset(), this.payloadSize());
    }

    public String toString() {
        return new StringBuilder().append((Object)"message(magic = ").append((Object)BoxesRunTime.boxToByte((byte)this.magic())).append((Object)", crc = ").append((Object)BoxesRunTime.boxToLong((long)this.checksum())).append((Object)", payload = ").append((Object)this.payload()).append((Object)")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object any) {
        Message message;
        Object object = any;
        if (!(object instanceof Message)) return false;
        Message that = message = (Message)object;
        if (this.size() != that.size()) return false;
        if (this.checksum() != that.checksum()) return false;
        ByteBuffer byteBuffer = this.payload();
        ByteBuffer byteBuffer2 = that.payload();
        if (byteBuffer == null) {
            if (byteBuffer2 != null) {
                return false;
            }
        } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
        if (this.magic() != that.magic()) return false;
        return true;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public Message(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

