/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.FileMessageSet$;
import kafka.message.LogFlushStats$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageSet;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001d\u0019KG.Z'fgN\fw-Z*fi*\u00111\u0001B\u0001\b[\u0016\u001c8/Y4f\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005)iUm]:bO\u0016\u001cV\r\u001e\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0005\u0014\u0001\t\u0015\r\u0011\"\u0001\u0003)\u000591\r[1o]\u0016dW#A\u000b\u0011\u0005YiR\"A\f\u000b\u0005aI\u0012\u0001C2iC:tW\r\\:\u000b\u0005iY\u0012a\u00018j_*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u0018\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\t\u0011\u0001\u0002!\u0011!Q\u0001\nU\t\u0001b\u00195b]:,G\u000e\t\u0005\nE\u0001\u0011)\u0019!C\u0001\u0005\r\naa\u001c4gg\u0016$X#\u0001\u0013\u0011\u00055)\u0013B\u0001\u0014\u000f\u0005\u0011auN\\4\t\u0011!\u0002!\u0011!Q\u0001\n\u0011\nqa\u001c4gg\u0016$\b\u0005C\u0005+\u0001\t\u0015\r\u0011\"\u0001\u0003G\u0005)A.[7ji\"AA\u0006\u0001B\u0001B\u0003%A%\u0001\u0004mS6LG\u000f\t\u0005\t]\u0001\u0011)\u0019!C\u0001_\u00059Q.\u001e;bE2,W#\u0001\u0019\u0011\u00055\t\u0014B\u0001\u001a\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\t[V$\u0018M\u00197fA!Aa\u0007\u0001BC\u0002\u0013\u0005q'A\u0006oK\u0016$'+Z2pm\u0016\u0014X#\u0001\u001d\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014AB1u_6L7M\u0003\u0002>}\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}Z\u0012\u0001B;uS2L!!\u0011\u001e\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011!\u0019\u0005A!A!\u0002\u0013A\u0014\u0001\u00048fK\u0012\u0014VmY8wKJ\u0004\u0003BB#\u0001\t\u0003!a)\u0001\u0004=S:LGO\u0010\u000b\u0007\u000f\"K%j\u0013'\u0011\u0005%\u0001\u0001\"B\nE\u0001\u0004)\u0002\"\u0002\u0012E\u0001\u0004!\u0003\"\u0002\u0016E\u0001\u0004!\u0003\"\u0002\u0018E\u0001\u0004\u0001\u0004\"\u0002\u001cE\u0001\u0004A\u0004b\u0002(\u0001\u0005\u0004%IaT\u0001\bg\u0016$8+\u001b>f+\u0005\u0001\u0006CA\u001dR\u0013\t\u0011&H\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa\u0001\u0016\u0001!\u0002\u0013\u0001\u0016\u0001C:fiNK'0\u001a\u0011\t\u000fY\u0003!\u0019!C\u0005\u001f\u0006\u00012/\u001a;IS\u001eDw+\u0019;fe6\u000b'o\u001b\u0005\u00071\u0002\u0001\u000b\u0011\u0002)\u0002#M,G\u000fS5hQ^\u000bG/\u001a:NCJ\\\u0007\u0005C\u0004[\u0001\t\u0007I\u0011B.\u0002\r1|wmZ3s+\u0005a\u0006CA/e\u001b\u0005q&BA0a\u0003\u0015awn\u001a\u001bk\u0015\t\t'-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0006\u0019qN]4\n\u0005\u0015t&A\u0002'pO\u001e,'\u000f\u0003\u0004h\u0001\u0001\u0006I\u0001X\u0001\bY><w-\u001a:!\u0011\u0015)\u0005\u0001\"\u0001j)\r9%n\u001b\u0005\u0006'!\u0004\r!\u0006\u0005\u0006]!\u0004\r\u0001\r\u0005\u0006\u000b\u0002!\t!\u001c\u000b\u0004\u000f:4\b\"B8m\u0001\u0004\u0001\u0018\u0001\u00024jY\u0016\u0004\"!\u001d;\u000e\u0003IT!a]\u000e\u0002\u0005%|\u0017BA;s\u0005\u00111\u0015\u000e\\3\t\u000b9b\u0007\u0019\u0001\u0019\t\u000b\u0015\u0003A\u0011\u0001=\u0015\t\u001dK(p\u001f\u0005\u0006']\u0004\r!\u0006\u0005\u0006]]\u0004\r\u0001\r\u0005\u0006m]\u0004\r\u0001\u000f\u0005\u0006\u000b\u0002!\t! \u000b\u0006\u000fz|\u0018\u0011\u0001\u0005\u0006_r\u0004\r\u0001\u001d\u0005\u0006]q\u0004\r\u0001\r\u0005\u0006mq\u0004\r\u0001\u000f\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003\u0011\u0011X-\u00193\u0015\u000b!\tI!!\u0004\t\u000f\u0005-\u00111\u0001a\u0001I\u0005Q!/Z1e\u001f\u001a47/\u001a;\t\u000f\u0005=\u00111\u0001a\u0001I\u0005!1/\u001b>f\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\tqa\u001e:ji\u0016$v\u000eF\u0004%\u0003/\t\t#!\n\t\u0011\u0005e\u0011\u0011\u0003a\u0001\u00037\t1\u0002Z3ti\u000eC\u0017M\u001c8fYB\u0019a#!\b\n\u0007\u0005}qCA\nXe&$\u0018M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0004\u0002$\u0005E\u0001\u0019\u0001\u0013\u0002\u0017]\u0014\u0018\u000e^3PM\u001a\u001cX\r\u001e\u0005\b\u0003\u001f\t\t\u00021\u0001%\u0011\u001d\tI\u0003\u0001C!\u0003W\t\u0001\"\u001b;fe\u0006$xN]\u000b\u0003\u0003[\u0001b!a\f\u0002@\u0005\u0015c\u0002BA\u0019\u0003wqA!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o1\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\tiDD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t%a\u0011\u0003\u0011%#XM]1u_JT1!!\u0010\u000f!\rI\u0011qI\u0005\u0004\u0003\u0013\u0012!aB'fgN\fw-\u001a\u0005\b\u0003\u001b\u0002A\u0011AA(\u0003-\u0019\u0018N_3J]\nKH/Z:\u0015\u0003\u0011Bq!a\u0015\u0001\t\u0003\ty%A\u0007iS\u001eDw+\u0019;fe6\u000b'o\u001b\u0005\b\u0003/\u0002A\u0011AA-\u00031\u0019\u0007.Z2l\u001bV$\u0018M\u00197f)\t\tY\u0006E\u0002\u000e\u0003;J1!a\u0018\u000f\u0005\u0011)f.\u001b;\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f\u00051\u0011\r\u001d9f]\u0012$B!a\u0017\u0002h!9\u0011\u0011NA1\u0001\u0004A\u0011\u0001C7fgN\fw-Z:\t\u000f\u00055\u0004\u0001\"\u0001\u0002Z\u0005)a\r\\;tQ\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005e\u0013!B2m_N,\u0007bBA;\u0001\u0011\u0005\u0011qJ\u0001\be\u0016\u001cwN^3s\u0011\u001d\tI\b\u0001C\u0005\u0003w\nqB^1mS\u0012\fG/Z'fgN\fw-\u001a\u000b\nI\u0005u\u0014qPAB\u0003\u000fCaaEA<\u0001\u0004)\u0002bBAA\u0003o\u0002\r\u0001J\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0003\u000b\u000b9\b1\u0001%\u0003\raWM\u001c\u0005\t\u0003\u0013\u000b9\b1\u0001\u0002\f\u00061!-\u001e4gKJ\u0004B!!$\u0002\u00106\t\u0011$C\u0002\u0002\u0012f\u0011!BQ=uK\n+hMZ3sQ\r\u0001\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005}\u0015\u0011\u0014\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class FileMessageSet
extends MessageSet
implements ScalaObject {
    private final FileChannel channel;
    private final long offset;
    private final long limit;
    private final boolean mutable;
    private final AtomicBoolean needRecover;
    private final AtomicLong setSize;
    private final AtomicLong setHighWaterMark;
    private final Logger logger;

    public FileChannel channel() {
        return this.channel;
    }

    public long offset() {
        return this.offset;
    }

    public long limit() {
        return this.limit;
    }

    public boolean mutable() {
        return this.mutable;
    }

    public AtomicBoolean needRecover() {
        return this.needRecover;
    }

    private AtomicLong setSize() {
        return this.setSize;
    }

    private AtomicLong setHighWaterMark() {
        return this.setHighWaterMark;
    }

    private Logger logger() {
        return this.logger;
    }

    public FileMessageSet(FileChannel channel, boolean mutable) {
        this(channel, 0L, Long.MAX_VALUE, mutable, new AtomicBoolean(false));
    }

    public FileMessageSet(File file, boolean mutable) {
        this(Utils$.MODULE$.openChannel(file, mutable), mutable);
    }

    public FileMessageSet(FileChannel channel, boolean mutable, AtomicBoolean needRecover) {
        this(channel, 0L, Long.MAX_VALUE, mutable, needRecover);
    }

    public FileMessageSet(File file, boolean mutable, AtomicBoolean needRecover) {
        this(Utils$.MODULE$.openChannel(file, mutable), mutable, needRecover);
    }

    public MessageSet read(long readOffset, long size2) {
        return new FileMessageSet(this.channel(), this.offset() + readOffset, package$.MODULE$.min(this.offset() + readOffset + size2, this.highWaterMark()), false, new AtomicBoolean(false));
    }

    @Override
    public long writeTo(WritableByteChannel destChannel, long writeOffset, long size2) {
        return this.channel().transferTo(this.offset() + writeOffset, package$.MODULE$.min(size2, this.sizeInBytes()), destChannel);
    }

    @Override
    public Iterator<Message> iterator() {
        return new $anon$1(this);
    }

    @Override
    public long sizeInBytes() {
        return this.setSize().get();
    }

    public long highWaterMark() {
        return this.setHighWaterMark().get();
    }

    public void checkMutable() {
        if (this.mutable()) {
            return;
        }
        throw new IllegalStateException("Attempt to invoke mutation on immutable message set.");
    }

    public void append(MessageSet messages) {
        long written;
        this.checkMutable();
        for (written = 0L; written < messages.sizeInBytes(); written += messages.writeTo(this.channel(), 0L, messages.sizeInBytes())) {
        }
        this.setSize().getAndAdd(written);
    }

    public void flush() {
        this.checkMutable();
        long startTime = SystemTime$.MODULE$.milliseconds();
        this.channel().force(true);
        long elapsedTime = SystemTime$.MODULE$.milliseconds() - startTime;
        LogFlushStats$.MODULE$.recordFlushRequest(elapsedTime);
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)new StringBuilder().append((Object)"flush time ").append((Object)BoxesRunTime.boxToLong((long)elapsedTime)).toString());
        }
        this.setHighWaterMark().set(this.sizeInBytes());
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)new StringBuilder().append((Object)"flush high water mark:").append((Object)BoxesRunTime.boxToLong((long)this.highWaterMark())).toString());
        }
    }

    public void close() {
        if (this.mutable()) {
            this.flush();
        }
        this.channel().close();
    }

    public long recover() {
        this.checkMutable();
        long len = this.channel().size();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        long validUpTo = 0L;
        long next = 0L;
        do {
            if ((next = this.validateMessage(this.channel(), validUpTo, len, buffer)) < 0L) continue;
            validUpTo = next;
        } while (next >= 0L);
        this.channel().truncate(validUpTo);
        this.setSize().set(validUpTo);
        this.setHighWaterMark().set(validUpTo);
        if (this.logger().isDebugEnabled()) {
            this.logger().info((Object)new StringBuilder().append((Object)"recover high water mark:").append((Object)BoxesRunTime.boxToLong((long)this.highWaterMark())).toString());
        }
        this.channel().position(validUpTo);
        this.needRecover().set(false);
        return len - validUpTo;
    }

    private long validateMessage(FileChannel channel, long start, long len, ByteBuffer buffer) {
        buffer.rewind();
        int read2 = channel.read(buffer, start);
        if (read2 < 4) {
            return -1L;
        }
        int size2 = buffer.getInt(0);
        if (size2 < Message$.MODULE$.HeaderSize()) {
            return -1L;
        }
        long next = start + 4L + (long)size2;
        if (next > len) {
            return -1L;
        }
        ByteBuffer messageBuffer = ByteBuffer.allocate(size2);
        long curr = start + 4L;
        while (messageBuffer.hasRemaining()) {
            read2 = channel.read(messageBuffer, curr);
            if (read2 < 0) {
                throw new IllegalStateException("File size changed during recovery!");
            }
            curr += (long)read2;
        }
        messageBuffer.rewind();
        Message message = new Message(messageBuffer);
        if (message.isValid()) {
            return next;
        }
        return -1L;
    }

    public FileMessageSet(FileChannel channel, long offset, long limit, boolean mutable, AtomicBoolean needRecover) {
        Object object;
        this.channel = channel;
        this.offset = offset;
        this.limit = limit;
        this.mutable = mutable;
        this.needRecover = needRecover;
        this.setSize = new AtomicLong();
        this.setHighWaterMark = new AtomicLong();
        this.logger = Logger.getLogger(FileMessageSet.class);
        if (mutable) {
            if (limit < Long.MAX_VALUE || offset > 0L) {
                throw new IllegalArgumentException("Attempt to open a mutable message set with a view or offset, which is not allowed.");
            }
            if (needRecover.get()) {
                long startMs = System.currentTimeMillis();
                long truncated = this.recover();
                this.logger().info((Object)new StringBuilder().append((Object)"Recovery succeeded in ").append((Object)BoxesRunTime.boxToLong((long)((System.currentTimeMillis() - startMs) / 1000L))).append((Object)" seconds. ").append((Object)BoxesRunTime.boxToLong((long)truncated)).append((Object)" bytes truncated.").toString());
                object = BoxedUnit.UNIT;
            } else {
                this.setSize().set(channel.size());
                this.setHighWaterMark().set(this.sizeInBytes());
                object = channel.position(channel.size());
            }
        } else {
            this.setSize().set(package$.MODULE$.min(channel.size(), limit) - offset);
            this.setHighWaterMark().set(this.sizeInBytes());
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"initializing high water mark in immutable mode: ").append((Object)BoxesRunTime.boxToLong((long)this.highWaterMark())).toString());
            }
            object = BoxedUnit.UNIT;
        }
    }
}

