/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.log.Log$;
import kafka.log.LogSegment;
import kafka.log.LogStats;
import kafka.log.SegmentList;
import kafka.message.FileMessageSet;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Range;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t=sAB\u0001\u0003\u0011\u000b\u0011a!A\u0002M_\u001eT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b!\t9\u0001\"D\u0001\u0003\r%I!\u0001\"A\u0001\u0012\u000b\u0011!BA\u0002M_\u001e\u001c2\u0001C\u0006\u0014!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\bC\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aC*dC2\fwJ\u00196fGRDQA\u0007\u0005\u0005\u0002q\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002\r!9a\u0004\u0003b\u0001\n\u0003y\u0012a\u0003$J\u0019\u0016{6+\u0016$G\u0013b+\u0012\u0001\t\t\u0003\u0019\u0005J!AI\u0007\u0003\rM#(/\u001b8h\u0011\u0019!\u0003\u0002)A\u0005A\u0005aa)\u0013'F?N+fIR%YA!)a\u0005\u0003C\u0001O\u0005Ia-\u001b8e%\u0006tw-Z\u000b\u0003Q9\"B!\u000b\u001e@\tB\u0019AC\u000b\u0017\n\u0005-*\"AB(qi&|g\u000e\u0005\u0002.]1\u0001A\u0001C\u0018&\t\u0003\u0005)\u0019\u0001\u0019\u0003\u0003Q\u000b\"!\r\u001b\u0011\u0005Q\u0011\u0014BA\u001a\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005e2$!\u0002*b]\u001e,\u0007\"B\u001e&\u0001\u0004a\u0014A\u0002:b]\u001e,7\u000fE\u0002\u0015{1J!AP\u000b\u0003\u000b\u0005\u0013(/Y=\t\u000b\u0001+\u0003\u0019A!\u0002\u000bY\fG.^3\u0011\u0005Q\u0011\u0015BA\"\u0016\u0005\u0011auN\\4\t\u000b\u0015+\u0003\u0019\u0001$\u0002\u0013\u0005\u0014(/Y=TSj,\u0007C\u0001\u000bH\u0013\tAUCA\u0002J]RDQA\n\u0005\u0005\u0002)+\"a\u0013(\u0015\u00071{\u0015\u000bE\u0002\u0015U5\u0003\"!\f(\u0005\u0011=JE\u0011!AC\u0002ABQaO%A\u0002A\u00032\u0001F\u001fN\u0011\u0015\u0001\u0015\n1\u0001B\u0011\u0015\u0019\u0006\u0002\"\u0001U\u00039q\u0017-\\3Ge>lwJ\u001a4tKR$\"!V.\u0011\u0005YKfB\u0001\u000bX\u0013\tAV#\u0001\u0004Qe\u0016$WMZ\u0005\u0003EiS!\u0001W\u000b\t\u000bq\u0013\u0006\u0019A!\u0002\r=4gm]3u\r%I!\u0001\"A\u0001\u0002\u0003\u0011alE\u0002^\u0017MA\u0001\u0002Y/\u0003\u0006\u0004%\t!Y\u0001\u0004I&\u0014X#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015|\u0011AA5p\u0013\t9GM\u0001\u0003GS2,\u0007\u0002C5^\u0005\u0003\u0005\u000b\u0011\u00022\u0002\t\u0011L'\u000f\t\u0005\tWv\u0013)\u0019!C\u0001Y\u00069Q.\u0019=TSj,W#A!\t\u00119l&\u0011!Q\u0001\n\u0005\u000b\u0001\"\\1y'&TX\r\t\u0005\tav\u0013)\u0019!C\u0001c\u0006ia\r\\;tQ&sG/\u001a:wC2,\u0012A\u0012\u0005\tgv\u0013\t\u0011)A\u0005\r\u0006qa\r\\;tQ&sG/\u001a:wC2\u0004\u0003\u0002C;^\u0005\u000b\u0007I\u0011\u0001<\u0002\u00199,W\r\u001a*fG>4XM]=\u0016\u0003]\u0004\"\u0001\u0006=\n\u0005e,\"a\u0002\"p_2,\u0017M\u001c\u0005\twv\u0013\t\u0011)A\u0005o\u0006ia.Z3e%\u0016\u001cwN^3ss\u0002BQAG/\u0005\u0002u$\u0002B`@\u0002\u0002\u0005\r\u0011Q\u0001\t\u0003\u000fuCQ\u0001\u0019?A\u0002\tDQa\u001b?A\u0002\u0005CQ\u0001\u001d?A\u0002\u0019CQ!\u001e?A\u0002]D\u0011\"!\u0003^\u0005\u0004%I!a\u0003\u0002\r1|wmZ3s+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005uQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u000b1|w\r\u000e6\u000b\t\u0005]\u0011\u0011D\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0011aA8sO&!\u0011qDA\t\u0005\u0019aunZ4fe\"A\u00111E/!\u0002\u0013\ti!A\u0004m_\u001e<WM\u001d\u0011\t\u0013\u0005\u001dRL1A\u0005\n\u0005%\u0012\u0001\u00027pG.,\u0012a\u0003\u0005\b\u0003[i\u0006\u0015!\u0003\f\u0003\u0015awnY6!\u0011%\t\t$\u0018b\u0001\n\u0013\t\u0019$A\u0005v]\u001adWo\u001d5fIV\u0011\u0011Q\u0007\t\u0005\u0003o\t)%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0019\tGo\\7jG*!\u0011qHA!\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u0007z\u0011\u0001B;uS2LA!a\u0012\u0002:\ti\u0011\t^8nS\u000eLe\u000e^3hKJD\u0001\"a\u0013^A\u0003%\u0011QG\u0001\u000bk:4G.^:iK\u0012\u0004\u0003\"CA(;\n\u0007I\u0011BA)\u0003=a\u0017m\u001d;gYV\u001c\b.\u001a3US6,WCAA*!\u0011\t9$!\u0016\n\t\u0005]\u0013\u0011\b\u0002\u000b\u0003R|W.[2M_:<\u0007\u0002CA.;\u0002\u0006I!a\u0015\u0002!1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016\u0004\u0003BCA0;\n\u0007I\u0011\u0001\u0002\u0002b\u0005A1/Z4nK:$8/\u0006\u0002\u0002dA)q!!\u001a\u0002j%\u0019\u0011q\r\u0002\u0003\u0017M+w-\\3oi2K7\u000f\u001e\t\u0004\u000f\u0005-\u0014bAA7\u0005\tQAj\\4TK\u001elWM\u001c;\t\u0011\u0005ET\f)A\u0005\u0003G\n\u0011b]3h[\u0016tGo\u001d\u0011\t\u0011\u0005UTL1A\u0005\u0002}\tAA\\1nK\"9\u0011\u0011P/!\u0002\u0013\u0001\u0013!\u00028b[\u0016\u0004\u0003\"CA?;\n\u0007I\u0011BA@\u0003!awnZ*uCR\u001cXCAAA!\r9\u00111Q\u0005\u0004\u0003\u000b\u0013!\u0001\u0003'pON#\u0018\r^:\t\u0011\u0005%U\f)A\u0005\u0003\u0003\u000b\u0011\u0002\\8h'R\fGo\u001d\u0011\t\u000f\u00055U\f\"\u0003\u0002\u0010\u0006aAn\\1e'\u0016<W.\u001a8ugR\u0011\u00111\r\u0005\b\u0003'kF\u0011BAK\u0003A1\u0018\r\\5eCR,7+Z4nK:$8\u000f\u0006\u0003\u0002\u0018\u0006u\u0005c\u0001\u000b\u0002\u001a&\u0019\u00111T\u000b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003?\n\t\n1\u0001\u0002 B1\u0011\u0011UAR\u0003Sj!!!\u0011\n\t\u0005\u0015\u0016\u0011\t\u0002\n\u0003J\u0014\u0018-\u001f'jgRDa!!+^\t\u0003\t\u0018\u0001\u00058v[\n,'o\u00144TK\u001elWM\u001c;t\u0011\u001d\ti+\u0018C\u0001\u0003_\u000bQa\u00197pg\u0016$\"!a&\t\u000f\u0005MV\f\"\u0001\u00026\u00061\u0011\r\u001d9f]\u0012$B!a&\u00028\"A\u0011\u0011XAY\u0001\u0004\tY,\u0001\u0005nKN\u001c\u0018mZ3t!\u0011\ti,a1\u000e\u0005\u0005}&bAAa\t\u00059Q.Z:tC\u001e,\u0017\u0002BAc\u0003\u007f\u0013!\"T3tg\u0006<WmU3u\u0011\u001d\tI-\u0018C\u0001\u0003\u0017\fAA]3bIR1\u00111XAg\u0003\u001fDa\u0001XAd\u0001\u0004\t\u0005bBAi\u0003\u000f\u0004\rAR\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005UW\f\"\u0001\u0002X\u0006\u0001R.\u0019:l\t\u0016dW\r^3e/\"LG.\u001a\u000b\u0005\u00033\f\t\u0010\u0005\u0004\u0002\\\u0006-\u0018\u0011\u000e\b\u0005\u0003;\f9O\u0004\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019oG\u0001\u0007yI|w\u000e\u001e \n\u0003YI1!!;\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LA!!<\u0002p\n\u00191+Z9\u000b\u0007\u0005%X\u0003\u0003\u0005\u0002t\u0006M\u0007\u0019AA{\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0004\u0015\u0003o\fIg^\u0005\u0004\u0003s,\"!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0019\ti0\u0018C\u0001Y\u0006!1/\u001b>f\u0011\u0019\u0011\t!\u0018C\u0001Y\u0006\u0001b.\u001a=u\u0003B\u0004XM\u001c3PM\u001a\u001cX\r\u001e\u0005\u0007\u0005\u000biF\u0011\u00017\u0002!\u001d,G\u000fS5hQ^\fG/\u001a:NCJ\\\u0007b\u0002B\u0005;\u0012%!1B\u0001\n[\u0006L(-\u001a*pY2$B!a&\u0003\u000e!A!q\u0002B\u0004\u0001\u0004\tI'A\u0004tK\u001elWM\u001c;\t\u000f\tMQ\f\"\u0001\u00020\u0006!!o\u001c7m\u0011\u001d\u00119\"\u0018C\u0005\u00053\t!\"\\1zE\u00164E.^:i)\u0011\t9Ja\u0007\t\u000f\tu!Q\u0003a\u0001\r\u0006\u0001b.^7cKJ|e-T3tg\u0006<Wm\u001d\u0005\b\u0005CiF\u0011AAX\u0003\u00151G.^:i\u0011\u001d\u0011)#\u0018C\u0001\u0005O\t\u0001cZ3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3\u0015\t\t%\"1\u0006\t\u0004)u\n\u0005\u0002\u0003B\u0017\u0005G\u0001\rAa\f\u0002\u000fI,\u0017/^3tiB!!\u0011\u0007B\u001c\u001b\t\u0011\u0019DC\u0002\u00036\u0011\t1!\u00199j\u0013\u0011\u0011IDa\r\u0003\u001b=3gm]3u%\u0016\fX/Z:u\u0011\u001d\u0011i$\u0018C\u0001\u0005\u007f\tAbZ3u)>\u0004\u0018n\u0019(b[\u0016$\u0012!\u0016\u0005\b\u0005\u0007jF\u0011\u0001B#\u0003I9W\r\u001e'bgR4E.^:iK\u0012$\u0016.\\3\u0015\u0003\u0005C3!\u0018B%!\r)$1J\u0005\u0004\u0005\u001b2$A\u0003;ie\u0016\fGm]1gK\u0002")
public class Log
implements ScalaObject {
    private final File dir;
    private final long maxSize;
    private final int flushInterval;
    private final boolean needRecovery;
    private final Logger logger;
    private final Object lock;
    private final AtomicInteger unflushed;
    private final AtomicLong lastflushedTime;
    private final SegmentList<LogSegment> segments;
    private final String name;
    private final LogStats logStats;

    public static final String nameFromOffset(long l) {
        return Log$.MODULE$.nameFromOffset(l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return Log$.MODULE$.findRange((Range[])TArray, l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        return Log$.MODULE$.findRange((Range[])TArray, l, n);
    }

    public static final String FILE_SUFFIX() {
        return Log$.MODULE$.FILE_SUFFIX();
    }

    public File dir() {
        return this.dir;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public boolean needRecovery() {
        return this.needRecovery;
    }

    private Logger logger() {
        return this.logger;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicInteger unflushed() {
        return this.unflushed;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public SegmentList<LogSegment> segments() {
        return this.segments;
    }

    public String name() {
        return this.name;
    }

    private LogStats logStats() {
        return this.logStats;
    }

    private SegmentList<LogSegment> loadSegments() {
        boolean bl;
        ArrayList<LogSegment> accum$1 = new ArrayList<LogSegment>();
        File[] ls = this.dir().listFiles();
        if (ls != null) {
            Predef$.MODULE$.refArrayOps((Object[])ls).withFilter((Function1)new $anonfun$loadSegments$1(this)).foreach((Function1)new $anonfun$loadSegments$2(this, accum$1));
        }
        if (accum$1.size() == 0) {
            File newFile = new File(this.dir(), Log$.MODULE$.nameFromOffset(0L));
            FileMessageSet set = new FileMessageSet(newFile, true);
            bl = accum$1.add(new LogSegment(newFile, set, 0L));
        } else {
            Collections.sort(accum$1, new $anon$1(this));
            this.validateSegments(accum$1);
            LogSegment last = accum$1.remove(accum$1.size() - 1);
            last.messageSet().close();
            this.logger().info((Object)new StringBuilder().append((Object)"Loading the last segment ").append((Object)last.file().getAbsolutePath()).append((Object)" in mutable mode, recovery ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.needRecovery())).toString());
            LogSegment mutable = new LogSegment(last.file(), new FileMessageSet(last.file(), true, new AtomicBoolean(this.needRecovery())), last.start());
            bl = accum$1.add(mutable);
        }
        return new SegmentList<LogSegment>((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray(accum$1.toArray((Object[])new LogSegment[accum$1.size()])), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
    }

    private void validateSegments(ArrayList<LogSegment> segments$1) {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.intWrapper(0).until(segments$1.size() - 1).foreach$mVc$sp((Function1)new $anonfun$validateSegments$1(this, segments$1));
            return;
        }
    }

    public int numberOfSegments() {
        return ((LogSegment[])this.segments().view()).length;
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foreach((Function1)new $anonfun$close$1(this));
            return;
        }
    }

    public void append(MessageSet messages) {
        IntRef numberOfMessages$1 = new IntRef(0);
        messages.foreach((Function1)new $anonfun$append$1(this, numberOfMessages$1));
        this.logStats().recordAppendedMessages(numberOfMessages$1.elem);
        Object object = this.lock();
        synchronized (object) {
            LogSegment segment = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            segment.messageSet().append(messages);
            this.maybeFlush(numberOfMessages$1.elem);
            this.maybeRoll(segment);
            return;
        }
    }

    public MessageSet read(long offset, int length) {
        MessageSet messageSet;
        LogSegment[] view = (LogSegment[])this.segments().view();
        Option option = Log$.MODULE$.findRange(view, offset, view.length);
        if (option instanceof Some) {
            LogSegment logSegment;
            Some some = (Some)option;
            LogSegment segment = logSegment = (LogSegment)some.x();
            messageSet = segment.messageSet().read(offset - segment.start(), length);
        } else {
            messageSet = MessageSet$.MODULE$.Empty();
        }
        return messageSet;
    }

    public Seq<LogSegment> markDeletedWhile(Function1<LogSegment, Boolean> predicate) {
        Object object = this.lock();
        synchronized (object) {
            LogSegment[] view = (LogSegment[])this.segments().view();
            LogSegment[] deletable = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])view).takeWhile(predicate);
            Predef$.MODULE$.refArrayOps((Object[])deletable).foreach((Function1)new $anonfun$markDeletedWhile$1(this));
            int numToDelete = Predef$.MODULE$.refArrayOps((Object[])deletable).size();
            if (numToDelete == Predef$.MODULE$.refArrayOps((Object[])view).size()) {
                this.roll();
            }
            Seq<LogSegment> seq = this.segments().trunc(numToDelete);
            return seq;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$size$1(this)));
    }

    public long nextAppendOffset() {
        this.flush();
        LogSegment last = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
        return last.start() + last.size();
    }

    public long getHighwaterMark() {
        return ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().highWaterMark();
    }

    private void maybeRoll(LogSegment segment) {
        if (segment.messageSet().sizeInBytes() > this.maxSize()) {
            this.roll();
        }
    }

    public void roll() {
        Object object = this.lock();
        synchronized (object) {
            LogSegment last = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            long newOffset = this.nextAppendOffset();
            File newFile = new File(this.dir(), Log$.MODULE$.nameFromOffset(newOffset));
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"Rolling log '").append((Object)this.name()).append((Object)"' to ").append((Object)newFile.getName()).toString());
            }
            this.segments().append((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{new LogSegment(newFile, new FileMessageSet(newFile, true), newOffset)}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            return;
        }
    }

    private void maybeFlush(int numberOfMessages) {
        if (this.unflushed().addAndGet(numberOfMessages) >= this.flushInterval()) {
            this.flush();
        }
    }

    public void flush() {
        Object object = this.lock();
        synchronized (object) {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"Flushing log '").append((Object)this.name()).append((Object)"' last flushed: ").append((Object)BoxesRunTime.boxToLong((long)this.getLastFlushedTime())).append((Object)" current time: ").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
            }
            ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().flush();
            this.unflushed().set(0);
            this.lastflushedTime().set(System.currentTimeMillis());
            return;
        }
    }

    public long[] getOffsetsBefore(OffsetRequest request) {
        LogSegment[] segsArray$1 = (LogSegment[])this.segments().view();
        ObjectRef offsetTimeArray$1 = new ObjectRef(null);
        offsetTimeArray$1.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L ? new Tuple2[segsArray$1.length + 1] : new Tuple2[segsArray$1.length];
        Predef$.MODULE$.intWrapper(0).until(segsArray$1.length).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$1(this, segsArray$1, offsetTimeArray$1));
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L) {
            ((Tuple2[])offsetTimeArray$1.elem)[segsArray$1.length] = new Tuple2.mcLL.sp(((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).start() + ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).messageSet().highWaterMark(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex$1 = new IntRef(-1);
        long l = request.time();
        if (l == OffsetRequest$.MODULE$.LATEST_TIME()) {
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
        } else if (l == OffsetRequest$.MODULE$.EARLIEST_TIME()) {
            startIndex$1.elem = 0;
        } else {
            boolean isFound = false;
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
            while (startIndex$1.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray$1.elem)[startIndex$1.elem]._2$mcL$sp() <= request.time()) {
                    isFound = true;
                    continue;
                }
                --startIndex$1.elem;
            }
        }
        int retSize = Predef$.MODULE$.intWrapper(request.maxNumOffsets()).min(startIndex$1.elem + 1);
        long[] ret$1 = new long[retSize];
        Predef$.MODULE$.intWrapper(0).until(retSize).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$2(this, offsetTimeArray$1, startIndex$1, ret$1));
        return ret$1;
    }

    public String getTopicName() {
        return this.name().substring(0, this.name().lastIndexOf("-"));
    }

    public long getLastFlushedTime() {
        return this.lastflushedTime().get();
    }

    public Log(File dir, long maxSize, int flushInterval, boolean needRecovery) {
        this.dir = dir;
        this.maxSize = maxSize;
        this.flushInterval = flushInterval;
        this.needRecovery = needRecovery;
        this.logger = Logger.getLogger(Log.class);
        this.lock = new Object();
        this.unflushed = new AtomicInteger(0);
        this.lastflushedTime = new AtomicLong(System.currentTimeMillis());
        this.segments = this.loadSegments();
        this.name = dir.getName();
        this.logStats = new LogStats(this);
        Utils$.MODULE$.registerMBean(this.logStats(), new StringBuilder().append((Object)"kafka:type=kafka.logs.").append((Object)dir.getName()).toString());
    }
}

