/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.net.InetAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Cluster;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.Fetcher;
import kafka.consumer.KafkaMessageStream;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.consumer.ZookeeperConsumerConnector$ZKRebalancerListener$;
import kafka.consumer.ZookeeperConsumerConnector$ZKRebalancerListener$$anonfun$kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$;
import kafka.consumer.ZookeeperConsumerConnectorMBean;
import kafka.utils.KafkaScheduler;
import kafka.utils.Pool;
import kafka.utils.StringSerializer$;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\rMvAB\u0001\u0003\u0011\u000b!a!\u0001\u000e[_>\\W-\u001a9fe\u000e{gn];nKJ\u001cuN\u001c8fGR|'O\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b!\t9\u0001\"D\u0001\u0003\r%I!\u0001\"A\u0001\u0012\u000b!!B\u0001\u000e[_>\\W-\u001a9fe\u000e{gn];nKJ\u001cuN\u001c8fGR|'oE\u0002\t\u0017M\u0001\"\u0001D\t\u000e\u00035Q!AD\b\u0002\t1\fgn\u001a\u0006\u0002!\u0005!!.\u0019<b\u0013\t\u0011RB\u0001\u0004PE*,7\r\u001e\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001b\u0011\u0011\u0005A$\u0001\u0004=S:LGOP\u0002\u0001)\u00051\u0001b\u0002\u0010\t\u0005\u0004%\taH\u0001\u000e\u001b\u0006CvLT0S\u000bR\u0013\u0016*R*\u0016\u0003\u0001\u0002\"\u0001F\u0011\n\u0005\t*\"aA%oi\"1A\u0005\u0003Q\u0001\n\u0001\na\"T!Y?:{&+\u0012+S\u0013\u0016\u001b\u0006\u0005C\u0004'\u0011\t\u0007I\u0011A\u0014\u0002\u001fMDW\u000f\u001e3po:\u001cu.\\7b]\u0012,\u0012\u0001\u000b\t\u0003\u000f%J!A\u000b\u0002\u0003!\u0019+Go\u00195fI\u0012\u000bG/Y\"ik:\\\u0007B\u0002\u0017\tA\u0003%\u0001&\u0001\ttQV$Hm\\<o\u0007>lW.\u00198eA\u0019I\u0011B\u0001C\u0001\u0002\u0003\u0005AAL\n\u0006[-y#g\u0005\t\u0003\u000fAJ!!\r\u0002\u0003#\r{gn];nKJ\u001cuN\u001c8fGR|'\u000f\u0005\u0002\bg%\u0011AG\u0001\u0002 5>|7.Z3qKJ\u001cuN\\:v[\u0016\u00148i\u001c8oK\u000e$xN]'CK\u0006t\u0007\u0002\u0003\u001c.\u0005\u000b\u0007I\u0011A\u001c\u0002\r\r|gNZ5h+\u0005A\u0004CA\u0004:\u0013\tQ$A\u0001\bD_:\u001cX/\\3s\u0007>tg-[4\t\u0011qj#\u0011!Q\u0001\na\nqaY8oM&<\u0007\u0005\u0003\u0005?[\t\u0015\r\u0011\"\u0001@\u00035)g.\u00192mK\u001a+Go\u00195feV\t\u0001\t\u0005\u0002\u0015\u0003&\u0011!)\u0006\u0002\b\u0005>|G.Z1o\u0011!!UF!A!\u0002\u0013\u0001\u0015AD3oC\ndWMR3uG\",'\u000f\t\u0005\u000655\"\tA\u0012\u000b\u0004\u000f\"K\u0005CA\u0004.\u0011\u00151T\t1\u00019\u0011\u0015qT\t1\u0001A\u0011\u001dYUF1A\u0005\n1\u000ba\u0001\\8hO\u0016\u0014X#A'\u0011\u00059+V\"A(\u000b\u0005A\u000b\u0016!\u00027pORR'B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!AV(\u0003\r1{wmZ3s\u0011\u0019AV\u0006)A\u0005\u001b\u00069An\\4hKJ\u0004\u0003b\u0002..\u0005\u0004%IaW\u0001\u000fSN\u001c\u0006.\u001e;uS:<Gi\\<o+\u0005a\u0006CA/e\u001b\u0005q&BA0a\u0003\u0019\tGo\\7jG*\u0011\u0011MY\u0001\u000bG>t7-\u001e:sK:$(BA2\u0010\u0003\u0011)H/\u001b7\n\u0005\u0015t&!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004h[\u0001\u0006I\u0001X\u0001\u0010SN\u001c\u0006.\u001e;uS:<Gi\\<oA!9\u0011.\fb\u0001\n\u0013Q\u0017!\u0004:fE\u0006d\u0017M\\2f\u0019>\u001c7.F\u0001\f\u0011\u0019aW\u0006)A\u0005\u0017\u0005q!/\u001a2bY\u0006t7-\u001a'pG.\u0004\u0003b\u00028.\u0001\u0004%Ia\\\u0001\bM\u0016$8\r[3s+\u0005\u0001\bc\u0001\u000brg&\u0011!/\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001d!\u0018BA;\u0003\u0005\u001d1U\r^2iKJDqa^\u0017A\u0002\u0013%\u00010A\u0006gKR\u001c\u0007.\u001a:`I\u0015\fHCA=}!\t!\"0\u0003\u0002|+\t!QK\\5u\u0011\u001dih/!AA\u0002A\f1\u0001\u001f\u00132\u0011\u0019yX\u0006)Q\u0005a\u0006Aa-\u001a;dQ\u0016\u0014\b\u0005C\u0005\u0002\u00045\u0002\r\u0011\"\u0003\u0002\u0006\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001\u0003>lG2LWM\u001c;\u000b\u0007\u0005E1+\u0001\u0004Ja%#XmY\u0005\u0005\u0003+\tYA\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011%\tI\"\fa\u0001\n\u0013\tY\"\u0001\u0007{W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000fF\u0002z\u0003;A\u0011\"`A\f\u0003\u0003\u0005\r!a\u0002\t\u0011\u0005\u0005R\u0006)Q\u0005\u0003\u000f\t\u0011B_6DY&,g\u000e\u001e\u0011\t\u0013\u0005\u0015RF1A\u0005\n\u0005\u001d\u0012!\u0004;pa&\u001c'+Z4jgR\u0014\u00180\u0006\u0002\u0002*AA\u00111FA\u0019\u0003k\t\u0019%\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005M\u0012Q\u0006\u0002\u0005!>|G\u000e\u0005\u0003\u00028\u0005ubb\u0001\u000b\u0002:%\u0019\u00111H\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tY$\u0006\t\t\u0003W\t\t$!\u0012\u0002RA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0011\tqa\u00197vgR,'/\u0003\u0003\u0002P\u0005%#!\u0003)beRLG/[8o!\r9\u00111K\u0005\u0004\u0003+\u0012!A\u0005)beRLG/[8o)>\u0004\u0018nY%oM>D\u0001\"!\u0017.A\u0003%\u0011\u0011F\u0001\u000fi>\u0004\u0018n\u0019*fO&\u001cHO]=!\u0011%\ti&\fb\u0001\n\u0013\ty&\u0001\u0004rk\u0016,Xm]\u000b\u0003\u0003C\u0002\u0002\"a\u000b\u00022\u0005\r\u0014\u0011\u000e\t\b)\u0005\u0015\u0014QGA\u001b\u0013\r\t9'\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0005-\u0014Q\u000e\u0015\u000e\u0003\u0001L1!a\u001ca\u00055\u0011En\\2lS:<\u0017+^3vK\"A\u00111O\u0017!\u0002\u0013\t\t'A\u0004rk\u0016,Xm\u001d\u0011\t\u0013\u0005]TF1A\u0005\n\u0005e\u0014!C:dQ\u0016$W\u000f\\3s+\t\tY\b\u0005\u0003\u0002,\u0005u\u0014\u0002BA@\u0003[\u0011abS1gW\u0006\u001c6\r[3ek2,'\u000f\u0003\u0005\u0002\u00046\u0002\u000b\u0011BA>\u0003)\u00198\r[3ek2,'\u000f\t\u0005\u000755\"\t!a\"\u0015\u0007\u001d\u000bI\t\u0003\u00047\u0003\u000b\u0003\r\u0001\u000f\u0005\b\u0003\u001bkC\u0011AAH\u0003Q\u0019'/Z1uK6+7o]1hKN#(/Z1ngR!\u0011\u0011SA^!!\t\u0019*!'\u00026\u0005uUBAAK\u0015\r\t9*F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAN\u0003+\u00131!T1q!\u0019\ty*a,\u00026:!\u0011\u0011UAV\u001d\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAAT7\u00051AH]8pizJ\u0011AF\u0005\u0004\u0003[+\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003c\u000b\u0019L\u0001\u0003MSN$(bAAW+A\u0019q!a.\n\u0007\u0005e&A\u0001\nLC\u001a\\\u0017-T3tg\u0006<Wm\u0015;sK\u0006l\u0007\u0002CA_\u0003\u0017\u0003\r!a0\u0002\u001bQ|\u0007/[2D_VtG/T1q!\u001d\t\u0019*!'\u00026\u0001Bq!a1.\t\u0013\t)-A\u0007de\u0016\fG/\u001a$fi\u000eDWM\u001d\u000b\u0002s\"9\u0011\u0011Z\u0017\u0005\n\u0005\u0015\u0017!C2p]:,7\r\u001e.l\u0011\u001d\ti-\fC\u0001\u0003\u000b\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003#lC\u0011AAj\u0003\u001d\u0019wN\\:v[\u0016$B!!%\u0002V\"A\u0011QXAh\u0001\u0004\ty\fC\u0004\u0002Z6\"I!a7\u0002)I,w-[:uKJ\u001cuN\\:v[\u0016\u0014\u0018J\u001c.L)\u001dI\u0018Q\\At\u0003WD\u0001\"a8\u0002X\u0002\u0007\u0011\u0011]\u0001\u0005I&\u00148\u000f\u0005\u0003\u0002,\u0005\r\u0018\u0002BAs\u0003[\u00111BW&He>,\b\u000fR5sg\"A\u0011\u0011^Al\u0001\u0004\t)$\u0001\td_:\u001cX/\\3s\u0013\u0012\u001cFO]5oO\"A\u0011Q^Al\u0001\u0004\ty/\u0001\u0006u_BL7mQ8v]R\u00042aBAy\u0013\r\t\u0019P\u0001\u0002\u000b)>\u0004\u0018nY\"pk:$\bbBA|[\u0011%\u0011QY\u0001\u0017g\u0016tGm\u00155vI><h\u000eV8BY2\fV/Z;fg\"9\u00111`\u0017\u0005\u0002\u0005\u0015\u0017AC1vi>\u001cu.\\7ji\"9\u0011q`\u0017\u0005\u0002\u0005\u0015\u0017!D2p[6LGo\u00144gg\u0016$8\u000fC\u0004\u0003\u00045\"\tA!\u0002\u0002#\u001d,G\u000fU1si>;h.\u001a:Ti\u0006$8\u000f\u0006\u0002\u00026!9!\u0011B\u0017\u0005\u0002\t\u0015\u0011\u0001E4fi\u000e{gn];nKJ<%o\\;q\u0011\u001d\u0011i!\fC\u0001\u0005\u001f\tAbZ3u\u001f\u001a47/\u001a;MC\u001e$\u0002B!\u0005\u0003\u0018\tm!q\u0004\t\u0004)\tM\u0011b\u0001B\u000b+\t!Aj\u001c8h\u0011!\u0011IBa\u0003A\u0002\u0005U\u0012!\u0002;pa&\u001c\u0007b\u0002B\u000f\u0005\u0017\u0001\r\u0001I\u0001\tEJ|7.\u001a:JI\"9!\u0011\u0005B\u0006\u0001\u0004\u0001\u0013a\u00039beRLG/[8o\u0013\u0012DqA!\n.\t\u0003\u00119#A\thKR\u001cuN\\:v[\u0016$wJ\u001a4tKR$\u0002B!\u0005\u0003*\t-\"Q\u0006\u0005\t\u00053\u0011\u0019\u00031\u0001\u00026!9!Q\u0004B\u0012\u0001\u0004\u0001\u0003b\u0002B\u0011\u0005G\u0001\r\u0001\t\u0005\b\u0005ciC\u0011\u0001B\u001a\u0003=9W\r\u001e'bi\u0016\u001cHo\u00144gg\u0016$H\u0003\u0003B\t\u0005k\u00119D!\u000f\t\u0011\te!q\u0006a\u0001\u0003kAqA!\b\u00030\u0001\u0007\u0001\u0005C\u0004\u0003\"\t=\u0002\u0019\u0001\u0011\u0007\u0015\tuR\u0006\"A\u0001\u0002\u0003\u0011yD\u0001\r[\u0017N+7o]5p]\u0016C\b/\u001b:f\u0019&\u001cH/\u001a8oKJ\u001cbAa\u000f\f\u0005\u0003\u001a\u0002\u0003BA\u0005\u0005\u0007JAA!\u0012\u0002\f\t\u0001\u0012JW6Ti\u0006$X\rT5ti\u0016tWM\u001d\u0005\f\u0003?\u0014YD!b\u0001\n\u0003\u0011I%\u0006\u0002\u0002b\"Y!Q\nB\u001e\u0005\u0003\u0005\u000b\u0011BAq\u0003\u0015!\u0017N]:!\u0011-\tIOa\u000f\u0003\u0006\u0004%\tA!\u0015\u0016\u0005\u0005U\u0002b\u0003B+\u0005w\u0011\t\u0011)A\u0005\u0003k\t\u0011cY8ogVlWM]%e'R\u0014\u0018N\\4!\u0011-\tiOa\u000f\u0003\u0006\u0004%\tA!\u0017\u0016\u0005\u0005=\bb\u0003B/\u0005w\u0011\t\u0011)A\u0005\u0003_\f1\u0002^8qS\u000e\u001cu.\u001e8uA!Y!\u0011\rB\u001e\u0005\u000b\u0007I\u0011\u0001B2\u0003Qaw.\u00193CC2\fgnY3s\u0019&\u001cH/\u001a8feV\u0011!Q\r\t\u0005\u0005O\u0012I'D\u0001.\r)\u0011Y'\fC\u0001\u0002\u0003\u0005!Q\u000e\u0002\u00155.\u0013VMY1mC:\u001cWM\u001d'jgR,g.\u001a:\u0014\r\t%4Ba\u001c\u0014!\u0011\tIA!\u001d\n\t\tM\u00141\u0002\u0002\u0011\u0013j[7\t[5mI2K7\u000f^3oKJD1Ba\u001e\u0003j\t\u0015\r\u0011\"\u0001\u0003R\u0005)qM]8va\"Y!1\u0010B5\u0005\u0003\u0005\u000b\u0011BA\u001b\u0003\u00199'o\\;qA!Y\u0011\u0011\u001eB5\u0005\u000b\u0007I\u0011\u0001B)\u0011-\u0011)F!\u001b\u0003\u0002\u0003\u0006I!!\u000e\t\u000fi\u0011I\u0007\"\u0001\u0003\u0004R1!Q\rBC\u0005\u000fC\u0001Ba\u001e\u0003\u0002\u0002\u0007\u0011Q\u0007\u0005\t\u0003S\u0014\t\t1\u0001\u00026!Q\u0011q\u001cB5\u0005\u0004%IA!\u0013\t\u0013\t5#\u0011\u000eQ\u0001\n\u0005\u0005\bB\u0003BH\u0005S\u0002\r\u0011\"\u0003\u0003\u0012\u0006Ar\u000e\u001c3QCJ$\u0018\u000e^5p]N\u0004VM\u001d+pa&\u001cW*\u00199\u0016\u0005\tM\u0005\u0003\u0003BK\u00057\u000b)D!(\u000e\u0005\t]%\u0002\u0002BM\u0003+\u000bq!\\;uC\ndW-\u0003\u0003\u0002\u001c\n]\u0005CBAP\u0003_\u000b)\u0004\u0003\u0006\u0003\"\n%\u0004\u0019!C\u0005\u0005G\u000bAd\u001c7e!\u0006\u0014H/\u001b;j_:\u001c\b+\u001a:U_BL7-T1q?\u0012*\u0017\u000fF\u0002z\u0005KC\u0011\" BP\u0003\u0003\u0005\rAa%\t\u0013\t%&\u0011\u000eQ!\n\tM\u0015!G8mIB\u000b'\u000f^5uS>t7\u000fU3s)>\u0004\u0018nY'ba\u0002B!B!,\u0003j\u0001\u0007I\u0011\u0002BI\u0003]yG\u000eZ\"p]N,X.\u001a:t!\u0016\u0014Hk\u001c9jG6\u000b\u0007\u000f\u0003\u0006\u00032\n%\u0004\u0019!C\u0005\u0005g\u000b1d\u001c7e\u0007>t7/^7feN\u0004VM\u001d+pa&\u001cW*\u00199`I\u0015\fHcA=\u00036\"IQPa,\u0002\u0002\u0003\u0007!1\u0013\u0005\n\u0005s\u0013I\u0007)Q\u0005\u0005'\u000b\u0001d\u001c7e\u0007>t7/^7feN\u0004VM\u001d+pa&\u001cW*\u00199!\u0011!\u0011iL!\u001b\u0005\u0002\t}\u0016!\u00055b]\u0012dWm\u00115jY\u0012\u001c\u0005.\u00198hKR)\u0011P!1\u0003F\"A!1\u0019B^\u0001\u0004\t)$\u0001\u0006qCJ,g\u000e\u001e)bi\"D\u0001Ba2\u0003<\u0002\u0007!\u0011Z\u0001\nGV\u00148\t[5mIN\u0004bAa3\u0003N\u0006UR\"\u00012\n\u0007\u0005E&\r\u000b\u0004\u0003<\nE'q\u001b\t\u0004)\tM\u0017b\u0001Bk+\t1A\u000f\u001b:poN\u001c#A!7\u0011\t\u0005}%1\\\u0005\u0005\u0005;\f\u0019LA\u0005Fq\u000e,\u0007\u000f^5p]\"A!\u0011\u001dB5\t\u0013\t)-A\rsK2,\u0017m]3QCJ$\u0018\u000e^5p]>;h.\u001a:tQ&\u0004\b\u0002\u0003Bs\u0005S\"IAa:\u0002)\u001d,GoQ8ogVlWM]:QKJ$v\u000e]5d)\u0011\u0011\u0019J!;\t\u0011\t]$1\u001da\u0001\u0003kA\u0001B!<\u0003j\u0011%!q^\u0001\u0014O\u0016$(+\u001a7fm\u0006tG\u000fV8qS\u000el\u0015\r\u001d\u000b\r\u0005c\u0014IP!@\u0004\u0004\r\u001d11\u0002\t\t\u0003'\u000bI*!\u000e\u0003tB1\u00111\u0013B{\u0003kIAAa>\u0002\u0016\n\u00191+\u001a;\t\u0011\tm(1\u001ea\u0001\u0005c\f1#\\=U_BL7\r\u00165sK\u0006$\u0017\nZ:NCBD\u0001Ba@\u0003l\u0002\u00071\u0011A\u0001\u000b]\u0016<\b+\u0019:u\u001b\u0006\u0004\b\u0003CAJ\u00033\u000b)D!(\t\u0011\r\u0015!1\u001ea\u0001\u0007\u0003\t!b\u001c7e!\u0006\u0014H/T1q\u0011!\u0019IAa;A\u0002\r\u0005\u0011A\u00048fo\u000e{gn];nKJl\u0015\r\u001d\u0005\t\u0007\u001b\u0011Y\u000f1\u0001\u0004\u0002\u0005qq\u000e\u001c3D_:\u001cX/\\3s\u001b\u0006\u0004\b\u0002CB\t\u0005S\"Iaa\u0005\u0002\u001b\u001d,G\u000fV8qS\u000e\u001cu.\u001e8u)\u0011\tyo!\u0006\t\u0011\r]1q\u0002a\u0001\u0003k\t!bY8ogVlWM]%e\u0011!\u0019YB!\u001b\u0005\u0002\u0005\u0015\u0017A\u0003:fg\u0016$8\u000b^1uK\"A1q\u0004B5\t\u0003\t)-A\bts:\u001cW\r\u001a*fE\u0006d\u0017M\\2f\u0011!\u0019\u0019C!\u001b\u0005\n\r\u0015\u0012!\u0003:fE\u0006d\u0017M\\2f)\u0005\u0001\u0005\u0002CB\u0015\u0005S\"Iaa\u000b\u0002\u001bU\u0004H-\u0019;f\r\u0016$8\r[3s)\u0015I8QFB\u001b\u0011!\tYea\nA\u0002\r=\u0002\u0003BA$\u0007cIAaa\r\u0002J\t91\t\\;ti\u0016\u0014\b\u0002CB\u001c\u0007O\u0001\ra!\u000f\u0002#E,X-^3t)>\u0014Wm\u00117fCJ,G\r\u0005\u0004\u0002\u0014\u000em\u0012\u0011N\u0005\u0005\u0007{\t)J\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011!\u0019\tE!\u001b\u0005\n\r\r\u0013\u0001\u00059s_\u000e,7o\u001d)beRLG/[8o)%\u00015QIB(\u0007'\u001a)\u0006\u0003\u0005\u0004H\r}\u0002\u0019AB%\u0003%!x\u000e]5d\t&\u00148\u000f\u0005\u0003\u0002,\r-\u0013\u0002BB'\u0003[\u0011\u0001CW&He>,\b\u000fV8qS\u000e$\u0015N]:\t\u0011\rE3q\ba\u0001\u0003k\t\u0011\u0002]1si&$\u0018n\u001c8\t\u0011\te1q\ba\u0001\u0003kA\u0001ba\u0016\u0004@\u0001\u0007\u0011QG\u0001\u0011G>t7/^7feRC'/Z1e\u0013\u0012D\u0001ba\u0017\u0003j\u0011%1QL\u0001\u0016C\u0012$\u0007+\u0019:uSRLwN\u001c+pa&\u001c\u0017J\u001c4p)%I8qLB1\u0007K\u001a9\u0007\u0003\u0005\u0004H\re\u0003\u0019AB%\u0011!\u0019\u0019g!\u0017A\u0002\u0005U\u0012a\u00049beRLG/[8o'R\u0014\u0018N\\4\t\u0011\te1\u0011\fa\u0001\u0003kA\u0001ba\u0016\u0004Z\u0001\u0007\u0011Q\u0007\u0005\f\u0007W\u0012YD!A!\u0002\u0013\u0011)'A\u000bm_\u0006$')\u00197b]\u000e,'\u000fT5ti\u0016tWM\u001d\u0011\t\u000fi\u0011Y\u0004\"\u0001\u0004pQQ1\u0011OB:\u0007k\u001a9h!\u001f\u0011\t\t\u001d$1\b\u0005\t\u0003?\u001ci\u00071\u0001\u0002b\"A\u0011\u0011^B7\u0001\u0004\t)\u0004\u0003\u0005\u0002n\u000e5\u0004\u0019AAx\u0011!\u0011\tg!\u001cA\u0002\t\u0015\u0004\u0002CB?\u0005w!\taa \u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<W\r\u001a\u000b\u0004s\u000e\u0005\u0005\u0002CBB\u0007w\u0002\ra!\"\u0002\u000bM$\u0018\r^3\u0011\t\r\u001d5Q\u0015\b\u0005\u0007\u0013\u001byJ\u0004\u0003\u0004\f\u000eee\u0002BBG\u0007+sAaa$\u0004\u0014:!\u00111UBI\u0013\u0005!\u0016B\u0001*T\u0013\r\u00199*U\u0001\nu>|7.Z3qKJLAaa'\u0004\u001e\u00069q+\u0019;dQ\u0016\u0014(bABL#&!1\u0011UBR\u0003\u0015)e/\u001a8u\u0015\u0011\u0019Yj!(\n\t\r\u001d6\u0011\u0016\u0002\f\u0017\u0016,\u0007/\u001a:Ti\u0006$XM\u0003\u0003\u0004\"\u000e\r\u0006FBB>\u0005#\u00149\u000e\u0003\u0005\u00040\nmB\u0011AAc\u0003AA\u0017M\u001c3mK:+woU3tg&|g\u000e\u000b\u0004\u0004.\nE'q\u001b")
public class ZookeeperConsumerConnector
implements ConsumerConnector,
ZookeeperConsumerConnectorMBean,
ScalaObject {
    private final ConsumerConfig config;
    private final boolean enableFetcher;
    private final Logger kafka$consumer$ZookeeperConsumerConnector$$logger;
    private final AtomicBoolean isShuttingDown;
    private final Object kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock;
    private Option kafka$consumer$ZookeeperConsumerConnector$$fetcher;
    private ZkClient kafka$consumer$ZookeeperConsumerConnector$$zkClient;
    private final Pool kafka$consumer$ZookeeperConsumerConnector$$topicRegistry;
    private final Pool kafka$consumer$ZookeeperConsumerConnector$$queues;
    private final KafkaScheduler scheduler;

    public static final FetchedDataChunk shutdownCommand() {
        return ZookeeperConsumerConnector$.MODULE$.shutdownCommand();
    }

    public static final int MAX_N_RETRIES() {
        return ZookeeperConsumerConnector$.MODULE$.MAX_N_RETRIES();
    }

    public ConsumerConfig config() {
        return this.config;
    }

    public boolean enableFetcher() {
        return this.enableFetcher;
    }

    public final Logger kafka$consumer$ZookeeperConsumerConnector$$logger() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$logger;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public final Object kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock;
    }

    public final Option kafka$consumer$ZookeeperConsumerConnector$$fetcher() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$fetcher;
    }

    private void kafka$consumer$ZookeeperConsumerConnector$$fetcher_$eq(Option option) {
        this.kafka$consumer$ZookeeperConsumerConnector$$fetcher = option;
    }

    public final ZkClient kafka$consumer$ZookeeperConsumerConnector$$zkClient() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$zkClient;
    }

    private void kafka$consumer$ZookeeperConsumerConnector$$zkClient_$eq(ZkClient zkClient) {
        this.kafka$consumer$ZookeeperConsumerConnector$$zkClient = zkClient;
    }

    public final Pool kafka$consumer$ZookeeperConsumerConnector$$topicRegistry() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry;
    }

    public final Pool kafka$consumer$ZookeeperConsumerConnector$$queues() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$queues;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public ZookeeperConsumerConnector(ConsumerConfig config) {
        this(config, true);
    }

    @Override
    public Map<String, List<KafkaMessageStream>> createMessageStreams(Map<String, Integer> topicCountMap) {
        return this.consume(topicCountMap);
    }

    private void createFetcher() {
        if (this.enableFetcher()) {
            this.kafka$consumer$ZookeeperConsumerConnector$$fetcher_$eq((Option)new Some((Object)new Fetcher(this.config(), this.kafka$consumer$ZookeeperConsumerConnector$$zkClient())));
        }
    }

    private void connectZk() {
        this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"Connecting to zookeeper instance at ").append((Object)this.config().zkConnect()).toString());
        this.kafka$consumer$ZookeeperConsumerConnector$$zkClient_$eq(new ZkClient(this.config().zkConnect(), this.config().zkSessionTimeoutMs(), this.config().zkConnectionTimeoutMs(), (ZkSerializer)StringSerializer$.MODULE$));
    }

    @Override
    public void shutdown() {
        block5: {
            block4: {
                boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
                if (!canShutdown) break block5;
                this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"ZKConsumerConnector shutting down");
                try {
                    Option option;
                    block8: {
                        block7: {
                            block6: {
                                this.scheduler().shutdown();
                                option = this.kafka$consumer$ZookeeperConsumerConnector$$fetcher();
                                if (!(option instanceof Some)) break block6;
                                ((Fetcher)((Some)option).x()).shutdown();
                                break block7;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                        }
                        this.sendShudownToAllQueues();
                        if (this.kafka$consumer$ZookeeperConsumerConnector$$zkClient() != null) {
                            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient().close();
                            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient_$eq(null);
                        }
                        break block4;
                    }
                    throw new MatchError((Object)option);
                }
                catch (Throwable throwable) {
                    this.kafka$consumer$ZookeeperConsumerConnector$$logger().fatal((Object)throwable);
                    this.kafka$consumer$ZookeeperConsumerConnector$$logger().fatal((Object)Utils$.MODULE$.stackTrace(throwable));
                }
            }
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"ZKConsumerConnector shut down completed");
        }
    }

    public Map<String, List<KafkaMessageStream>> consume(Map<String, Integer> topicCountMap) {
        Option<String> option;
        block6: {
            String consumerUuid;
            ObjectRef ret$1;
            ZKGroupDirs dirs;
            block5: {
                block4: {
                    this.kafka$consumer$ZookeeperConsumerConnector$$logger().debug((Object)"entering consume ");
                    if (topicCountMap == null) {
                        throw new RuntimeException("topicCountMap is null");
                    }
                    dirs = new ZKGroupDirs(this.config().groupId());
                    ret$1 = new ObjectRef((Object)new HashMap());
                    consumerUuid = null;
                    option = this.config().consumerId();
                    if (!(option instanceof Some)) break block4;
                    consumerUuid = (String)((Some)option).x();
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                consumerUuid = new StringBuilder().append((Object)InetAddress.getLocalHost().getHostName()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
            }
            String consumerIdString = new StringBuilder().append((Object)this.config().groupId()).append((Object)"_").append((Object)consumerUuid).toString();
            TopicCount topicCount = new TopicCount(consumerIdString, topicCountMap);
            ZKRebalancerListener loadBalancerListener$1 = new ZKRebalancerListener(this, this.config().groupId(), consumerIdString);
            this.kafka$consumer$ZookeeperConsumerConnector$$registerConsumerInZK(dirs, consumerIdString, topicCount);
            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient().subscribeChildChanges(dirs.consumerRegistryDir(), (IZkChildListener)loadBalancerListener$1);
            Map<String, Set<String>> consumerThreadIdsPerTopic = topicCount.getConsumerThreadIdsPerTopic();
            consumerThreadIdsPerTopic.foreach((Function1)new $anonfun$consume$1(this, ret$1, loadBalancerListener$1));
            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient().subscribeStateChanges((IZkStateListener)new ZKSessionExpireListenner(this, dirs, consumerIdString, topicCount, loadBalancerListener$1));
            loadBalancerListener$1.syncedRebalance();
            return (HashMap)ret$1.elem;
        }
        throw new MatchError(option);
    }

    public final void kafka$consumer$ZookeeperConsumerConnector$$registerConsumerInZK(ZKGroupDirs dirs, String consumerIdString, TopicCount topicCount) {
        this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"begin registering consumer ").append((Object)consumerIdString).append((Object)" in ZK").toString());
        ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.kafka$consumer$ZookeeperConsumerConnector$$zkClient(), new StringBuilder().append((Object)dirs.consumerRegistryDir()).append((Object)"/").append((Object)consumerIdString).toString(), topicCount.toJsonString());
        this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"end registering consumer ").append((Object)consumerIdString).append((Object)" in ZK").toString());
    }

    private void sendShudownToAllQueues() {
        this.kafka$consumer$ZookeeperConsumerConnector$$queues().values().foreach((Function1)new $anonfun$sendShudownToAllQueues$1(this));
    }

    public void autoCommit() {
        if (this.kafka$consumer$ZookeeperConsumerConnector$$logger().isTraceEnabled()) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().trace((Object)"auto committing");
        }
        try {
            this.commitOffsets();
        }
        catch (Throwable throwable) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().error((Object)"exception during autoCommit: ", throwable);
        }
    }

    @Override
    public void commitOffsets() {
        if (this.kafka$consumer$ZookeeperConsumerConnector$$zkClient() == null) {
            return;
        }
        this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().foreach((Function1)new $anonfun$commitOffsets$1(this));
    }

    @Override
    public String getPartOwnerStats() {
        StringBuilder builder$1 = new StringBuilder();
        this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().foreach((Function1)new $anonfun$getPartOwnerStats$1(this, builder$1));
        return builder$1.toString();
    }

    @Override
    public String getConsumerGroup() {
        return this.config().groupId();
    }

    @Override
    public long getOffsetLag(String topic, int brokerId, int partitionId) {
        return this.getLatestOffset(topic, brokerId, partitionId) - this.getConsumedOffset(topic, brokerId, partitionId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getConsumedOffset(String topic, int brokerId, int partitionId) {
        PartitionTopicInfo partitionInfo;
        Partition partition = new Partition(brokerId, partitionId);
        Pool partitionInfos = (Pool)this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().get(topic);
        if (partitionInfos != null && (partitionInfo = (PartitionTopicInfo)partitionInfos.get(partition)) != null) return partitionInfo.getConsumeOffset();
        try {
            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config().groupId(), topic);
            String znode = new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)partition.name()).toString();
            String offsetString = ZkUtils$.MODULE$.readDataMaybeNull(this.kafka$consumer$ZookeeperConsumerConnector$$zkClient(), znode);
            if (offsetString != null) return Predef$.MODULE$.augmentString(offsetString).toLong();
            return -1L;
        }
        catch (Throwable throwable) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().error((Object)"error in getConsumedOffset JMX ", throwable);
            return -2L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLatestOffset(String topic, int brokerId, int partitionId) {
        SimpleConsumer simpleConsumer = null;
        long producedOffset = -1L;
        try {
            Cluster cluster = ZkUtils$.MODULE$.getCluster(this.kafka$consumer$ZookeeperConsumerConnector$$zkClient());
            Broker broker = cluster.getBroker(brokerId);
            simpleConsumer = new SimpleConsumer(broker.host(), broker.port(), ConsumerConfig$.MODULE$.SOCKET_TIMEOUT(), ConsumerConfig$.MODULE$.SOCKET_BUFFER_SIZE());
            long[] latestOffset = simpleConsumer.getOffsetsBefore(topic, partitionId, OffsetRequest$.MODULE$.LATEST_TIME(), 1);
            producedOffset = latestOffset[0];
            if (simpleConsumer == null) return producedOffset;
            simpleConsumer.close();
            return producedOffset;
        }
        catch (Throwable throwable) {
            try {
                this.kafka$consumer$ZookeeperConsumerConnector$$logger().error((Object)"error in getLatestOffset jmx ", throwable);
            }
            finally {
                if (simpleConsumer == null) return producedOffset;
                simpleConsumer.close();
            }
        }
    }

    public ZookeeperConsumerConnector(ConsumerConfig config, boolean enableFetcher) {
        Object object;
        this.config = config;
        this.enableFetcher = enableFetcher;
        this.kafka$consumer$ZookeeperConsumerConnector$$logger = Logger.getLogger(this.getClass());
        this.isShuttingDown = new AtomicBoolean(false);
        this.kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock = new Object();
        this.kafka$consumer$ZookeeperConsumerConnector$$fetcher = None$.MODULE$;
        this.kafka$consumer$ZookeeperConsumerConnector$$zkClient = null;
        this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry = new Pool();
        this.kafka$consumer$ZookeeperConsumerConnector$$queues = new Pool();
        this.scheduler = new KafkaScheduler(1, "Kafka-consumer-autocommit-", false);
        this.connectZk();
        this.createFetcher();
        if (config.autoCommit()) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"starting auto committer every ").append((Object)BoxesRunTime.boxToInteger((int)config.autoCommitIntervalMs())).append((Object)" ms").toString());
            object = this.scheduler().scheduleWithRate((Function0<Object>)new $anonfun$1(this), config.autoCommitIntervalMs(), config.autoCommitIntervalMs());
        } else {
            object = BoxedUnit.UNIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZKRebalancerListener
    implements IZkChildListener,
    ScalaObject {
        private final String group;
        private final String consumerIdString;
        private final ZKGroupDirs dirs;
        private scala.collection.mutable.Map<String, List<String>> oldPartitionsPerTopicMap;
        private scala.collection.mutable.Map<String, List<String>> oldConsumersPerTopicMap;
        public final /* synthetic */ ZookeeperConsumerConnector $outer;

        public String group() {
            return this.group;
        }

        public String consumerIdString() {
            return this.consumerIdString;
        }

        private ZKGroupDirs dirs() {
            return this.dirs;
        }

        private scala.collection.mutable.Map<String, List<String>> oldPartitionsPerTopicMap() {
            return this.oldPartitionsPerTopicMap;
        }

        private void oldPartitionsPerTopicMap_$eq(scala.collection.mutable.Map<String, List<String>> map) {
            this.oldPartitionsPerTopicMap = map;
        }

        private scala.collection.mutable.Map<String, List<String>> oldConsumersPerTopicMap() {
            return this.oldConsumersPerTopicMap;
        }

        private void oldConsumersPerTopicMap_$eq(scala.collection.mutable.Map<String, List<String>> map) {
            this.oldConsumersPerTopicMap = map;
        }

        public void handleChildChange(String parentPath, java.util.List<String> curChilds) throws Exception {
            this.syncedRebalance();
        }

        public final void kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$releasePartitionOwnership() {
            this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().foreach((Function1)new ZKRebalancerListener$$anonfun$kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$releasePartitionOwnership$1(this));
        }

        /*
         * WARNING - void declaration
         */
        private scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(String group) {
            void var3_3;
            Seq<String> consumers = ZkUtils$.MODULE$.getChildrenParentMayNotExist(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), this.dirs().consumerRegistryDir());
            HashMap consumersPerTopicMap$1 = new HashMap();
            consumers.foreach((Function1)new ZKRebalancerListener$$anonfun$getConsumersPerTopic$1(this, consumersPerTopicMap$1));
            consumersPerTopicMap$1.foreach((Function1)new ZKRebalancerListener$$anonfun$getConsumersPerTopic$2(this, consumersPerTopicMap$1));
            return var3_3;
        }

        private Map<String, Set<String>> getRelevantTopicMap(Map<String, Set<String>> myTopicThreadIdsMap, Map<String, List<String>> newPartMap$1, Map<String, List<String>> oldPartMap$1, Map<String, List<String>> newConsumerMap$1, Map<String, List<String>> oldConsumerMap$1) {
            ObjectRef relevantTopicThreadIdsMap$1 = new ObjectRef((Object)new HashMap());
            myTopicThreadIdsMap.foreach((Function1)new ZKRebalancerListener$$anonfun$getRelevantTopicMap$1(this, newPartMap$1, oldPartMap$1, newConsumerMap$1, oldConsumerMap$1, relevantTopicThreadIdsMap$1));
            return (HashMap)relevantTopicThreadIdsMap$1.elem;
        }

        public final TopicCount kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$getTopicCount(String consumerId) {
            String topicCountJson = ZkUtils$.MODULE$.readData(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), new StringBuilder().append((Object)this.dirs().consumerRegistryDir()).append((Object)"/").append((Object)consumerId).toString());
            return TopicCount$.MODULE$.constructTopicCount(consumerId, topicCountJson);
        }

        public void resetState() {
            this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().clear();
            this.oldConsumersPerTopicMap().clear();
            this.oldPartitionsPerTopicMap().clear();
        }

        public void syncedRebalance() {
            Object object = new Object();
            try {
                Object object2 = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock();
                synchronized (object2) {
                    Predef$.MODULE$.intWrapper(0).until(ZookeeperConsumerConnector$.MODULE$.MAX_N_RETRIES()).foreach$mVc$sp((Function1)new ZKRebalancerListener$$anonfun$syncedRebalance$1(this, object));
                    throw new RuntimeException(new StringBuilder().append((Object)this.consumerIdString()).append((Object)" can't rebalance after ").append((Object)BoxesRunTime.boxToInteger((int)ZookeeperConsumerConnector$.MODULE$.MAX_N_RETRIES())).append((Object)" retires").toString());
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl) {
                if (nonLocalReturnControl.key() == object) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)nonLocalReturnControl.value();
                    return;
                }
                throw nonLocalReturnControl;
            }
        }

        public final boolean kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$rebalance() {
            NonLocalReturnControl nonLocalReturnControl2;
            block3: {
                Object object = new Object();
                boolean exceptionResult1 = false;
                try {
                    Map<String, Set<String>> myTopicThreadIdsMap = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$getTopicCount(this.consumerIdString()).getConsumerThreadIdsPerTopic();
                    Cluster cluster = ZkUtils$.MODULE$.getCluster(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient());
                    scala.collection.mutable.Map<String, List<String>> consumersPerTopicMap$2 = this.getConsumersPerTopic(this.group());
                    scala.collection.mutable.Map<String, List<String>> partitionsPerTopicMap$1 = ZkUtils$.MODULE$.getPartitionsForTopics(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), (Iterator<String>)myTopicThreadIdsMap.keys().iterator());
                    Map<String, Set<String>> relevantTopicThreadIdsMap = this.getRelevantTopicMap(myTopicThreadIdsMap, (Map<String, List<String>>)partitionsPerTopicMap$1, (Map<String, List<String>>)this.oldPartitionsPerTopicMap(), (Map<String, List<String>>)consumersPerTopicMap$2, (Map<String, List<String>>)this.oldConsumersPerTopicMap());
                    if (relevantTopicThreadIdsMap.size() <= 0) {
                        this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"Consumer ").append((Object)this.consumerIdString()).append((Object)" with ").append(consumersPerTopicMap$2).append((Object)" doesn't need to rebalance.").toString());
                        return true;
                    }
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"Committing all offsets");
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().commitOffsets();
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"Releasing partition ownership");
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$releasePartitionOwnership();
                    HashSet queuesToBeCleared$1 = new HashSet();
                    relevantTopicThreadIdsMap.foreach((Function1)new ZKRebalancerListener$$anonfun$kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$rebalance$1(this, consumersPerTopicMap$2, partitionsPerTopicMap$1, queuesToBeCleared$1, object));
                    this.updateFetcher(cluster, (Iterable<BlockingQueue<FetchedDataChunk>>)queuesToBeCleared$1);
                    this.oldPartitionsPerTopicMap_$eq(partitionsPerTopicMap$1);
                    this.oldConsumersPerTopicMap_$eq(consumersPerTopicMap$2);
                    exceptionResult1 = true;
                }
                catch (NonLocalReturnControl nonLocalReturnControl2) {
                    if (nonLocalReturnControl2.key() != object) break block3;
                    exceptionResult1 = BoxesRunTime.unboxToBoolean((Object)nonLocalReturnControl2.value());
                }
                return exceptionResult1;
            }
            throw nonLocalReturnControl2;
        }

        private void updateFetcher(Cluster cluster, Iterable<BlockingQueue<FetchedDataChunk>> queuesTobeCleared) {
            Option option;
            block4: {
                block3: {
                    block2: {
                        ObjectRef allPartitionInfos$1 = new ObjectRef((Object)Nil$.MODULE$);
                        this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().values().foreach((Function1)new ZKRebalancerListener$$anonfun$updateFetcher$1(this, allPartitionInfos$1));
                        this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"Consumer ").append((Object)this.consumerIdString()).append((Object)" selected partitions : ").append((Object)((TraversableOnce)((TraversableLike)((List)allPartitionInfos$1.elem).sortWith((Function2)new ZKRebalancerListener$$anonfun$updateFetcher$2(this))).map((Function1)new ZKRebalancerListener$$anonfun$updateFetcher$3(this), List$.MODULE$.canBuildFrom())).mkString(",")).toString());
                        option = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$fetcher();
                        if (!(option instanceof Some)) break block2;
                        ((Fetcher)((Some)option).x()).initConnections((Iterable<PartitionTopicInfo>)((List)allPartitionInfos$1.elem), cluster, queuesTobeCleared);
                        break block3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                }
                return;
            }
            throw new MatchError((Object)option);
        }

        public final boolean kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$processPartition(ZKGroupTopicDirs topicDirs, String partition, String topic, String consumerThreadId) {
            String partitionOwnerPath = new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append((Object)partition).toString();
            try {
                ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), partitionOwnerPath, consumerThreadId);
                this.addPartitionTopicInfo(topicDirs, partition, topic, consumerThreadId);
                return true;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"waiting for the partition ownership to be deleted: ").append((Object)partition).toString());
                return false;
            }
        }

        private void addPartitionTopicInfo(ZKGroupTopicDirs topicDirs, String partitionString, String topic, String consumerThreadId) {
            Partition partition = Partition$.MODULE$.parse(partitionString);
            Pool partTopicInfoMap = (Pool)this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().get(topic);
            String znode = new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)partition.name()).toString();
            String offsetString = ZkUtils$.MODULE$.readDataMaybeNull(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), znode);
            long offset = offsetString == null ? Long.MAX_VALUE : Predef$.MODULE$.augmentString(offsetString).toLong();
            BlockingQueue queue = (BlockingQueue)this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$queues().get(new Tuple2((Object)topic, (Object)consumerThreadId));
            AtomicLong consumedOffset = new AtomicLong(offset);
            AtomicLong fetchedOffset = new AtomicLong(offset);
            PartitionTopicInfo partTopicInfo = new PartitionTopicInfo(topic, partition.brokerId(), partition, queue, consumedOffset, fetchedOffset, new AtomicInteger(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().config().fetchSize()));
            partTopicInfoMap.put(partition, partTopicInfo);
            if (this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().isDebugEnabled()) {
                this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().debug((Object)new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd((Object)partTopicInfo).$plus(" selected new offset ")).append((Object)BoxesRunTime.boxToLong((long)offset)).toString());
            }
        }

        public /* synthetic */ ZookeeperConsumerConnector kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer() {
            return this.$outer;
        }

        public ZKRebalancerListener(ZookeeperConsumerConnector $outer, String group, String consumerIdString) {
            this.group = group;
            this.consumerIdString = consumerIdString;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.dirs = new ZKGroupDirs(group);
            this.oldPartitionsPerTopicMap = new HashMap();
            this.oldConsumersPerTopicMap = new HashMap();
        }
    }

    public class ZKSessionExpireListenner
    implements IZkStateListener,
    ScalaObject {
        private final ZKGroupDirs dirs;
        private final String consumerIdString;
        private final TopicCount topicCount;
        private final ZKRebalancerListener loadBalancerListener;
        public final /* synthetic */ ZookeeperConsumerConnector $outer;

        public ZKGroupDirs dirs() {
            return this.dirs;
        }

        public String consumerIdString() {
            return this.consumerIdString;
        }

        public TopicCount topicCount() {
            return this.topicCount;
        }

        public ZKRebalancerListener loadBalancerListener() {
            return this.loadBalancerListener;
        }

        public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
        }

        public void handleNewSession() throws Exception {
            this.kafka$consumer$ZookeeperConsumerConnector$ZKSessionExpireListenner$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"ZK expired; release old broker parition ownership; re-register consumer ").append((Object)this.consumerIdString()).toString());
            this.loadBalancerListener().resetState();
            this.kafka$consumer$ZookeeperConsumerConnector$ZKSessionExpireListenner$$$outer().kafka$consumer$ZookeeperConsumerConnector$$registerConsumerInZK(this.dirs(), this.consumerIdString(), this.topicCount());
            this.loadBalancerListener().syncedRebalance();
        }

        public /* synthetic */ ZookeeperConsumerConnector kafka$consumer$ZookeeperConsumerConnector$ZKSessionExpireListenner$$$outer() {
            return this.$outer;
        }

        public ZKSessionExpireListenner(ZookeeperConsumerConnector $outer, ZKGroupDirs dirs, String consumerIdString, TopicCount topicCount, ZKRebalancerListener loadBalancerListener) {
            this.dirs = dirs;
            this.consumerIdString = consumerIdString;
            this.topicCount = topicCount;
            this.loadBalancerListener = loadBalancerListener;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

