/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.nio.ByteBuffer;
import kafka.common.ErrorMapping$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.InvalidPartitionException;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.UnknownException;
import kafka.message.InvalidMessageException;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorMapping$
implements ScalaObject {
    public static final ErrorMapping$ MODULE$;
    private final ByteBuffer EMPTY_BYTEBUFFER;
    private final int UNKNOWN_CODE;
    private final int NO_ERROR;
    private final int OFFSET_OUT_OF_RANGE_CODE;
    private final int INVALID_MESSAGE_CODE;
    private final int WRONG_PARTITION_CODE;
    private final int INVALID_RETCH_SIZE_CODE;
    private final Map<Class<Throwable>, Integer> exceptionToCode;
    private final Map<Integer, Class<? extends Throwable>> codeToException;

    static {
        new ErrorMapping$();
    }

    public ByteBuffer EMPTY_BYTEBUFFER() {
        return this.EMPTY_BYTEBUFFER;
    }

    public int UNKNOWN_CODE() {
        return this.UNKNOWN_CODE;
    }

    public int NO_ERROR() {
        return this.NO_ERROR;
    }

    public int OFFSET_OUT_OF_RANGE_CODE() {
        return this.OFFSET_OUT_OF_RANGE_CODE;
    }

    public int INVALID_MESSAGE_CODE() {
        return this.INVALID_MESSAGE_CODE;
    }

    public int WRONG_PARTITION_CODE() {
        return this.WRONG_PARTITION_CODE;
    }

    public int INVALID_RETCH_SIZE_CODE() {
        return this.INVALID_RETCH_SIZE_CODE;
    }

    private Map<Class<Throwable>, Integer> exceptionToCode() {
        return this.exceptionToCode;
    }

    private Map<Integer, Class<? extends Throwable>> codeToException() {
        return this.codeToException;
    }

    public int codeFor(Class<Throwable> exception) {
        return BoxesRunTime.unboxToInt((Object)this.exceptionToCode().apply(exception));
    }

    public void maybeThrowException(int code) {
        if (code != 0) {
            throw (Throwable)((Class)this.codeToException().apply((Object)BoxesRunTime.boxToInteger((int)code))).newInstance();
        }
    }

    private ErrorMapping$() {
        MODULE$ = this;
        this.EMPTY_BYTEBUFFER = ByteBuffer.allocate(0);
        this.UNKNOWN_CODE = -1;
        this.NO_ERROR = 0;
        this.OFFSET_OUT_OF_RANGE_CODE = 1;
        this.INVALID_MESSAGE_CODE = 2;
        this.WRONG_PARTITION_CODE = 3;
        this.INVALID_RETCH_SIZE_CODE = 4;
        this.exceptionToCode = ((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(OffsetOutOfRangeException.class).$minus$greater((Object)BoxesRunTime.boxToInteger((int)this.OFFSET_OUT_OF_RANGE_CODE())), Predef$.MODULE$.any2ArrowAssoc(InvalidMessageException.class).$minus$greater((Object)BoxesRunTime.boxToInteger((int)this.INVALID_MESSAGE_CODE())), Predef$.MODULE$.any2ArrowAssoc(InvalidPartitionException.class).$minus$greater((Object)BoxesRunTime.boxToInteger((int)this.WRONG_PARTITION_CODE())), Predef$.MODULE$.any2ArrowAssoc(InvalidMessageSizeException.class).$minus$greater((Object)BoxesRunTime.boxToInteger((int)this.INVALID_RETCH_SIZE_CODE()))}))).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)this.UNKNOWN_CODE()));
        this.codeToException = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).$plus$plus((TraversableOnce)this.exceptionToCode().iterator().map((Function1)new anonfun.1())).withDefaultValue(UnknownException.class);
    }
}

