/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.subsystem;

import com.sshtools.daemon.session.SessionChannelServer;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.subsystem.SubsystemInputStream;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.subsystem.SubsystemOutputStream;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubsystemServer
implements Runnable {
    private static Log log = LogFactory.getLog((Class)SubsystemServer.class);
    private SubsystemMessageStore incoming = new SubsystemMessageStore();
    private SubsystemMessageStore outgoing = new SubsystemMessageStore();
    private SubsystemInputStream in = new SubsystemInputStream(this.outgoing);
    private SubsystemOutputStream out = new SubsystemOutputStream(this.incoming);
    private SshThread thread;
    private StartStopState state = new StartStopState(2);
    protected SessionChannelServer session;

    public void setSession(SessionChannelServer sessionChannelServer) {
        this.session = sessionChannelServer;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public void run() {
        this.state.setValue(1);
        try {
            while (this.state.getValue() == 1) {
                SubsystemMessage subsystemMessage = this.incoming.nextMessage();
                if (subsystemMessage == null) continue;
                this.onMessageReceived(subsystemMessage);
            }
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void start() {
        if (Thread.currentThread() instanceof SshThread) {
            this.thread = ((SshThread)Thread.currentThread()).cloneThread((Runnable)this, "SubsystemServer");
            this.thread.start();
        } else {
            log.error((Object)"Subsystem Server must be called from within an SshThread context");
            this.stop();
        }
    }

    public void stop() {
        this.state.setValue(2);
        this.incoming.close();
        this.outgoing.close();
    }

    public StartStopState getState() {
        return this.state;
    }

    protected abstract void onMessageReceived(SubsystemMessage var1);

    protected void registerMessage(int n, Class clazz) {
        this.incoming.registerMessage(n, clazz);
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) {
        this.outgoing.addMessage(subsystemMessage);
    }
}

