/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.KBIPasswordAuthenticationServer;
import com.sshtools.daemon.authentication.PasswordAuthenticationServer;
import com.sshtools.daemon.authentication.PublicKeyAuthenticationServer;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationServerFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";

    protected SshAuthenticationServerFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList arrayList = new ArrayList(auths.keySet());
        return arrayList;
    }

    public static SshAuthenticationServer newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationServer)((Class)auths.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog((Class)SshAuthenticationServerFactory.class);
        auths = new HashMap();
        log.info((Object)"Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationServer.class);
        auths.put(AUTH_PK, PublicKeyAuthenticationServer.class);
        auths.put(AUTH_KBI, KBIPasswordAuthenticationServer.class);
        try {
            if (ConfigurationLoader.isConfigurationAvailable((Class)SshAPIConfiguration.class)) {
                SshAPIConfiguration sshAPIConfiguration = (SshAPIConfiguration)ConfigurationLoader.getConfiguration((Class)SshAPIConfiguration.class);
                List list = sshAPIConfiguration.getAuthenticationExtensions();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                    String string = extensionAlgorithm.getAlgorithmName();
                    if (auths.containsKey(string)) {
                        log.debug((Object)("Standard authentication implementation for " + string + " is being overidden by " + extensionAlgorithm.getImplementationClass()));
                    } else {
                        log.debug((Object)(string + " authentication is implemented by " + extensionAlgorithm.getImplementationClass()));
                    }
                    try {
                        Class clazz = ConfigurationLoader.getExtensionClass((String)extensionAlgorithm.getImplementationClass());
                        Object t = clazz.newInstance();
                        if (!(t instanceof SshAuthenticationServer)) continue;
                        auths.put(string, clazz);
                    }
                    catch (Exception exception) {
                        log.warn((Object)("Failed to load extension authentication implementation " + extensionAlgorithm.getImplementationClass()), (Throwable)exception);
                    }
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

