/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgServiceRequest;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransportProtocolClient
extends TransportProtocolCommon {
    protected SshPublicKey pk;
    private HostKeyVerification hosts;
    private Map services = new HashMap();
    private SshMessageStore ms = new SshMessageStore();
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgServiceAccept;

    public TransportProtocolClient(HostKeyVerification hostKeyVerification) throws TransportProtocolException {
        this.hosts = hostKeyVerification;
    }

    public void onMessageReceived(SshMessage sshMessage) throws IOException {
        throw new IOException("No messages are registered");
    }

    public void registerTransportMessages() throws MessageAlreadyRegisteredException {
        this.ms.registerMessage(6, class$com$sshtools$j2ssh$transport$SshMsgServiceAccept == null ? (class$com$sshtools$j2ssh$transport$SshMsgServiceAccept = TransportProtocolClient.class$("com.sshtools.j2ssh.transport.SshMsgServiceAccept")) : class$com$sshtools$j2ssh$transport$SshMsgServiceAccept);
        this.addMessageStore(this.ms);
    }

    public void requestService(Service service) throws IOException {
        if (service.getState().getValue() != 1) {
            throw new IOException("The service instance must be uninitialized");
        }
        if (this.state.getValue() != 4 && this.state.getValue() != 3) {
            throw new IOException("The transport protocol is not connected");
        }
        try {
            this.state.waitForState(4);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The operation was interrupted");
        }
        service.init(1, this);
        this.services.put(service.getServiceName(), service);
        SshMessage sshMessage = new SshMsgServiceRequest(service.getServiceName());
        this.sendMessage(sshMessage, this);
        try {
            sshMessage = this.ms.getMessage(6);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for a transport protocol message");
        }
    }

    protected void onDisconnect() {
        Iterator iterator = this.services.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((Service)entry.getValue()).stop();
        }
        this.services.clear();
    }

    protected String getDecryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCEncryption(), this.serverKexInit.getSupportedSCEncryption());
    }

    protected String getEncryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSEncryption(), this.serverKexInit.getSupportedCSEncryption());
    }

    protected String getInputStreamCompAlgortihm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCComp(), this.serverKexInit.getSupportedSCComp());
    }

    protected String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCMac(), this.serverKexInit.getSupportedSCMac());
    }

    protected void setLocalIdent() {
        this.clientIdent = "SSH-2.0-" + SOFTWARE_VERSION_COMMENTS + " [CLIENT]";
    }

    public String getLocalId() {
        return this.clientIdent;
    }

    protected void setLocalKexInit(SshMsgKexInit sshMsgKexInit) {
        log.debug((Object)sshMsgKexInit.toString());
        this.clientKexInit = sshMsgKexInit;
    }

    protected SshMsgKexInit getLocalKexInit() {
        return this.clientKexInit;
    }

    protected String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSComp(), this.serverKexInit.getSupportedCSComp());
    }

    protected String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSMac(), this.serverKexInit.getSupportedCSMac());
    }

    protected void setRemoteIdent(String string) {
        this.serverIdent = string;
    }

    public String getRemoteId() {
        return this.serverIdent;
    }

    protected void setRemoteKexInit(SshMsgKexInit sshMsgKexInit) {
        this.serverKexInit = sshMsgKexInit;
    }

    protected SshMsgKexInit getRemoteKexInit() {
        return this.serverKexInit;
    }

    public SshPublicKey getServerHostKey() {
        return this.pk;
    }

    protected void onStartTransportProtocol() throws IOException {
        while (this.state.getValue() != 4 && this.state.getValue() != 5) {
            try {
                this.state.waitForStateUpdate();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("The operation was interrupted");
            }
        }
        if (this.state.getValue() == 5) {
            if (this.state.hasError()) {
                throw this.state.getLastError();
            }
            throw new TransportProtocolException("The connection did not complete");
        }
    }

    protected void performKeyExchange(SshKeyExchange sshKeyExchange) throws IOException {
        sshKeyExchange.performClientExchange(this.clientIdent, this.serverIdent, this.clientKexInit.toByteArray(), this.serverKexInit.toByteArray());
        if (!this.verifyHostKey(sshKeyExchange.getHostKey(), sshKeyExchange.getSignature(), sshKeyExchange.getExchangeHash())) {
            this.sendDisconnect(9, "The host key supplied was not valid", new KeyExchangeException("The host key is invalid or was not accepted!"));
        }
    }

    protected void setupNewKeys(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException {
        SshCipher sshCipher = SshCipherFactory.newInstance(this.getEncryptionAlgorithm());
        sshCipher.init(0, byArray2, byArray);
        this.algorithmsOut.setCipher(sshCipher);
        sshCipher = SshCipherFactory.newInstance(this.getDecryptionAlgorithm());
        sshCipher.init(1, byArray4, byArray3);
        this.algorithmsIn.setCipher(sshCipher);
        SshHmac sshHmac = SshHmacFactory.newInstance(this.getOutputStreamMacAlgorithm());
        sshHmac.init(byArray5);
        this.algorithmsOut.setHmac(sshHmac);
        sshHmac = SshHmacFactory.newInstance(this.getInputStreamMacAlgorithm());
        sshHmac.init(byArray6);
        this.algorithmsIn.setHmac(sshHmac);
    }

    protected boolean verifyHostKey(byte[] byArray, byte[] byArray2, byte[] byArray3) throws TransportProtocolException {
        String string;
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(this.determineAlgorithm(this.clientKexInit.getSupportedPublicKeys(), this.serverKexInit.getSupportedPublicKeys()));
        this.pk = sshKeyPair.setPublicKey(byArray);
        try {
            InetAddress inetAddress = InetAddress.getByName(this.properties.getHost());
            string = !inetAddress.getHostAddress().equals(this.properties.getHost()) ? inetAddress.getHostName() + "," + inetAddress.getHostAddress() : inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            log.info((Object)("The host " + this.properties.getHost() + " could not be resolved"));
            string = this.properties.getHost();
        }
        if (!this.hosts.verifyHost(string, this.pk)) {
            log.info((Object)"The host key was not accepted");
            return false;
        }
        boolean bl = this.pk.verifySignature(byArray2, byArray3);
        log.info((Object)("The host key signature is " + (bl ? " valid" : "invalid")));
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

