/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient = AgentAuthenticationClient.class$("com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient));
    protected SshAgentClient agent;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK;

    public void setAgent(SshAgentClient sshAgentClient) {
        this.agent = sshAgentClient;
    }

    public void reset() {
        this.agent = null;
    }

    public String getMethodName() {
        return "publickey";
    }

    public boolean acceptsKey(AuthenticationProtocolClient authenticationProtocolClient, String string, String string2, SshPublicKey sshPublicKey) throws IOException {
        authenticationProtocolClient.registerMessage(class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK = AgentAuthenticationClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK, 60);
        log.info((Object)"Determining if server can accept public key for authentication");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(0);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        SshMessage sshMessage = new SshMsgUserAuthRequest(string, string2, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMessage);
        try {
            sshMessage = authenticationProtocolClient.readMessage(60);
            if (sshMessage instanceof SshMsgUserAuthPKOK) {
                return true;
            }
            throw new IOException("Unexpected message returned from readMessage");
        }
        catch (TerminatedStateException terminatedStateException) {
            return false;
        }
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.agent == null) {
            throw new AuthenticationProtocolException("You must supply a username and agent");
        }
        Map map = this.agent.listKeys();
        Iterator iterator = map.entrySet().iterator();
        boolean bl = false;
        SshPublicKey sshPublicKey = null;
        while (iterator.hasNext() && !bl) {
            Map.Entry entry = iterator.next();
            sshPublicKey = (SshPublicKey)entry.getKey();
            String string2 = (String)entry.getValue();
            bl = this.acceptsKey(authenticationProtocolClient, this.getUsername(), string, sshPublicKey);
            log.info((Object)("Agent authentication with key " + sshPublicKey.getFingerprint() + " [" + string2 + "] is " + (bl ? " acceptable" : " not acceptable")));
            if (!bl) continue;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            log.info((Object)"Generating data to sign");
            log.info((Object)"Preparing public key authentication request");
            byteArrayWriter.write(1);
            byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
            byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
            ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
            byteArrayWriter2.writeBinaryString(authenticationProtocolClient.getSessionIdentifier());
            byteArrayWriter2.write(50);
            byteArrayWriter2.writeString(this.getUsername());
            byteArrayWriter2.writeString(string);
            byteArrayWriter2.writeString(this.getMethodName());
            byteArrayWriter2.write(1);
            byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
            byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
            byteArrayWriter.writeBinaryString(this.agent.hashAndSign(sshPublicKey, byteArrayWriter2.toByteArray()));
            SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, this.getMethodName(), byteArrayWriter.toByteArray());
            authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
            try {
                authenticationProtocolClient.readAuthenticationState();
            }
            catch (TerminatedStateException terminatedStateException) {
                if (terminatedStateException.getState() != 4) continue;
                throw terminatedStateException;
            }
        }
        throw new TerminatedStateException(2);
    }

    public boolean showAuthenticationDialog(Component component) {
        return false;
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
    }

    public boolean canAuthenticate() {
        return this.agent != null && this.getUsername() != null;
    }

    public boolean hasAcceptableKey(SshClient sshClient) {
        try {
            Map map = this.agent.listKeys();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                SshPublicKey sshPublicKey = (SshPublicKey)iterator.next();
                if (!sshClient.acceptsKey(this.getUsername(), sshPublicKey)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

