/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.compression;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCompressionFactory {
    public static final String COMP_NONE = "none";
    private static String defaultAlgorithm;
    private static Map comps;
    private static Log log;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$SshAPIConfiguration;

    protected SshCompressionFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCompression() {
        return defaultAlgorithm;
    }

    public static List getSupportedCompression() {
        return new ArrayList(comps.keySet());
    }

    public static SshCompression newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshCompression)((Class)comps.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory == null ? (class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory = SshCompressionFactory.class$("com.sshtools.j2ssh.transport.compression.SshCompressionFactory")) : class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory));
        comps = new HashMap();
        log.info((Object)"Loading compression methods");
        comps.put(COMP_NONE, "");
        try {
            SshAPIConfiguration sshAPIConfiguration;
            if (ConfigurationLoader.isConfigurationAvailable(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshCompressionFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration) && (sshAPIConfiguration = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshCompressionFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration)) != null) {
                List list = sshAPIConfiguration.getCompressionExtensions();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                        String string = extensionAlgorithm.getAlgorithmName();
                        if (comps.containsKey(string)) {
                            log.debug((Object)("Standard compression method " + string + " is being overidden by " + extensionAlgorithm.getImplementationClass()));
                        } else {
                            log.debug((Object)(extensionAlgorithm.getAlgorithmName() + " compression is implemented by " + extensionAlgorithm.getImplementationClass()));
                        }
                        try {
                            comps.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)("Could not locate " + extensionAlgorithm.getImplementationClass()));
                        }
                    }
                }
                defaultAlgorithm = sshAPIConfiguration.getDefaultCompression();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !comps.containsKey(defaultAlgorithm)) {
            defaultAlgorithm = COMP_NONE;
        }
    }
}

