/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransportProtocolInputStream {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$TransportProtocolInputStream == null ? (class$com$sshtools$j2ssh$transport$TransportProtocolInputStream = TransportProtocolInputStream.class$("com.sshtools.j2ssh.transport.TransportProtocolInputStream")) : class$com$sshtools$j2ssh$transport$TransportProtocolInputStream));
    private long bytesTransfered = 0L;
    private BufferedInputStream in;
    private Object sequenceLock = new Object();
    private TransportProtocolCommon transport;
    private TransportProtocolAlgorithmSync algorithms;
    private long sequenceNo = 0L;
    private long sequenceWrapLimit = BigInteger.valueOf(2L).pow(32).longValue();
    private SshCipher cipher;
    private SshHmac hmac;
    private SshCompression compression;
    int msglen;
    int padlen;
    int read;
    int remaining;
    int cipherlen = 8;
    int maclen = 0;
    ByteArrayWriter message = new ByteArrayWriter();
    byte[] initial = new byte[this.cipherlen];
    byte[] data = new byte[65535];
    byte[] buffered = new byte[65535];
    int startpos = 0;
    int endpos = 0;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$TransportProtocolInputStream;

    public TransportProtocolInputStream(TransportProtocolCommon transportProtocolCommon, InputStream inputStream, TransportProtocolAlgorithmSync transportProtocolAlgorithmSync) throws IOException {
        this.transport = transportProtocolCommon;
        this.in = new BufferedInputStream(inputStream);
        this.algorithms = transportProtocolAlgorithmSync;
    }

    public synchronized long getSequenceNo() {
        return this.sequenceNo;
    }

    protected long getNumBytesTransfered() {
        return this.bytesTransfered;
    }

    protected int available() {
        return this.endpos - this.startpos;
    }

    /*
     * Unable to fully structure code
     */
    protected int readBufferedData(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this.endpos - this.startpos < var3_3) {
            if (this.buffered.length - this.endpos < var3_3) {
                if (TransportProtocolInputStream.log.isDebugEnabled()) {
                    TransportProtocolInputStream.log.debug((Object)"Trimming used data from buffer");
                }
                System.arraycopy(this.buffered, this.startpos, this.buffered, 0, this.endpos - this.startpos);
                this.endpos -= this.startpos;
                this.startpos = 0;
                if (this.buffered.length - this.endpos < var3_3) {
                    var5_4 = new byte[this.buffered.length + var3_3];
                    System.arraycopy(this.buffered, 0, var5_4, 0, this.endpos);
                    this.buffered = var5_4;
                }
            }
            while (this.endpos - this.startpos < var3_3 && this.transport.getState().getValue() != 5) {
                block10: {
                    try {
                        var4_6 = this.in.read(this.buffered, this.endpos, this.buffered.length - this.endpos);
                        break block10;
                    }
                    catch (InterruptedIOException var5_5) {
                        var4_6 = var5_5.bytesTransferred;
                        var6_7 = this.transport.getEventHandlers().iterator();
                        ** while (var6_7.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var7_8 = (TransportProtocolEventHandler)var6_7.next();
                        var7_8.onSocketTimeout(this.transport);
                        continue;
                    }
                }
                if (var4_6 < 0) {
                    throw new IOException("The socket is EOF");
                }
                this.endpos += var4_6;
            }
        }
        System.arraycopy(this.buffered, this.startpos, var1_1, var2_2, var3_3);
        this.startpos += var3_3;
        if (this.startpos >= this.endpos) {
            this.endpos = 0;
            this.startpos = 0;
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readMessage() throws SocketException, IOException {
        int n;
        this.message.reset();
        this.read = this.readBufferedData(this.initial, 0, this.cipherlen);
        this.cipher = this.algorithms.getCipher();
        this.hmac = this.algorithms.getHmac();
        this.compression = this.algorithms.getCompression();
        this.cipherlen = this.cipher != null ? this.cipher.getBlockSize() : 8;
        if (this.initial.length != this.cipherlen) {
            byte[] byArray = new byte[this.cipherlen];
            System.arraycopy(this.initial, 0, byArray, 0, this.initial.length);
            this.initial = byArray;
        }
        if ((n = this.read) < this.initial.length) {
            n += this.readBufferedData(this.initial, n, this.initial.length - n);
        }
        this.maclen = this.hmac != null ? this.hmac.getMacLength() : 0;
        if (this.cipher != null) {
            this.initial = this.cipher.transform(this.initial);
        }
        this.message.write(this.initial);
        this.msglen = (int)ByteArrayReader.readInt(this.initial, 0);
        this.padlen = this.initial[4];
        this.remaining = this.msglen - (this.cipherlen - 4);
        this.read = this.readBufferedData(this.data, 0, this.remaining);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read " + String.valueOf(this.read) + " bytes from socket"));
        }
        this.remaining -= this.read;
        if (this.cipher != null) {
            this.message.write(this.cipher.transform(this.data, 0, this.read));
        } else {
            this.message.write(this.data, 0, this.read);
        }
        Object object = this.sequenceLock;
        synchronized (object) {
            if (this.hmac != null) {
                this.read = this.readBufferedData(this.data, 0, this.maclen);
                this.message.write(this.data, 0, this.read);
                if (!this.hmac.verify(this.sequenceNo, this.message.toByteArray())) {
                    throw new IOException("Corrupt Mac on input");
                }
            }
            this.sequenceNo = this.sequenceNo < this.sequenceWrapLimit ? ++this.sequenceNo : 0L;
        }
        this.bytesTransfered += (long)this.message.size();
        byte[] byArray = new byte[this.msglen + 4 - this.padlen];
        System.arraycopy(this.message.toByteArray(), 0, byArray, 0, this.msglen + 4 - this.padlen);
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

