/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class PropertyUtil {
    public static int stringToInt(String string, int n) {
        try {
            return string == null ? n : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static String colorToString(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('#');
        stringBuffer.append(PropertyUtil.numberToPaddedHexString(color.getRed(), 2));
        stringBuffer.append(PropertyUtil.numberToPaddedHexString(color.getGreen(), 2));
        stringBuffer.append(PropertyUtil.numberToPaddedHexString(color.getBlue(), 2));
        return stringBuffer.toString();
    }

    public static String fontToString(Font font) {
        StringBuffer stringBuffer = new StringBuffer(font.getName());
        stringBuffer.append(",");
        stringBuffer.append(font.getStyle());
        stringBuffer.append(",");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static Font stringToFont(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            return new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Color stringToColor(String string) {
        try {
            return new Color(Integer.decode("0x" + string.substring(1, 3)), Integer.decode("0x" + string.substring(3, 5)), Integer.decode("0x" + string.substring(5, 7)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad color string format. Should be #rrggbb ");
        }
    }

    public static String numberToPaddedHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        if (string.length() > n2) {
            throw new IllegalArgumentException("Number too big for padded hex string");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2 - string.length()) {
            stringBuffer.append('0');
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

