/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesStore {
    protected static Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$PreferencesStore == null ? (class$com$sshtools$common$ui$PreferencesStore = PreferencesStore.class$("com.sshtools.common.ui.PreferencesStore")) : class$com$sshtools$common$ui$PreferencesStore));
    private static File file;
    private static boolean storeAvailable;
    private static Properties preferences;
    static /* synthetic */ Class class$com$sshtools$common$ui$PreferencesStore;

    public static void saveTableMetrics(JTable jTable, String string) {
        int n = 0;
        while (n < jTable.getColumnModel().getColumnCount()) {
            int n2 = jTable.getColumnModel().getColumn(n).getWidth();
            PreferencesStore.put(string + ".column." + n + ".width", String.valueOf(n2));
            PreferencesStore.put(string + ".column." + n + ".position", String.valueOf(jTable.convertColumnIndexToModel(n)));
            ++n;
        }
    }

    public static void restoreTableMetrics(JTable jTable, String string, int[] nArray) {
        if (jTable.getAutoResizeMode() != 0) {
            throw new IllegalArgumentException("Table AutoResizeMode must be JTable.AUTO_RESIZE_OFF");
        }
        int n = 0;
        while (n < jTable.getColumnModel().getColumnCount()) {
            try {
                jTable.moveColumn(jTable.convertColumnIndexToView(PreferencesStore.getInt(string + ".column." + n + ".position", n)), n);
                jTable.getColumnModel().getColumn(n).setPreferredWidth(PreferencesStore.getInt(string + ".column." + n + ".width", nArray == null ? jTable.getColumnModel().getColumn(n).getPreferredWidth() : nArray[n]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
        }
    }

    public static boolean isStoreAvailable() {
        return storeAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(File file) {
        PreferencesStore.file = file;
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            log.info((Object)("Creating SSHTerm preferences directory " + file2.getAbsolutePath()));
            if (!file2.mkdirs()) {
                log.error((Object)("Preferences directory " + file2.getAbsolutePath() + " could not be created. " + "Preferences will not be stored"));
            }
        }
        if (!(storeAvailable = file2.exists())) return;
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            preferences.load(fileInputStream);
            storeAvailable = true;
            Object var5_3 = null;
            if (fileInputStream == null) return;
            try {
                ((InputStream)fileInputStream).close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    log.error((Object)iOException);
                    Object var5_4 = null;
                    if (fileInputStream == null) return;
                    try {
                        ((InputStream)fileInputStream).close();
                        return;
                    }
                    catch (IOException iOException2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        PreferencesStore.savePreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void savePreferences() {
        FileOutputStream fileOutputStream;
        if (file == null) {
            log.error((Object)"Preferences not saved as PreferencesStore has not been initialise.");
            return;
        } else {
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            preferences.store(fileOutputStream, "SSHTerm preferences");
            log.info((Object)("Preferences written to " + file.getAbsolutePath()));
            storeAvailable = true;
            Object var3_1 = null;
            if (fileOutputStream == null) return;
            try {
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (IOException iOException) {}
        }
        return;
        {
            catch (IOException iOException) {
                log.error((Object)iOException);
                Object var3_2 = null;
                if (fileOutputStream == null) return;
                try {
                    ((OutputStream)fileOutputStream).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String get(String string, String string2) {
        return preferences.getProperty(string, string2);
    }

    public static void put(String string, String string2) {
        preferences.put(string, string2);
    }

    public static Rectangle getRectangle(String string, Rectangle rectangle) {
        String string2 = preferences.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return rectangle;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Rectangle rectangle2 = new Rectangle();
        try {
            rectangle2.x = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.y = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.width = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.height = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)("Preference is " + string + " is badly formatted"), (Throwable)numberFormatException);
        }
        return rectangle2;
    }

    public static void putRectangle(String string, Rectangle rectangle) {
        preferences.put(string, rectangle == null ? "" : rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
    }

    public static int getInt(String string, int n) {
        String string2 = preferences.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)("Preference is " + string + " is badly formatted"), (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public static double getDouble(String string, double d) {
        String string2 = preferences.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)("Preference is " + string + " is badly formatted"), (Throwable)numberFormatException);
            }
        }
        return d;
    }

    public static void putInt(String string, int n) {
        preferences.put(string, String.valueOf(n));
    }

    public static void putDouble(String string, double d) {
        preferences.put(string, String.valueOf(d));
    }

    public static boolean getBoolean(String string, boolean bl) {
        return PreferencesStore.get(string, String.valueOf(bl)).equals("true");
    }

    public static void putBoolean(String string, boolean bl) {
        preferences.put(string, String.valueOf(bl));
    }

    public static boolean preferenceExists(String string) {
        return preferences.containsKey(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        preferences = new Properties();
    }
}

