/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.UIUtil;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultilineLabel
extends JPanel {
    private GridBagConstraints constraints = new GridBagConstraints();
    private String text;

    public MultilineLabel() {
        this("");
    }

    public MultilineLabel(String string) {
        super(new GridBagLayout());
        this.constraints.anchor = 18;
        this.constraints.fill = 0;
        this.setText(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        int n = 0;
        while (n < this.getComponentCount()) {
            this.getComponent(n).setFont(font);
            ++n;
        }
    }

    public void setText(String string) {
        this.text = string;
        this.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.constraints.weighty = 0.0;
        this.constraints.weightx = 1.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.constraints.weighty = 1.0;
            }
            UIUtil.jGridBagAdd(this, new JLabel(string2), this.constraints, 0);
        }
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }
}

