/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jsr94;

import java.rmi.RemoteException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.StatefulRuleSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springmodules.jsr94.Jsr94TransactionException;
import org.springmodules.jsr94.rulesource.RuleSource;

public class Jsr94TransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private static final long serialVersionUID = 3905803076144084279L;
    private RuleSource ruleSource;

    private void release() throws TransactionException {
        try {
            if (TransactionSynchronizationManager.hasResource((Object)this.ruleSource)) {
                this.logger.debug((Object)"Releasing session");
                StatefulRuleSession session = (StatefulRuleSession)TransactionSynchronizationManager.getResource((Object)this.ruleSource);
                session.release();
                this.logger.debug((Object)"Session released");
            }
        }
        catch (InvalidRuleSessionException ex) {
            throw new Jsr94TransactionException(ex);
        }
        catch (RemoteException ex) {
            throw new Jsr94TransactionException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ruleSource == null) {
            throw new IllegalArgumentException("Must set ruleSource on " + ((Object)((Object)this)).getClass().getName());
        }
    }

    protected Object doGetTransaction() throws TransactionException {
        Jsr94TransactionObject txObject = new Jsr94TransactionObject();
        if (TransactionSynchronizationManager.hasResource((Object)this.ruleSource)) {
            StatefulRuleSession session = (StatefulRuleSession)TransactionSynchronizationManager.getResource((Object)this.ruleSource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound session [" + session + "] for Jsr94 Transaction"));
            }
            txObject.setSession(session);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return ((Jsr94TransactionObject)transaction).hasTransaction();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Jsr94TransactionObject txObject = (Jsr94TransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.ruleSource);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        Jsr94TransactionObject txObject = (Jsr94TransactionObject)transaction;
        this.logger.debug((Object)"Beginning transaction");
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        this.release();
        this.logger.debug((Object)"Committed transaction (noop)");
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        this.release();
        this.logger.debug((Object)"Rolled back transaction (noop)");
    }

    public final void setRuleSource(RuleSource ruleSource) {
        this.ruleSource = ruleSource;
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        return transaction;
    }

    protected void doResume(Object transaction, Object arg1) throws TransactionException {
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
    }

    static class Jsr94TransactionObject {
        private StatefulRuleSession session;
        private boolean hasTransaction;

        Jsr94TransactionObject() {
        }

        public final StatefulRuleSession getSession() {
            return this.session;
        }

        public final void setSession(StatefulRuleSession session) {
            this.session = session;
        }

        public final boolean hasTransaction() {
            return this.hasTransaction;
        }

        public final void setHasTransaction(boolean hasTransaction) {
            this.hasTransaction = hasTransaction;
        }
    }
}

