/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;

public abstract class AbstractMBeanInfoAssembler
implements MBeanInfoAssembler {
    public ModelMBeanInfo getMBeanInfo(String beanKey, Class beanClass) throws JMException {
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(beanClass.getName(), this.getDescription(beanKey, beanClass), this.getAttributeInfo(beanKey, beanClass), this.getConstructorInfo(beanKey, beanClass), this.getOperationInfo(beanKey, beanClass), this.getNotificationInfo(beanKey, beanClass));
        Descriptor desc = info.getMBeanDescriptor();
        this.populateMBeanDescriptor(desc, beanKey, beanClass);
        info.setMBeanDescriptor(desc);
        return info;
    }

    protected String getDescription(String beanKey, Class beanClass) throws JMException {
        return beanClass.getName() + " instance";
    }

    protected abstract ModelMBeanAttributeInfo[] getAttributeInfo(String var1, Class var2) throws JMException;

    protected abstract ModelMBeanConstructorInfo[] getConstructorInfo(String var1, Class var2) throws JMException;

    protected abstract ModelMBeanOperationInfo[] getOperationInfo(String var1, Class var2) throws JMException;

    protected abstract ModelMBeanNotificationInfo[] getNotificationInfo(String var1, Class var2) throws JMException;

    protected void populateMBeanDescriptor(Descriptor mbeanDescriptor, String beanKey, Class beanClass) throws JMException {
    }
}

