/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

public abstract class ClassLoaderUtils {
    public static String showClassLoaderHierarchy(Object obj, String role, String delim, String tabText) {
        String s = "object of " + obj.getClass() + ": role is " + role + delim;
        return s + ClassLoaderUtils.showClassLoaderHierarchy(obj.getClass().getClassLoader(), delim, tabText, 0);
    }

    public static String showClassLoaderHierarchy(ClassLoader cl, String delim, String tabText, int indent) {
        if (cl == null) {
            String s = "null classloader " + delim;
            ClassLoader ctxcl = Thread.currentThread().getContextClassLoader();
            s = s + "Context class loader=" + ctxcl + " hc=" + ctxcl.hashCode();
            return s;
        }
        String s = "";
        for (int i = 0; i < indent; ++i) {
            s = s + tabText;
        }
        s = s + cl + " hc=" + cl.hashCode() + delim;
        ClassLoader parent = cl.getParent();
        return s + ClassLoaderUtils.showClassLoaderHierarchy(parent, delim, tabText, indent + 1);
    }

    public static String addResourcePathToPackagePath(Class clazz, String resourceName) {
        if (!resourceName.startsWith("/")) {
            return ClassLoaderUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassLoaderUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static String classNameWithoutPackagePrefix(Class clazz) {
        String name = clazz.getName();
        int lastDotIndex = name.lastIndexOf(".");
        return lastDotIndex == -1 ? name : name.substring(lastDotIndex + 1);
    }
}

