/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.jdbc.support.JdbcUtils;

public class SqlFunction
extends MappingSqlQuery {
    private int retType;

    public SqlFunction() {
    }

    public SqlFunction(DataSource ds, String sql, int[] types) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.setReturnType(4);
        this.setRowsExpected(1);
    }

    public SqlFunction(DataSource ds, String sql, int[] types, int retType) throws InvalidDataAccessApiUsageException {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.setReturnType(JdbcUtils.translateType(retType));
        this.setRowsExpected(1);
    }

    public SqlFunction(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setReturnType(4);
        this.setRowsExpected(1);
    }

    public SqlFunction(DataSource ds, String sql, int retType) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setReturnType(JdbcUtils.translateType(retType));
        this.setRowsExpected(1);
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException, InvalidDataAccessApiUsageException {
        if (rowNum != 0) {
            throw new InvalidDataAccessApiUsageException("SQL function '" + this.getSql() + "' can't return more than one row");
        }
        Object obj = null;
        switch (this.retType) {
            case 4: {
                obj = new Integer(rs.getInt(1));
                break;
            }
            case 2: {
                obj = new Double(rs.getDouble(1));
                break;
            }
            case 12: {
                obj = new String(rs.getString(1));
                break;
            }
            case -5: {
                obj = new Long(rs.getLong(1));
                break;
            }
            default: {
                obj = rs.getObject(1);
            }
        }
        return obj;
    }

    public int run() {
        Integer I = (Integer)super.findObject((Object[])null);
        return I;
    }

    public int run(int p) {
        Integer I = (Integer)super.findObject(p);
        return I;
    }

    public int run(Object[] args) {
        Integer I = (Integer)super.findObject(args);
        return I;
    }

    public Object runGeneric() {
        return super.findObject((Object[])null);
    }

    public Object runGeneric(int p) {
        return super.findObject(p);
    }

    public Object runGeneric(Object[] args) {
        return super.findObject(args);
    }

    private void setReturnType(int type) {
        this.retType = type;
    }
}

