/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NestingMessageSource;
import org.springframework.context.NoSuchMessageException;

public abstract class AbstractNestingMessageSource
implements NestingMessageSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MessageSource parent;
    private boolean useCodeAsDefaultMessage = false;

    public final void setParent(MessageSource parent) {
        this.parent = parent;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        try {
            return this.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException ex) {
            return defaultMessage;
        }
    }

    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        MessageFormat messageFormat;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((messageFormat = this.resolve(code, locale)) != null) {
            return messageFormat.format(args);
        }
        if (this.parent != null) {
            return this.parent.getMessage(code, args, locale);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not resolve message code [" + code + "] in locale [" + locale + "]"));
        }
        if (this.useCodeAsDefaultMessage) {
            return code;
        }
        throw new NoSuchMessageException(code, locale);
    }

    public final String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String[] codes = resolvable.getCodes();
        for (int i = 0; i < codes.length; ++i) {
            try {
                return this.getMessage(codes[i], resolvable.getArguments(), locale);
            }
            catch (NoSuchMessageException ex) {
                continue;
            }
        }
        if (resolvable.getDefaultMessage() != null) {
            return resolvable.getDefaultMessage();
        }
        throw new NoSuchMessageException(codes[codes.length - 1], locale);
    }

    protected abstract MessageFormat resolve(String var1, Locale var2);
}

