/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class RedirectView
extends AbstractUrlBasedView {
    public static final String DEFAULT_ENCODING_SCHEME = "UTF-8";
    private String encodingScheme = "UTF-8";

    public RedirectView() {
    }

    public RedirectView(String url) {
        this.setUrl(url);
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    protected String getEncodingScheme() {
        return this.encodingScheme;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuffer url = new StringBuffer(this.getUrl());
        boolean first = this.getUrl().indexOf(63) < 0;
        Iterator entries = this.queryProperties(model).entrySet().iterator();
        while (entries.hasNext()) {
            if (first) {
                url.append("?");
                first = false;
            } else {
                url.append("&");
            }
            Map.Entry entry = entries.next();
            String encodedKey = URLEncoder.encode(entry.getKey().toString());
            String encodedValue = entry.getValue() != null ? URLEncoder.encode(entry.getValue().toString()) : "";
            url.append(new String(encodedKey.getBytes(this.encodingScheme), this.encodingScheme));
            url.append("=");
            url.append(new String(encodedValue.getBytes(this.encodingScheme), this.encodingScheme));
        }
        response.sendRedirect(response.encodeRedirectURL(url.toString()));
    }

    protected Map queryProperties(Map model) {
        return model;
    }
}

