/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.cos;

import com.oreilly.servlet.MailMessage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

public class CosMailSenderImpl
implements MailSender {
    private String host;

    public void setHost(String host) {
        this.host = host;
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        HashMap<SimpleMailMessage, IOException> failedMessages = new HashMap<SimpleMailMessage, IOException>();
        for (int i = 0; i < simpleMessages.length; ++i) {
            try {
                int j;
                MailMessage cosMessage = new MailMessage(this.host);
                cosMessage.from(simpleMessages[i].getFrom());
                cosMessage.to(simpleMessages[i].getTo());
                if (simpleMessages[i].getCc() != null) {
                    for (j = 0; j < simpleMessages[j].getCc().length; ++j) {
                        cosMessage.cc(simpleMessages[j].getCc()[j]);
                    }
                }
                if (simpleMessages[i].getBcc() != null) {
                    for (j = 0; j < simpleMessages[j].getBcc().length; ++j) {
                        cosMessage.bcc(simpleMessages[j].getBcc()[j]);
                    }
                }
                cosMessage.setSubject(simpleMessages[i].getSubject());
                PrintStream textStream = cosMessage.getPrintStream();
                textStream.print(simpleMessages[i].getText());
                cosMessage.sendAndClose();
                continue;
            }
            catch (IOException ex) {
                failedMessages.put(simpleMessages[i], ex);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }
}

