/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import org.springframework.core.InternalErrorException;
import org.springframework.jdbc.object.SqlFunction;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class AbstractNextMaxValueProvider {
    protected boolean prefixWithZero;
    protected int paddingLength;

    public int getNextIntValue() {
        return (int)this.getNextKey(4);
    }

    public long getNextLongValue() {
        return this.getNextKey(-5);
    }

    public double getNextDoubleValue() {
        return this.getNextKey(4);
    }

    public String getNextStringValue() {
        int len;
        String s = new Integer((int)this.getNextKey(4)).toString();
        if (this.prefixWithZero && (len = s.length()) < this.paddingLength + 1) {
            StringBuffer buff = new StringBuffer(this.paddingLength);
            for (int i = 0; i < this.paddingLength - len; ++i) {
                buff.append("0");
            }
            buff.append(s);
            s = buff.toString();
        }
        return s;
    }

    public void setPrefixWithZero(boolean prefixWithZero, int length) {
        this.prefixWithZero = prefixWithZero;
        this.paddingLength = length;
    }

    protected abstract long getNextKey(int var1);

    protected long getLongValue(SqlFunction sqlf, int type) {
        long fLong = 0L;
        switch (JdbcUtils.translateType(type)) {
            case -5: {
                fLong = (Long)sqlf.runGeneric();
                break;
            }
            case 4: {
                fLong = ((Integer)sqlf.runGeneric()).intValue();
                break;
            }
            case 2: {
                fLong = (long)((Double)sqlf.runGeneric()).doubleValue();
                break;
            }
            case 12: {
                try {
                    fLong = Long.parseLong((String)sqlf.runGeneric());
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new InternalErrorException("Key value could not be converted to long");
                }
            }
            default: {
                throw new InternalErrorException("Unhandled SQL type: " + type);
            }
        }
        return fLong;
    }
}

