/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.CannotCloseJdbcConnectionException;
import org.springframework.jdbc.datasource.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.jndi.AbstractJndiLocator;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class DataSourceUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$datasource$DataSourceUtils == null ? (class$org$springframework$jdbc$datasource$DataSourceUtils = DataSourceUtils.class$("org.springframework.jdbc.datasource.DataSourceUtils")) : class$org$springframework$jdbc$datasource$DataSourceUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$DataSourceUtils;
    static /* synthetic */ Class class$java$sql$Connection;

    public static DataSource getDataSourceFromJndi(String jndiName) throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getDataSourceFromJndi(jndiName, true);
    }

    public static DataSource getDataSourceFromJndi(String jndiName, boolean inContainer) throws CannotGetJdbcConnectionException {
        if (jndiName == null || "".equals(jndiName)) {
            throw new IllegalArgumentException("jndiName must not be empty");
        }
        if (inContainer && !jndiName.startsWith(AbstractJndiLocator.CONTAINER_PREFIX)) {
            jndiName = AbstractJndiLocator.CONTAINER_PREFIX + jndiName;
        }
        try {
            return (DataSource)new JndiTemplate().lookup(jndiName);
        }
        catch (NamingException ex) {
            throw new CannotGetJdbcConnectionException("Naming exception looking up JNDI data source [" + jndiName + "]", ex);
        }
    }

    public static Connection getConnection(DataSource ds) throws CannotGetJdbcConnectionException {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource(ds);
        if (holder != null) {
            return holder.getConnection();
        }
        try {
            Connection con = ds.getConnection();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                logger.debug((Object)"Registering transaction synchronization for JDBC connection");
                TransactionSynchronizationManager.bindResource(ds, new ConnectionHolder(con));
                TransactionSynchronizationManager.registerSynchronization(new ConnectionSynchronization(con, ds));
            }
            return con;
        }
        catch (SQLException ex) {
            throw new CannotGetJdbcConnectionException(ex);
        }
    }

    public static void applyTransactionTimeout(Statement stmt, DataSource ds) throws SQLException {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource(ds);
        if (holder != null && holder.getDeadline() != null) {
            stmt.setQueryTimeout(holder.getTimeToLiveInSeconds());
        }
    }

    public static void closeConnectionIfNecessary(Connection con, DataSource ds) throws CannotCloseJdbcConnectionException {
        if (con == null || TransactionSynchronizationManager.hasResource(ds)) {
            return;
        }
        if (!(ds instanceof SmartDataSource) || ((SmartDataSource)ds).shouldClose(con)) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                throw new CannotCloseJdbcConnectionException(ex);
            }
        }
    }

    static Connection getCloseSuppressingConnectionProxy(Connection source) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = DataSourceUtils.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)new CloseSuppressingInvocationHandler(source));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionSynchronization
    implements TransactionSynchronization {
        private Connection connection;
        private DataSource dataSource;

        public ConnectionSynchronization(Connection connection, DataSource dataSource) {
            this.connection = connection;
            this.dataSource = dataSource;
        }

        public void beforeCommit() {
        }

        public void beforeCompletion() throws CannotCloseJdbcConnectionException {
            TransactionSynchronizationManager.unbindResource(this.dataSource);
            DataSourceUtils.closeConnectionIfNecessary(this.connection, this.dataSource);
        }

        public void afterCompletion(int status) {
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection source;

        private CloseSuppressingInvocationHandler(Connection source) {
            this.source = source;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.source, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

