/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;

public abstract class PropertyResourceConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Resource location;
    private Properties properties;
    private boolean ignoreResourceNotFound = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Properties props = new Properties();
        if (this.location != null) {
            this.logger.info((Object)("Loading properties file from " + this.location + ""));
            try {
                InputStream is = this.location.getInputStream();
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                String msg = "Could not load properties file from " + this.location;
                if (this.ignoreResourceNotFound) {
                    this.logger.warn((Object)(msg + ": " + ex.getMessage()));
                }
                throw new BeanInitializationException(msg, ex);
            }
        }
        if (this.properties != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying directly specified properties [" + this.properties + "]"));
            }
            props.putAll((Map<?, ?>)this.properties);
        }
        if (this.location != null || this.properties != null) {
            this.processProperties(beanFactory, props);
        } else {
            this.logger.warn((Object)"No property resource location specified");
        }
    }

    protected abstract void processProperties(ConfigurableListableBeanFactory var1, Properties var2) throws BeansException;
}

