/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.servlet.tags.RequestContextAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.TagUtils;

public class MessageTag
extends RequestContextAwareTag {
    private String code = null;
    private String text = null;
    private String var = null;
    private String scope = "page";

    public final void setCode(String code) throws JspException {
        this.code = code;
    }

    public final void setText(String text) throws JspException {
        this.text = text;
    }

    public final void setVar(String var) throws JspException {
        this.var = var;
    }

    public final void setScope(String scope) throws JspException {
        this.scope = scope;
    }

    protected final int doStartTagInternal() throws Exception {
        MessageSource messageSource = this.getMessageSource();
        if (messageSource == null) {
            throw new JspTagException("No corresponding MessageSource found");
        }
        String resolvedCode = ExpressionEvaluationUtils.evaluateString((String)"code", (String)this.code, (PageContext)this.pageContext);
        String resolvedText = ExpressionEvaluationUtils.evaluateString((String)"text", (String)this.text, (PageContext)this.pageContext);
        String resolvedVar = ExpressionEvaluationUtils.evaluateString((String)"var", (String)this.var, (PageContext)this.pageContext);
        try {
            String msg = null;
            msg = resolvedCode != null ? (resolvedText != null ? messageSource.getMessage(resolvedCode, null, resolvedText, this.getRequestContext().getLocale()) : messageSource.getMessage(resolvedCode, null, this.getRequestContext().getLocale())) : resolvedText;
            String string = msg = this.isHtmlEscape() ? HtmlUtils.htmlEscape((String)msg) : msg;
            if (resolvedVar != null) {
                String resolvedScope = ExpressionEvaluationUtils.evaluateString((String)"scope", (String)this.scope, (PageContext)this.pageContext);
                this.pageContext.setAttribute(resolvedVar, (Object)msg, TagUtils.getScope((String)resolvedScope));
            } else {
                this.writeMessage(msg);
            }
        }
        catch (NoSuchMessageException ex) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(ex));
        }
        return 1;
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(msg);
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getWebApplicationContext();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException ex) {
        return ex.getMessage();
    }

    public void release() {
        super.release();
        this.code = null;
        this.text = null;
        this.var = null;
        this.scope = "page";
    }
}

