/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.velocity;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.util.SimplePool;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.velocity.VelocityConfig;

public class VelocityView
extends AbstractUrlBasedView {
    public static final int DEFAULT_WRITER_POOL_SIZE = 40;
    public static final int OUTPUT_BUFFER_SIZE = 4096;
    private String dateToolAttribute;
    private boolean cacheTemplate;
    private SimplePool writerPool;
    private String encoding = null;
    private VelocityEngine velocityEngine;
    private Template velocityTemplate;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$velocity$VelocityConfig;

    public void setDateToolAttribute(String dateToolAttribute) {
        this.dateToolAttribute = dateToolAttribute;
    }

    public void setCacheTemplate(boolean cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setWriterPoolSize(int writerPoolSize) {
        this.writerPool = new SimplePool(writerPoolSize);
    }

    protected void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        try {
            VelocityConfig vconfig = (VelocityConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)(class$org$springframework$web$servlet$view$velocity$VelocityConfig == null ? (class$org$springframework$web$servlet$view$velocity$VelocityConfig = VelocityView.class$("org.springframework.web.servlet.view.velocity.VelocityConfig")) : class$org$springframework$web$servlet$view$velocity$VelocityConfig), (boolean)true, (boolean)true);
            this.velocityEngine = vconfig.getVelocityEngine();
        }
        catch (BeanDefinitionStoreException ex) {
            throw new ApplicationContextException("Must define a single VelocityConfig bean in this web application context (may be inherited): VelocityConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
        if (this.writerPool == null) {
            this.writerPool = new SimplePool(40);
        }
        this.encoding = (String)this.velocityEngine.getProperty("output.encoding");
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
        }
        this.loadTemplate();
    }

    private void loadTemplate() throws ApplicationContextException {
        try {
            this.velocityTemplate = this.velocityEngine.getTemplate(this.getUrl());
        }
        catch (ResourceNotFoundException ex) {
            this.handleException("Can't load Velocity template '" + this.getUrl() + "': is it available in the template directory?", (Exception)((Object)ex));
        }
        catch (ParseErrorException ex) {
            this.handleException("Error parsing Velocity template '" + this.getUrl() + "'", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            this.handleException("Unexpected error getting Velocity template '" + this.getUrl() + "'", ex);
        }
    }

    private void handleException(String message, Exception ex) throws ApplicationContextException {
        String actualMessage = "Velocity resource loader is '" + this.velocityEngine.getProperty("resource.loader") + "': " + message;
        throw new ApplicationContextException(actualMessage, (Throwable)ex);
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.cacheTemplate) {
            this.loadTemplate();
        }
        response.setContentType(this.getContentType());
        VelocityContext velocityContext = new VelocityContext();
        this.exposeModelAsContextAttributes(model, (Context)velocityContext);
        this.exposeHelpers((Context)velocityContext, request);
        if (this.dateToolAttribute != null) {
            velocityContext.put(this.dateToolAttribute, (Object)new LocaleAwareDateTool(request));
        }
        this.mergeTemplate(this.velocityTemplate, (Context)velocityContext, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Merged with Velocity template '" + this.getUrl() + "' in VelocityView '" + this.getBeanName() + "'"));
        }
    }

    private void exposeModelAsContextAttributes(Map model, Context velocityContext) {
        if (model != null) {
            Iterator itr = model.keySet().iterator();
            while (itr.hasNext()) {
                String modelName = (String)itr.next();
                Object modelObject = model.get(modelName);
                modelName = this.transformModelNameIfNecessary(modelName);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Added model attribute with name '" + modelName + "' and value [" + modelObject + "] to Velocity context in view '" + this.getBeanName() + "'"));
                }
                velocityContext.put(modelName, modelObject);
            }
        } else {
            this.logger.debug((Object)("Model is null. Nothing to expose to Velocity context in view with name '" + this.getBeanName() + "'"));
        }
    }

    protected String transformModelNameIfNecessary(String modelName) {
        return StringUtils.replace((String)modelName, (String)".", (String)"_");
    }

    protected void exposeHelpers(Context velocityContext, HttpServletRequest request) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws Exception {
        ServletOutputStream output = response.getOutputStream();
        VelocityWriter vw = null;
        try {
            vw = (VelocityWriter)this.writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter((Writer)new OutputStreamWriter((OutputStream)output, this.encoding), 4096, true);
            } else {
                vw.recycle((Writer)new OutputStreamWriter((OutputStream)output, this.encoding));
            }
            template.merge(context, (Writer)vw);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (vw != null) {
                    vw.flush();
                    this.writerPool.put((Object)vw);
                    output.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (vw != null) {
                vw.flush();
                this.writerPool.put((Object)vw);
                output.close();
            }
        }
        catch (IOException ex) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocaleAwareDateTool
    extends DateTool {
        private HttpServletRequest request;

        private LocaleAwareDateTool(HttpServletRequest request) {
            this.request = request;
        }

        public Locale getLocale() {
            return RequestContextUtils.getLocale(this.request);
        }
    }
}

